/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.rsocket.util.NumberUtils;
import java.nio.charset.StandardCharsets;

public class Metadata {
    public static final short VERSION = 1;

    public static ByteBuf encode(ByteBufAllocator allocator, String service, String method, ByteBuf metadata) {
        return Metadata.encode(allocator, service, method, Unpooled.EMPTY_BUFFER, metadata);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, String service, String method, ByteBuf tracing, ByteBuf metadata) {
        ByteBuf byteBuf = allocator.buffer().writeShort(1);
        int serviceLength = NumberUtils.requireUnsignedShort((int)ByteBufUtil.utf8Bytes((CharSequence)service));
        byteBuf.writeShort(serviceLength);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)service, (int)serviceLength);
        int methodLength = NumberUtils.requireUnsignedShort((int)ByteBufUtil.utf8Bytes((CharSequence)method));
        byteBuf.writeShort(methodLength);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)method, (int)methodLength);
        byteBuf.writeShort(tracing.readableBytes());
        byteBuf.writeBytes(tracing, tracing.readerIndex(), tracing.readableBytes());
        byteBuf.writeBytes(metadata, metadata.readerIndex(), metadata.readableBytes());
        return byteBuf;
    }

    public static int getVersion(ByteBuf byteBuf) {
        return byteBuf.getShort(0) & Short.MAX_VALUE;
    }

    public static String getService(ByteBuf byteBuf) {
        int offset = 2;
        short serviceLength = byteBuf.getShort(offset);
        return byteBuf.toString(offset += 2, (int)serviceLength, StandardCharsets.UTF_8);
    }

    public static String getMethod(ByteBuf byteBuf) {
        int offset = 2;
        short serviceLength = byteBuf.getShort(offset);
        short methodLength = byteBuf.getShort(offset += 2 + serviceLength);
        return byteBuf.toString(offset += 2, (int)methodLength, StandardCharsets.UTF_8);
    }

    public static ByteBuf getTracing(ByteBuf byteBuf) {
        int offset = 2;
        short serviceLength = byteBuf.getShort(offset);
        short methodLength = byteBuf.getShort(offset += 2 + serviceLength);
        short tracingLength = byteBuf.getShort(offset += 2 + methodLength);
        return tracingLength > 0 ? byteBuf.slice(offset += 2, (int)tracingLength) : Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf getMetadata(ByteBuf byteBuf) {
        int offset = 2;
        short serviceLength = byteBuf.getShort(offset);
        short methodLength = byteBuf.getShort(offset += 2 + serviceLength);
        short tracingLength = byteBuf.getShort(offset += 2 + methodLength);
        int metadataLength = byteBuf.readableBytes() - (offset += 2 + tracingLength);
        return metadataLength > 0 ? byteBuf.slice(offset, metadataLength) : Unpooled.EMPTY_BUFFER;
    }
}

