/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.common.spring;

import io.rsocket.broker.common.spring.ClientTransportFactory;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;

public class DefaultClientTransportFactory
implements ClientTransportFactory {
    @Override
    public boolean supports(URI uri) {
        return this.isWebsocket(uri) || this.isTcp(uri);
    }

    private boolean isTcp(URI uri) {
        return uri.getScheme().equalsIgnoreCase("tcp");
    }

    private boolean isWebsocket(URI uri) {
        return uri.getScheme().equalsIgnoreCase("ws") || uri.getScheme().equalsIgnoreCase("wss");
    }

    @Override
    public ClientTransport create(URI uri) {
        if (this.isWebsocket(uri)) {
            return WebsocketClientTransport.create((URI)uri);
        }
        if (this.isTcp(uri)) {
            return TcpClientTransport.create((String)uri.getHost(), (int)uri.getPort());
        }
        throw new IllegalArgumentException("No valid Transport configured " + uri);
    }
}

