/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.common.spring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.broker.common.spring.MimeTypes;
import io.rsocket.broker.frames.Address;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.BrokerInfo;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.RouteJoin;
import io.rsocket.broker.frames.RouteRemove;
import io.rsocket.broker.frames.RouteSetup;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BrokerFrameDecoder
extends AbstractDecoder<BrokerFrame> {
    public BrokerFrameDecoder() {
        super(new MimeType[]{MimeTypes.BROKER_FRAME_MIME_TYPE});
    }

    public Flux<BrokerFrame> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).flatMap(dataBuffer -> {
            BrokerFrame frame = this.decode((DataBuffer)dataBuffer, elementType, mimeType, hints);
            if (frame == null) {
                return Mono.empty();
            }
            return Mono.just((Object)frame);
        });
    }

    public BrokerFrame decode(DataBuffer buffer, ResolvableType targetType, MimeType mimeType, Map<String, Object> hints) throws DecodingException {
        ByteBuf byteBuf = BrokerFrameDecoder.asByteBuf(buffer);
        if (!byteBuf.isReadable()) {
            return new BrokerFrame(FrameType.RESERVED, 0){};
        }
        int flags = FrameHeaderFlyweight.flags((ByteBuf)byteBuf);
        FrameType frameType = FrameHeaderFlyweight.frameType((ByteBuf)byteBuf);
        switch (frameType) {
            case ADDRESS: {
                return Address.from((ByteBuf)byteBuf, (int)flags);
            }
            case BROKER_INFO: {
                return BrokerInfo.from((ByteBuf)byteBuf);
            }
            case ROUTE_JOIN: {
                return RouteJoin.from((ByteBuf)byteBuf);
            }
            case ROUTE_REMOVE: {
                return RouteRemove.from((ByteBuf)byteBuf);
            }
            case ROUTE_SETUP: {
                return RouteSetup.from((ByteBuf)byteBuf);
            }
        }
        throw new IllegalArgumentException("Unknown FrameType " + frameType);
    }

    private static ByteBuf asByteBuf(DataBuffer buffer) {
        return buffer instanceof NettyDataBuffer ? ((NettyDataBuffer)buffer).getNativeBuffer() : Unpooled.wrappedBuffer((ByteBuffer)buffer.asByteBuffer());
    }
}

