/*
 * Decompiled with CFR 0.152.
 */
package restx.stats;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import restx.AppSettings;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.stats.RestxStatsCollector;
import restx.stats.RestxStatsSettings;

@Machine
public class RestxStatsCollectorFactoryMachine
extends SingleNameFactoryMachine<RestxStatsCollector> {
    public static final Name<RestxStatsCollector> NAME = Name.of(RestxStatsCollector.class, (String)"RestxStatsCollector");

    public RestxStatsCollectorFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<RestxStatsCollector>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<String> appName = Factory.Query.byName((Name)Name.of(String.class, (String)"app.name")).optional();
            private final Factory.Query<String> serverType = Factory.Query.byName((Name)Name.of(String.class, (String)"restx.server.type")).optional();
            private final Factory.Query<String> serverPort = Factory.Query.byName((Name)Name.of(String.class, (String)"restx.server.port")).optional();
            private final Factory.Query<AppSettings> appSettings = Factory.Query.byClass(AppSettings.class).mandatory();
            private final Factory.Query<RestxStatsSettings> statsSettings = Factory.Query.byClass(RestxStatsSettings.class).mandatory();
            private final Factory.Query<ObjectMapper> objectMapper = Factory.Query.byClass(ObjectMapper.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.appName, this.serverType, this.serverPort, this.appSettings, this.statsSettings, this.objectMapper, (Object[])new Factory.Query[0]));
            }

            protected RestxStatsCollector doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new RestxStatsCollector((Optional<String>)satisfiedBOM.getOneAsComponent(this.appName), (Optional<String>)satisfiedBOM.getOneAsComponent(this.serverType), (Optional<String>)satisfiedBOM.getOneAsComponent(this.serverPort), (AppSettings)((NamedComponent)satisfiedBOM.getOne(this.appSettings).get()).getComponent(), (RestxStatsSettings)((NamedComponent)satisfiedBOM.getOne(this.statsSettings).get()).getComponent(), (ObjectMapper)((NamedComponent)satisfiedBOM.getOne(this.objectMapper).get()).getComponent());
            }
        });
    }
}

