/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.internal.ResponseParserRegistrar;
import io.restassured.internal.log.LogRepository;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.module.webtestclient.config.RestAssuredWebTestClientConfig;
import io.restassured.module.webtestclient.internal.WebTestClientRestAssuredResponseImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;

class ExchangeResultConverter {
    ExchangeResultConverter() {
    }

    WebTestClientRestAssuredResponseImpl toRestAssuredResponse(FluxExchangeResult<byte[]> result, WebTestClient.ResponseSpec responseSpec, final long responseTime, LogRepository logRepository, RestAssuredWebTestClientConfig config, Consumer<EntityExchangeResult<byte[]>> consumer, ResponseParserRegistrar responseParserRegistrar) {
        WebTestClientRestAssuredResponseImpl restAssuredResponse = new WebTestClientRestAssuredResponseImpl(responseSpec, logRepository);
        restAssuredResponse.setConfig(ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)config));
        byte[] responseBodyContent = Optional.ofNullable(consumer).map(theConsumer -> responseSpec.expectBody().consumeWith(theConsumer).returnResult().getResponseBodyContent()).orElseGet(() -> responseSpec.expectBody().returnResult().getResponseBodyContent());
        restAssuredResponse.setContent(responseBodyContent);
        MediaType contentType = result.getResponseHeaders().getContentType();
        restAssuredResponse.setContentType(Optional.ofNullable(contentType).map(MimeType::toString).orElse(null));
        restAssuredResponse.setHasExpectations(false);
        HttpStatus status = ExchangeResultConverter.getHttpStatusByReflection(result);
        restAssuredResponse.setStatusCode(status.value());
        List<Header> responseHeaders = this.assembleHeaders(result.getResponseHeaders());
        restAssuredResponse.setResponseHeaders(new Headers(responseHeaders));
        restAssuredResponse.setRpr(responseParserRegistrar);
        restAssuredResponse.setStatusLine(this.buildResultString(status));
        restAssuredResponse.setFilterContextProperties(new HashMap<Object, Object>(){
            {
                this.put("RA_RESPONSE_TIME_MILLIS", responseTime);
            }
        });
        restAssuredResponse.setCookies(this.convertCookies((MultiValueMap<String, ResponseCookie>)result.getResponseCookies()));
        return restAssuredResponse;
    }

    private List<Header> assembleHeaders(HttpHeaders headers) {
        return headers.keySet().stream().map(headerName -> headers.get(headerName).stream().map(headerValue -> new Header(headerName, headerValue)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String buildResultString(HttpStatus status) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(status.value());
        if (status.isError() && StringUtils.isNotBlank((CharSequence)status.getReasonPhrase())) {
            stringBuilder.append(": ");
            stringBuilder.append(status.getReasonPhrase());
        }
        return stringBuilder.toString();
    }

    private Cookies convertCookies(MultiValueMap<String, ResponseCookie> responseCookies) {
        List cookies = responseCookies.keySet().stream().map(cookie -> ((List)responseCookies.get(cookie)).stream().map(responseCookie -> new Cookie.Builder(responseCookie.getName(), responseCookie.getValue()).build()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        return new Cookies(cookies);
    }

    private static HttpStatus getHttpStatusByReflection(FluxExchangeResult<byte[]> result) {
        HttpStatus status;
        try {
            status = (HttpStatus)result.getClass().getMethod("getStatus", new Class[0]).invoke(result, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return status;
    }
}

