/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.NoAuthScheme;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseParserRegistrar;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.internal.common.classpath.ClassPathResolver;
import io.restassured.internal.filter.FilterContextImpl;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.support.PathSupport;
import io.restassured.internal.util.SafeExceptionRethrower;
import io.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import io.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import io.restassured.module.mockmvc.internal.MockMvcMultiPart;
import io.restassured.module.mockmvc.internal.MockMvcRestAssuredResponseImpl;
import io.restassured.module.mockmvc.internal.ResponseConverter;
import io.restassured.module.mockmvc.internal.RestDocsClassPathChecker;
import io.restassured.module.mockmvc.internal.SpringSecurityClassPathChecker;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import io.restassured.module.mockmvc.specification.MockMvcRequestAsyncConfigurer;
import io.restassured.module.mockmvc.specification.MockMvcRequestAsyncSender;
import io.restassured.module.mockmvc.specification.MockMvcRequestSender;
import io.restassured.module.mockmvc.util.ReflectionUtil;
import io.restassured.module.spring.commons.BodyHelper;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.ParamApplier;
import io.restassured.module.spring.commons.RequestLogger;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

class MockMvcRequestSenderImpl
implements MockMvcRequestSender,
MockMvcRequestAsyncConfigurer,
MockMvcRequestAsyncSender {
    private static final String ATTRIBUTE_NAME_URL_TEMPLATE = "org.springframework.restdocs.urlTemplate";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final boolean isSpring6OrLater = ClassPathResolver.existInCP((String)"org.springframework.aot.AotDetector");
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final MockMvc mockMvc;
    private final Map<String, Object> params;
    private final Map<String, Object> namedPathParams;
    private final Map<String, Object> queryParams;
    private final Map<String, Object> formParams;
    private final Map<String, Object> attributes;
    private final RestAssuredMockMvcConfig config;
    private final Object requestBody;
    private Headers headers;
    private final Cookies cookies;
    private final List<MockMvcMultiPart> multiParts;
    private final RequestLoggingFilter requestLoggingFilter;
    private final List<ResultHandler> resultHandlers;
    private final List<RequestPostProcessor> requestPostProcessors;
    private final MockHttpServletRequestBuilderInterceptor interceptor;
    private final String basePath;
    private final ResponseSpecification responseSpecification;
    private final Object authentication;
    private final LogRepository logRepository;
    private final boolean isAsyncRequest;
    private final Map<String, Object> sessionAttributes;

    MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> namedPathParams, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, Map<String, Object> sessionAttributes, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository) {
        this(mockMvc, params, namedPathParams, queryParams, formParams, attributes, config, requestBody, headers, cookies, sessionAttributes, multiParts, requestLoggingFilter, resultHandlers, requestPostProcessors, interceptor, basePath, responseSpecification, authentication, logRepository, false);
    }

    private MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> namedPathParams, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, Map<String, Object> sessionAttributes, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository, boolean isAsyncRequest) {
        this.mockMvc = mockMvc;
        this.params = params;
        this.namedPathParams = namedPathParams;
        this.queryParams = queryParams;
        this.formParams = formParams;
        this.attributes = attributes;
        this.config = config;
        this.requestBody = requestBody;
        this.headers = headers;
        this.cookies = cookies;
        this.sessionAttributes = sessionAttributes;
        this.multiParts = multiParts;
        this.requestLoggingFilter = requestLoggingFilter;
        this.resultHandlers = resultHandlers;
        this.requestPostProcessors = requestPostProcessors;
        this.interceptor = interceptor;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.authentication = authentication;
        this.logRepository = logRepository;
        this.isAsyncRequest = isAsyncRequest;
    }

    private Object assembleHeaders(MockHttpServletResponse response) {
        Collection headerNames = response.getHeaderNames();
        ArrayList<Header> headers = new ArrayList<Header>();
        for (String headerName : headerNames) {
            List headerValues = response.getHeaders(headerName);
            for (String headerValue : headerValues) {
                headers.add(new Header(headerName, headerValue));
            }
        }
        return new Headers(headers);
    }

    private Cookies convertCookies(Object[] servletCookies) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Object servletCookie : servletCookies) {
            String path;
            String domain;
            Cookie.Builder cookieBuilder = new Cookie.Builder((String)ReflectionUtil.invokeMethod(servletCookie, "getName", new Object[0]), (String)ReflectionUtil.invokeMethod(servletCookie, "getValue", new Object[0]));
            String comment = (String)ReflectionUtil.invokeMethod(servletCookie, "getComment", new Object[0]);
            if (comment != null) {
                cookieBuilder.setComment(comment);
            }
            if ((domain = (String)ReflectionUtil.invokeMethod(servletCookie, "getDomain", new Object[0])) != null) {
                cookieBuilder.setDomain(domain);
            }
            if ((path = (String)ReflectionUtil.invokeMethod(servletCookie, "getPath", new Object[0])) != null) {
                cookieBuilder.setPath(path);
            }
            int getMaxAge = (Integer)ReflectionUtil.invokeMethod(servletCookie, "getMaxAge", new Object[0]);
            cookieBuilder.setMaxAge((long)getMaxAge);
            cookieBuilder.setVersion(((Integer)ReflectionUtil.invokeMethod(servletCookie, "getVersion", new Object[0])).intValue());
            cookieBuilder.setSecured(((Boolean)ReflectionUtil.invokeMethod(servletCookie, "getSecure", new Object[0])).booleanValue());
            cookieBuilder.setHttpOnly(((Boolean)ReflectionUtil.invokeMethod(servletCookie, "isHttpOnly", new Object[0])).booleanValue());
            try {
                String sameSite = (String)ReflectionUtil.invokeMethod(servletCookie, "getSameSite", new Object[0]);
                if (sameSite != null) {
                    cookieBuilder.setSameSite(sameSite);
                }
            }
            catch (IllegalArgumentException sameSite) {
                // empty catch block
            }
            try {
                ZonedDateTime expires = (ZonedDateTime)ReflectionUtil.invokeMethod(servletCookie, "getExpires", new Object[0]);
                if (expires != null) {
                    cookieBuilder.setExpiryDate(Date.from(expires.toInstant()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            cookies.add(cookieBuilder.build());
        }
        return new Cookies(cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockMvcResponse performRequest(MockHttpServletRequestBuilder requestBuilder) {
        MockMvcRestAssuredResponseImpl restAssuredResponse;
        if (this.interceptor != null) {
            this.interceptor.intercept(requestBuilder);
        }
        if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath() && this.authentication instanceof Authentication) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)this.authentication);
        }
        if (this.authentication instanceof Principal) {
            requestBuilder.principal((Principal)this.authentication);
        }
        for (RequestPostProcessor requestPostProcessor : this.requestPostProcessors) {
            requestBuilder.with(requestPostProcessor);
        }
        try {
            long start = System.currentTimeMillis();
            ResultActions perform = this.mockMvc.perform((RequestBuilder)requestBuilder);
            final long responseTime = System.currentTimeMillis() - start;
            if (!this.resultHandlers.isEmpty()) {
                for (ResultHandler resultHandler : this.resultHandlers) {
                    perform.andDo(resultHandler);
                }
            }
            MvcResult mvcResult = this.getMvcResult(perform, this.isAsyncRequest);
            MockHttpServletResponse response = mvcResult.getResponse();
            restAssuredResponse = new MockMvcRestAssuredResponseImpl(perform, this.logRepository);
            restAssuredResponse.setConfig(ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config));
            restAssuredResponse.setDecoderConfig(this.config.getDecoderConfig());
            restAssuredResponse.setContent(response.getContentAsByteArray());
            restAssuredResponse.setContentType(response.getContentType());
            restAssuredResponse.setHasExpectations(false);
            restAssuredResponse.setStatusCode(response.getStatus());
            restAssuredResponse.setResponseHeaders(this.assembleHeaders(response));
            restAssuredResponse.setRpr(this.getRpr());
            restAssuredResponse.setStatusLine(this.assembleStatusLine(response, mvcResult.getResolvedException()));
            restAssuredResponse.setFilterContextProperties(new HashMap(){
                {
                    this.put("RA_RESPONSE_TIME_MILLIS", responseTime);
                }
            });
            restAssuredResponse.setCookies(this.convertCookies((Object[])ReflectionUtil.invokeMethod((Object)response, "getCookies", new Object[0])));
            if (this.responseSpecification != null) {
                this.responseSpecification.validate(ResponseConverter.toStandardResponse(restAssuredResponse));
            }
        }
        catch (Exception e) {
            MockMvcResponse mockMvcResponse = (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
            return mockMvcResponse;
        }
        finally {
            if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath()) {
                SecurityContextHolder.clearContext();
            }
        }
        return restAssuredResponse;
    }

    private MvcResult getMvcResult(ResultActions perform, boolean isAsyncRequest) throws Exception {
        MvcResult mvcResult;
        if (isAsyncRequest) {
            MvcResult startedAsyncRequestProcessing = perform.andExpect(MockMvcResultMatchers.request().asyncStarted()).andReturn();
            startedAsyncRequestProcessing.getAsyncResult(this.config.getAsyncConfig().timeoutInMs());
            mvcResult = this.mockMvc.perform(MockMvcRequestBuilders.asyncDispatch((MvcResult)startedAsyncRequestProcessing)).andReturn();
        } else {
            mvcResult = perform.andReturn();
        }
        return mvcResult;
    }

    private ResponseParserRegistrar getRpr() {
        if (this.responseSpecification instanceof ResponseSpecificationImpl) {
            return ((ResponseSpecificationImpl)this.responseSpecification).getRpr();
        }
        return new ResponseParserRegistrar();
    }

    private String assembleStatusLine(MockHttpServletResponse response, Exception resolvedException) {
        StringBuilder builder = new StringBuilder();
        builder.append(response.getStatus());
        if (StringUtils.isNotBlank((CharSequence)response.getErrorMessage())) {
            builder.append(" ").append(response.getErrorMessage());
        } else if (resolvedException != null) {
            builder.append(" ").append(resolvedException.getMessage());
        }
        return builder.toString();
    }

    private void validateUnnamedPathParams(Object[] unnamedPathParams) {
        Arrays.stream(unnamedPathParams).filter(param -> !(param instanceof String)).findAny().ifPresent(param -> {
            throw new IllegalArgumentException("Only Strings allowed in path parameters.");
        });
    }

    private void validateNamedPathParams(Map<String, Object> namedPathParams) {
        namedPathParams.entrySet().stream().filter(e -> !(e.getValue() instanceof String)).findAny().ifPresent(param -> {
            throw new IllegalArgumentException("Only Strings allowed in path parameters.");
        });
    }

    private MockMvcResponse sendRequest(HttpMethod method, String path, Object[] unnamedPathParams) {
        AssertParameter.notNull((Object)path, (String)"Path");
        this.verifyNoBodyAndMultipartTogether();
        String baseUri = this.buildBaseUri(path);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)baseUri);
        this.applyQueryParams(uriComponentsBuilder);
        this.applyPathParams(uriComponentsBuilder, baseUri, unnamedPathParams);
        String uri = uriComponentsBuilder.build().toUriString();
        MockHttpServletRequestBuilder request = this.applyMultiPartsAndGetRequest(method, uri, unnamedPathParams);
        String requestContentType = HeaderHelper.findContentType((Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        this.applyParams(request, method, requestContentType);
        this.applyFormParams(request, method, requestContentType);
        this.applyAttributes(request);
        if (RestDocsClassPathChecker.isSpringRestDocsInClasspath() && this.config.getMockMvcConfig().shouldAutomaticallyApplySpringRestDocsMockMvcSupport()) {
            request.requestAttr(ATTRIBUTE_NAME_URL_TEMPLATE, (Object)PathSupport.getPath((String)baseUri));
        }
        this.applyHeaders(request);
        if (StringUtils.isNotBlank((CharSequence)requestContentType)) {
            request.contentType(MediaType.parseMediaType((String)requestContentType));
        }
        this.applyCookies(request);
        if (!this.sessionAttributes.isEmpty()) {
            request.sessionAttrs(this.sessionAttributes);
        }
        try {
            this.applyMultipartBody(request);
        }
        catch (IOException e) {
            return (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        this.applyRequestBody(request);
        this.logRequestIfApplicable(method, baseUri, path, unnamedPathParams);
        return this.performRequest(request);
    }

    private void verifyNoBodyAndMultipartTogether() {
        if (this.requestBody != null && !this.multiParts.isEmpty()) {
            throw new IllegalStateException("You cannot specify a request body and a multi-part body in the same request. Perhaps you want to change the body to a multi part?");
        }
    }

    private String buildBaseUri(String path) {
        if (StringUtils.isNotBlank((CharSequence)this.basePath)) {
            return PathSupport.mergeAndRemoveDoubleSlash((String)this.basePath, (String)path);
        }
        return path;
    }

    private void applyQueryParams(final UriComponentsBuilder uriComponentsBuilder) {
        if (!this.queryParams.isEmpty()) {
            new ParamApplier(this.queryParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    uriComponentsBuilder.queryParam(paramName, (Object[])paramValues);
                }
            }.applyParams();
        }
    }

    private void applyPathParams(UriComponentsBuilder uriComponentsBuilder, String baseUri, Object[] unnamedPathParams) {
        this.validateUnnamedPathParams(unnamedPathParams);
        this.validateNamedPathParams(this.namedPathParams);
        Matcher pathParamMatcher = PATH_PARAM_PATTERN.matcher(baseUri);
        if (!pathParamMatcher.find()) {
            return;
        }
        if (this.namedPathParams.isEmpty() && ArrayUtils.isEmpty((Object[])unnamedPathParams)) {
            throw new IllegalArgumentException("No values were found for the request's pathParams.");
        }
        AtomicInteger nextUnnamedPathParamIndex = new AtomicInteger(0);
        Function<String, Optional> getPathParamValueFunction = param -> {
            if (this.namedPathParams.containsKey(param)) {
                return Optional.of(this.namedPathParams.get(param));
            }
            if (unnamedPathParams.length > 0) {
                return Optional.of(unnamedPathParams[nextUnnamedPathParamIndex.getAndIncrement()]);
            }
            return Optional.empty();
        };
        HashMap uriVariables = new HashMap();
        do {
            String paramName = pathParamMatcher.group(1);
            getPathParamValueFunction.apply(paramName).ifPresent(paramValue -> uriVariables.put(paramName, UriUtils.encode((String)((String)paramValue), (Charset)Charsets.UTF_8)));
        } while (pathParamMatcher.find());
        uriComponentsBuilder.uriVariables(uriVariables);
    }

    private MockHttpServletRequestBuilder applyMultiPartsAndGetRequest(HttpMethod method, String uri, Object[] unnamedPathParams) {
        if (this.multiParts.isEmpty()) {
            return MockMvcRequestBuilders.request((HttpMethod)method, (String)uri, (Object[])unnamedPathParams);
        }
        if (method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH) {
            MockHttpServletRequestBuilder request = isSpring6OrLater ? (MockHttpServletRequestBuilder)ReflectionUtil.invokeMethod(MockMvcRequestBuilders.class, "multipart", uri, unnamedPathParams) : (MockHttpServletRequestBuilder)ReflectionUtil.invokeMethod(MockMvcRequestBuilders.class, "fileUpload", new Class[]{String.class, Object[].class}, new Object[]{uri, unnamedPathParams});
            return request.with(req -> {
                req.setMethod(method.name());
                return req;
            });
        }
        throw new IllegalArgumentException("Currently multi-part file data uploading only works for POST and PUT methods");
    }

    private void applyParams(final MockHttpServletRequestBuilder request, HttpMethod method, String requestContentType) {
        if (!this.params.isEmpty()) {
            new ParamApplier(this.params){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            if (StringUtils.isBlank((CharSequence)requestContentType) && method == HttpMethod.POST && !this.isInMultiPartMode(request)) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
    }

    private void applyFormParams(final MockHttpServletRequestBuilder request, HttpMethod method, String requestContentType) {
        if (!this.formParams.isEmpty()) {
            if (method == HttpMethod.GET) {
                throw new IllegalArgumentException("Cannot use form parameters in a GET request");
            }
            new ParamApplier(this.formParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            boolean isInMultiPartMode = this.isInMultiPartMode(request);
            if (StringUtils.isBlank((CharSequence)requestContentType) && !isInMultiPartMode) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
    }

    private void applyAttributes(final MockHttpServletRequestBuilder request) {
        if (!this.attributes.isEmpty()) {
            new ParamApplier(this.attributes){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.requestAttr(paramName, (Object)paramValues[0]);
                }
            }.applyParams();
        }
    }

    private void applyHeaders(MockHttpServletRequestBuilder request) {
        if (this.headers.exist()) {
            for (Header header : this.headers) {
                request.header(header.getName(), new Object[]{header.getValue()});
            }
        }
    }

    private void applyCookies(MockHttpServletRequestBuilder request) {
        if (this.cookies.exist()) {
            for (Cookie cookie : this.cookies) {
                String cookieClassName = isSpring6OrLater ? "jakarta.servlet.http.Cookie" : "javax.servlet.http.Cookie";
                Object servletCookie = ReflectionUtil.invokeConstructor(cookieClassName, cookie.getName(), cookie.getValue());
                if (cookie.hasComment()) {
                    ReflectionUtil.invokeMethod(servletCookie, "setComment", cookie.getComment());
                }
                if (cookie.hasDomain()) {
                    ReflectionUtil.invokeMethod(servletCookie, "setDomain", cookie.getDomain());
                }
                if (cookie.hasMaxAge()) {
                    ReflectionUtil.invokeMethod(servletCookie, "setMaxAge", (int)cookie.getMaxAge());
                }
                if (cookie.hasPath()) {
                    ReflectionUtil.invokeMethod(servletCookie, "setPath", cookie.getPath());
                }
                if (cookie.hasVersion()) {
                    ReflectionUtil.invokeMethod(servletCookie, "setVersion", cookie.getVersion());
                }
                ReflectionUtil.invokeMethod(servletCookie, "setSecure", new Class[]{Boolean.TYPE}, new Object[]{cookie.isSecured()});
                ReflectionUtil.invokeMethod((Object)request, "cookie", new Class[]{this.arrayNameOf(cookieClassName)}, servletCookie);
            }
        }
    }

    private void applyMultipartBody(MockHttpServletRequestBuilder request) throws IOException {
        if (!this.multiParts.isEmpty()) {
            MockMultipartHttpServletRequestBuilder multiPartRequest = (MockMultipartHttpServletRequestBuilder)request;
            for (MockMvcMultiPart multiPart : this.multiParts) {
                MockMultipartFile multipartFile;
                String fileName = multiPart.getFileName();
                String controlName = multiPart.getControlName();
                String mimeType = multiPart.getMimeType();
                if (multiPart.isByteArray()) {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, (byte[])multiPart.getContent());
                } else if (multiPart.isFile() || multiPart.isInputStream()) {
                    InputStream inputStream = multiPart.isFile() ? new FileInputStream((File)multiPart.getContent()) : (InputStream)multiPart.getContent();
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, inputStream);
                } else {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, ((String)multiPart.getContent()).getBytes());
                }
                multiPartRequest.file(multipartFile);
            }
        }
    }

    private void applyRequestBody(MockHttpServletRequestBuilder request) {
        if (this.requestBody != null) {
            if (this.requestBody instanceof byte[]) {
                request.content((byte[])this.requestBody);
            } else if (this.requestBody instanceof File) {
                byte[] bytes = BodyHelper.toByteArray((File)((File)this.requestBody));
                request.content(bytes);
            } else {
                request.content(this.requestBody.toString());
            }
        }
    }

    private Class<?> arrayNameOf(String cookieClassName) {
        try {
            return Class.forName("[L" + cookieClassName + ";");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void setContentTypeToApplicationFormUrlEncoded(MockHttpServletRequestBuilder request) {
        MediaType mediaType = MediaType.parseMediaType((String)HeaderHelper.buildApplicationFormEncodedContentType((SpecificationConfig)this.config, (String)"application/x-www-form-urlencoded"));
        request.contentType(mediaType);
        ArrayList<Header> newHeaders = new ArrayList<Header>(this.headers.asList());
        newHeaders.add(new Header(CONTENT_TYPE, mediaType.toString()));
        this.headers = new Headers(newHeaders);
    }

    private boolean isInMultiPartMode(MockHttpServletRequestBuilder request) {
        return request instanceof MockMultipartHttpServletRequestBuilder;
    }

    private void logRequestIfApplicable(HttpMethod method, String uri, String originalPath, Object[] unnamedPathParams) {
        if (this.requestLoggingFilter == null) {
            return;
        }
        RequestSpecificationImpl reqSpec = new RequestSpecificationImpl("http://localhost", -1, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config), this.logRepository, null, true, true);
        RequestLogger.logParamsAndHeaders((RequestSpecificationImpl)reqSpec, (String)method.toString(), (String)uri, (Object[])unnamedPathParams, this.params, this.namedPathParams, this.queryParams, this.formParams, (Headers)this.headers, (Cookies)this.cookies);
        RequestLogger.logRequestBody((RequestSpecificationImpl)reqSpec, (Object)this.requestBody, (Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        if (this.multiParts != null) {
            for (MockMvcMultiPart multiPart : this.multiParts) {
                reqSpec.multiPart(new MultiPartSpecBuilder(multiPart.getContent()).controlName(multiPart.getControlName()).fileName(multiPart.getFileName()).mimeType(multiPart.getMimeType()).build());
            }
        }
        String uriPath = PathSupport.getPath((String)uri);
        String originalUriPath = PathSupport.getPath((String)originalPath);
        this.requestLoggingFilter.filter((FilterableRequestSpecification)reqSpec, null, (FilterContext)new FilterContextImpl(uri, originalUriPath, uriPath, uri, uri, new Object[0], method.toString(), null, Collections.emptyList().iterator(), new HashMap()));
    }

    public MockMvcResponse get(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.GET, path, pathParams);
    }

    public MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return this.get(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse post(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.POST, path, pathParams);
    }

    public MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return this.post(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse put(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PUT, path, pathParams);
    }

    public MockMvcResponse put(String path, Map<String, ?> pathParams) {
        return this.put(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse delete(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.DELETE, path, pathParams);
    }

    public MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return this.delete(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse head(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.HEAD, path, pathParams);
    }

    public MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return this.head(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse patch(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PATCH, path, pathParams);
    }

    public MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return this.patch(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse options(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.OPTIONS, path, pathParams);
    }

    public MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return this.options(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse get(URI uri) {
        return this.get(uri.toString(), new Object[0]);
    }

    public MockMvcResponse post(URI uri) {
        return this.post(uri.toString(), new Object[0]);
    }

    public MockMvcResponse put(URI uri) {
        return this.put(uri.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URI uri) {
        return this.delete(uri.toString(), new Object[0]);
    }

    public MockMvcResponse head(URI uri) {
        return this.head(uri.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URI uri) {
        return this.patch(uri.toString(), new Object[0]);
    }

    public MockMvcResponse options(URI uri) {
        return this.options(uri.toString(), new Object[0]);
    }

    public MockMvcResponse get(URL url) {
        return this.get(url.toString(), new Object[0]);
    }

    public MockMvcResponse post(URL url) {
        return this.post(url.toString(), new Object[0]);
    }

    public MockMvcResponse put(URL url) {
        return this.put(url.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URL url) {
        return this.delete(url.toString(), new Object[0]);
    }

    public MockMvcResponse head(URL url) {
        return this.head(url.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URL url) {
        return this.patch(url.toString(), new Object[0]);
    }

    public MockMvcResponse options(URL url) {
        return this.options(url.toString(), new Object[0]);
    }

    public MockMvcResponse get() {
        return this.get("", new Object[0]);
    }

    public MockMvcResponse post() {
        return this.post("", new Object[0]);
    }

    public MockMvcResponse put() {
        return this.put("", new Object[0]);
    }

    public MockMvcResponse delete() {
        return this.delete("", new Object[0]);
    }

    public MockMvcResponse head() {
        return this.head("", new Object[0]);
    }

    public MockMvcResponse patch() {
        return this.patch("", new Object[0]);
    }

    public MockMvcResponse options() {
        return this.options("", new Object[0]);
    }

    public MockMvcResponse request(Method method) {
        return this.request(method, "", new Object[0]);
    }

    public MockMvcResponse request(String method) {
        return this.request(method, "", new Object[0]);
    }

    public MockMvcResponse request(Method method, String path, Object ... pathParams) {
        return this.request(((Method)AssertParameter.notNull((Object)method, Method.class)).name(), path, pathParams);
    }

    public MockMvcResponse request(String method, String path, Object ... pathParams) {
        return this.sendRequest(this.toValidHttpMethod(method), path, pathParams);
    }

    public MockMvcResponse request(Method method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(Method method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(String method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(String method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    @Override
    public MockMvcRequestAsyncConfigurer with() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer and() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long duration, TimeUnit timeUnit) {
        RestAssuredMockMvcConfig newConfig = this.config.asyncConfig(new AsyncConfig(duration, timeUnit));
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.namedPathParams, this.queryParams, this.formParams, this.attributes, newConfig, this.requestBody, this.headers, this.cookies, this.sessionAttributes, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, this.isAsyncRequest);
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long durationInMs) {
        return this.timeout(durationInMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public MockMvcRequestSender then() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer async() {
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.namedPathParams, this.queryParams, this.formParams, this.attributes, this.config, this.requestBody, this.headers, this.cookies, this.sessionAttributes, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, true);
    }

    private HttpMethod toValidHttpMethod(String method) {
        String httpMethodAsString = (String)AssertParameter.notNull((Object)StringUtils.trimToNull((String)method), (String)"HTTP Method");
        HttpMethod httpMethod = HttpMethod.resolve((String)httpMethodAsString.toUpperCase());
        if (httpMethod == null) {
            throw new IllegalArgumentException("HTTP method '" + method + "' is not supported by MockMvc");
        }
        return httpMethod;
    }
}

