/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.config;

import io.restassured.config.Config;
import java.util.concurrent.TimeUnit;

public class AsyncConfig
implements Config {
    private static final long DEFAULT_TIMEOUT_IN_MILLISECONDS = TimeUnit.SECONDS.toMillis(1L);
    private final boolean userConfigured;
    private final long duration;
    private final TimeUnit timeUnit;

    public AsyncConfig() {
        this(DEFAULT_TIMEOUT_IN_MILLISECONDS, TimeUnit.MILLISECONDS, false);
    }

    public AsyncConfig(long timeoutInMs) {
        this(timeoutInMs, TimeUnit.MILLISECONDS);
    }

    public AsyncConfig(long duration, TimeUnit timeUnit) {
        this(duration, timeUnit, true);
    }

    private AsyncConfig(long duration, TimeUnit timeUnit, boolean isUserConfigured) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.duration = duration;
        this.timeUnit = timeUnit;
        this.userConfigured = isUserConfigured;
    }

    public AsyncConfig timeout(long timeoutInMs) {
        return this.timeout(timeoutInMs, TimeUnit.MILLISECONDS);
    }

    public AsyncConfig timeout(long duration, TimeUnit timeUnit) {
        return new AsyncConfig(duration, timeUnit, true);
    }

    public long timeoutInMs() {
        return TimeUnit.MILLISECONDS.convert(this.duration, this.timeUnit);
    }

    public boolean isUserConfigured() {
        return this.userConfigured;
    }

    public static AsyncConfig withTimeout(long duration, TimeUnit timeUnit) {
        return new AsyncConfig(timeUnit.toMillis(duration));
    }

    public AsyncConfig with() {
        return this;
    }

    public static AsyncConfig asyncConfig() {
        return new AsyncConfig();
    }
}

