/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.config;

import io.restassured.config.Config;
import io.restassured.internal.assertion.AssertParameter;

public class MockMvcParamConfig
implements Config {
    private final boolean userConfigured;
    private final UpdateStrategy queryParamsUpdateStrategy;
    private final UpdateStrategy formParamsUpdateStrategy;
    private final UpdateStrategy requestParameterUpdateStrategy;
    private final UpdateStrategy attributeUpdateStrategy;
    private final UpdateStrategy sessionUpdateStrategy;

    public MockMvcParamConfig() {
        this(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, false);
    }

    public MockMvcParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy, UpdateStrategy attributeUpdateStrategy, UpdateStrategy sessionUpdateStrategy) {
        this(queryParamsUpdateStrategy, formParamsUpdateStrategy, requestParameterUpdateStrategy, attributeUpdateStrategy, sessionUpdateStrategy, true);
    }

    private MockMvcParamConfig(UpdateStrategy queryParamsUpdateStrategy, UpdateStrategy formParamsUpdateStrategy, UpdateStrategy requestParameterUpdateStrategy, UpdateStrategy attributeUpdateStrategy, UpdateStrategy sessionUpdateStrategy, boolean userConfigured) {
        AssertParameter.notNull((Object)((Object)queryParamsUpdateStrategy), (String)"Query param update strategy");
        AssertParameter.notNull((Object)((Object)requestParameterUpdateStrategy), (String)"Request param update strategy");
        AssertParameter.notNull((Object)((Object)formParamsUpdateStrategy), (String)"Form param update strategy");
        AssertParameter.notNull((Object)((Object)attributeUpdateStrategy), (String)"Attribute update strategy");
        AssertParameter.notNull((Object)((Object)sessionUpdateStrategy), (String)"Session update strategy");
        this.queryParamsUpdateStrategy = queryParamsUpdateStrategy;
        this.formParamsUpdateStrategy = formParamsUpdateStrategy;
        this.requestParameterUpdateStrategy = requestParameterUpdateStrategy;
        this.attributeUpdateStrategy = attributeUpdateStrategy;
        this.userConfigured = userConfigured;
        this.sessionUpdateStrategy = sessionUpdateStrategy;
    }

    public MockMvcParamConfig mergeAllParameters() {
        return new MockMvcParamConfig(UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, UpdateStrategy.MERGE, true);
    }

    public MockMvcParamConfig replaceAllParameters() {
        return new MockMvcParamConfig(UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, UpdateStrategy.REPLACE, true);
    }

    public MockMvcParamConfig formParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, updateStrategy, this.requestParameterUpdateStrategy, this.attributeUpdateStrategy, this.sessionUpdateStrategy, true);
    }

    public MockMvcParamConfig requestParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, updateStrategy, this.attributeUpdateStrategy, this.sessionUpdateStrategy, true);
    }

    public MockMvcParamConfig queryParamsUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(updateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, this.attributeUpdateStrategy, this.sessionUpdateStrategy, true);
    }

    public MockMvcParamConfig attributeUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, updateStrategy, this.sessionUpdateStrategy, true);
    }

    public MockMvcParamConfig sessionAttributesUpdateStrategy(UpdateStrategy updateStrategy) {
        return new MockMvcParamConfig(this.queryParamsUpdateStrategy, this.formParamsUpdateStrategy, this.requestParameterUpdateStrategy, this.attributeUpdateStrategy, updateStrategy, true);
    }

    public UpdateStrategy attributeUpdateStrategy() {
        return this.formParamsUpdateStrategy;
    }

    public UpdateStrategy formParamsUpdateStrategy() {
        return this.formParamsUpdateStrategy;
    }

    public UpdateStrategy requestParamsUpdateStrategy() {
        return this.requestParameterUpdateStrategy;
    }

    public UpdateStrategy queryParamsUpdateStrategy() {
        return this.queryParamsUpdateStrategy;
    }

    public UpdateStrategy sessionAttributesUpdateStrategy() {
        return this.sessionUpdateStrategy;
    }

    public boolean isUserConfigured() {
        return this.userConfigured;
    }

    public static MockMvcParamConfig paramConfig() {
        return new MockMvcParamConfig();
    }

    public MockMvcParamConfig and() {
        return this;
    }

    public MockMvcParamConfig with() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStrategy {
        MERGE,
        REPLACE;

    }
}

