/*
 * Decompiled with CFR 0.152.
 */
package io.realm.rx;

import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.rx.RxObservableFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class RealmObservableFactory
implements RxObservableFactory {
    private boolean rxJavaAvailble;

    public RealmObservableFactory() {
        try {
            Class.forName("rx.Observable");
            this.rxJavaAvailble = true;
        }
        catch (ClassNotFoundException ignore) {
            this.rxJavaAvailble = false;
        }
    }

    @Override
    public Observable<Realm> from(final Realm realm) {
        this.checkRxJavaAvailable();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Realm>(){

            public void call(final Subscriber<? super Realm> subscriber) {
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)realm);
                        }
                    }
                };
                realm.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        realm.removeChangeListener(listener);
                    }
                }));
                subscriber.onNext((Object)realm);
            }
        });
    }

    @Override
    public Observable<DynamicRealm> from(final DynamicRealm realm) {
        this.checkRxJavaAvailable();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<DynamicRealm>(){

            public void call(final Subscriber<? super DynamicRealm> subscriber) {
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)realm);
                        }
                    }
                };
                realm.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        realm.removeChangeListener(listener);
                    }
                }));
                subscriber.onNext((Object)realm);
            }
        });
    }

    @Override
    public <E extends RealmObject> Observable<RealmResults<E>> from(Realm realm, RealmResults<E> results) {
        this.checkRxJavaAvailable();
        return this.getRealmResultsObservable(results);
    }

    @Override
    public Observable<RealmResults<DynamicRealmObject>> from(DynamicRealm realm, RealmResults<DynamicRealmObject> results) {
        this.checkRxJavaAvailable();
        return this.getRealmResultsObservable(results);
    }

    private <E extends RealmObject> Observable<RealmResults<E>> getRealmResultsObservable(final RealmResults<E> results) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RealmResults<E>>(){

            public void call(final Subscriber<? super RealmResults<E>> subscriber) {
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)results);
                        }
                    }
                };
                results.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        results.removeChangeListener(listener);
                    }
                }));
                subscriber.onNext((Object)results);
            }
        });
    }

    @Override
    public <E extends RealmObject> Observable<RealmList<E>> from(Realm realm, RealmList<E> list) {
        this.checkRxJavaAvailable();
        return this.getRealmListObservable();
    }

    @Override
    public Observable<RealmList<DynamicRealmObject>> from(DynamicRealm realm, RealmList<DynamicRealmObject> list) {
        this.checkRxJavaAvailable();
        return this.getRealmListObservable();
    }

    private <E extends RealmObject> Observable<RealmList<E>> getRealmListObservable() {
        throw new RuntimeException("RealmList does not support change listeners yet, so cannot create an Observable");
    }

    @Override
    public <E extends RealmObject> Observable<E> from(Realm realm, E object) {
        this.checkRxJavaAvailable();
        return this.getObjectObservable(object);
    }

    @Override
    public Observable<DynamicRealmObject> from(DynamicRealm realm, DynamicRealmObject object) {
        this.checkRxJavaAvailable();
        return this.getObjectObservable(object);
    }

    private <E extends RealmObject> Observable<E> getObjectObservable(final E object) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<E>(){

            public void call(final Subscriber<? super E> subscriber) {
                final RealmChangeListener listener = new RealmChangeListener(){

                    @Override
                    public void onChange() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)object);
                        }
                    }
                };
                object.addChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        object.removeChangeListener(listener);
                    }
                }));
                subscriber.onNext((Object)object);
            }
        });
    }

    @Override
    public <E extends RealmObject> Observable<RealmQuery<E>> from(Realm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    @Override
    public Observable<RealmQuery<DynamicRealmObject>> from(DynamicRealm realm, RealmQuery<DynamicRealmObject> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    private void checkRxJavaAvailable() {
        if (!this.rxJavaAvailble) {
            throw new IllegalStateException("RxJava seems to be missing from the classpath. Remember to add it as a compile dependency. See https://realm.io/docs/java/latest/#rxjava for more details.");
        }
    }

    public boolean equals(Object o) {
        return o instanceof RealmObservableFactory;
    }

    public int hashCode() {
        return 37;
    }
}

