/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.xml.bind.DatatypeConverter;

public class Utils {
    public static Types typeUtils;
    private static Messager messager;
    private static DeclaredType realmList;
    private static TypeMirror realmObject;

    public static void initialize(ProcessingEnvironment env) {
        typeUtils = env.getTypeUtils();
        messager = env.getMessager();
        realmList = typeUtils.getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmList"), typeUtils.getWildcardType(null, null));
        realmObject = env.getElementUtils().getTypeElement("io.realm.RealmObject").asType();
    }

    public static boolean isDefaultConstructor(Element constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return ((ExecutableElement)constructor).getParameters().isEmpty();
        }
        return false;
    }

    public static String lowerFirstChar(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String getProxyClassSimpleName(VariableElement field) {
        if (typeUtils.isAssignable(field.asType(), realmList)) {
            return Utils.getProxyClassName(Utils.getGenericType(field));
        }
        return Utils.getProxyClassName(Utils.getFieldTypeSimpleName(field));
    }

    public static String getProxyClassName(String clazz) {
        return clazz + "RealmProxy";
    }

    public static boolean isString(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("String");
    }

    public static boolean isPrimitiveType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals("byte") || typeString.equals("short") || typeString.equals("int") || typeString.equals("long") || typeString.equals("float") || typeString.equals("double") || typeString.equals("boolean") || typeString.equals("char");
    }

    public static boolean isBoxedType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals(Byte.class.getName()) || typeString.equals(Short.class.getName()) || typeString.equals(Integer.class.getName()) || typeString.equals(Long.class.getName()) || typeString.equals(Float.class.getName()) || typeString.equals(Double.class.getName()) || typeString.equals(Boolean.class.getName());
    }

    public static boolean isPrimitiveType(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return field.asType().getKind().isPrimitive();
    }

    public static boolean isByteArray(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("byte[]");
    }

    public static boolean isString(String fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Argument 'fieldType' cannot be null.");
        }
        return String.class.getName().equals(fieldType);
    }

    public static boolean isRealmList(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmList);
    }

    public static boolean isRealmObject(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmObject);
    }

    public static String getFieldTypeSimpleName(VariableElement field) {
        String fieldTypeCanonicalName = field.asType().toString();
        String fieldTypeName = fieldTypeCanonicalName.contains(".") ? fieldTypeCanonicalName.substring(fieldTypeCanonicalName.lastIndexOf(46) + 1) : fieldTypeCanonicalName;
        return fieldTypeName;
    }

    public static String getGenericType(VariableElement field) {
        TypeMirror fieldType = field.asType();
        List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
        if (typeArguments.size() == 0) {
            return null;
        }
        String genericCanonicalType = typeArguments.get(0).toString();
        String genericType = genericCanonicalType.contains(".") ? genericCanonicalType.substring(genericCanonicalType.lastIndexOf(46) + 1) : genericCanonicalType;
        return genericType;
    }

    public static String stripPackage(String fullyQualifiedClassName) {
        String[] parts = fullyQualifiedClassName.split("\\.");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return fullyQualifiedClassName;
    }

    public static void error(String message, Element element) {
        messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static void error(String message) {
        messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    public static void note(String message) {
        messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public static Element getSuperClass(TypeElement classType) {
        return typeUtils.asElement(classType.getSuperclass());
    }

    public static String base64Encode(String data) throws UnsupportedEncodingException {
        return DatatypeConverter.printBase64Binary((byte[])data.getBytes("UTF-8"));
    }

    public static byte[] sha256Hash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        return messageDigest.digest(data);
    }

    public static String hexStringify(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte singleByte : data) {
            stringBuilder.append(Integer.toString((singleByte & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }
}

