/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.ClassMetaData;
import io.realm.processor.Constants;
import io.realm.processor.RealmJsonTypeHelper;
import io.realm.processor.Utils;
import io.realm.processor.javawriter.JavaWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class RealmProxyClassGenerator {
    private ProcessingEnvironment processingEnvironment;
    private ClassMetaData metadata;
    private final String className;

    public RealmProxyClassGenerator(ProcessingEnvironment processingEnvironment, ClassMetaData metadata) {
        this.processingEnvironment = processingEnvironment;
        this.metadata = metadata;
        this.className = metadata.getSimpleClassName();
    }

    public void generate() throws IOException, UnsupportedOperationException {
        String qualifiedGeneratedClassName = String.format("%s.%s", "io.realm", Utils.getProxyClassName(this.className));
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter(new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm").emitEmptyLine();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("android.util.JsonReader");
        imports.add("android.util.JsonToken");
        imports.add("io.realm.RealmFieldType");
        imports.add("io.realm.exceptions.RealmMigrationNeededException");
        imports.add("io.realm.internal.ColumnInfo");
        imports.add("io.realm.internal.RealmObjectProxy");
        imports.add("io.realm.internal.Table");
        imports.add("io.realm.internal.TableOrView");
        imports.add("io.realm.internal.ImplicitTransaction");
        imports.add("io.realm.internal.LinkView");
        imports.add("io.realm.internal.android.JsonUtils");
        imports.add("java.io.IOException");
        imports.add("java.util.ArrayList");
        imports.add("java.util.Collections");
        imports.add("java.util.List");
        imports.add("java.util.Date");
        imports.add("java.util.Map");
        imports.add("java.util.HashMap");
        imports.add("org.json.JSONObject");
        imports.add("org.json.JSONException");
        imports.add("org.json.JSONArray");
        imports.add(this.metadata.getFullyQualifiedClassName());
        for (VariableElement field : this.metadata.getFields()) {
            String fieldTypeName = "";
            if (Utils.isRealmObject(field)) {
                fieldTypeName = field.asType().toString();
            } else if (Utils.isRealmList(field)) {
                fieldTypeName = ((DeclaredType)field.asType()).getTypeArguments().get(0).toString();
            }
            if (fieldTypeName.isEmpty() || imports.contains(fieldTypeName)) continue;
            imports.add(fieldTypeName);
        }
        Collections.sort(imports);
        writer.emitImports(imports);
        writer.emitEmptyLine();
        writer.beginType(qualifiedGeneratedClassName, "class", EnumSet.of(Modifier.PUBLIC), this.className, "RealmObjectProxy").emitEmptyLine();
        this.emitColumnIndicesClass(writer);
        this.emitClassFields(writer);
        this.emitConstructor(writer);
        this.emitAccessors(writer);
        this.emitInitTableMethod(writer);
        this.emitValidateTableMethod(writer);
        this.emitGetTableNameMethod(writer);
        this.emitGetFieldNamesMethod(writer);
        this.emitCreateOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        this.emitCopyOrUpdateMethod(writer);
        this.emitCopyMethod(writer);
        this.emitCreateDetachedCopyMethod(writer);
        this.emitUpdateMethod(writer);
        this.emitToStringMethod(writer);
        this.emitHashcodeMethod(writer);
        this.emitEqualsMethod(writer);
        writer.endType();
        writer.close();
    }

    private void emitColumnIndicesClass(JavaWriter writer) throws IOException {
        writer.beginType(this.columnInfoClassName(), "class", EnumSet.of(Modifier.STATIC, Modifier.FINAL), "ColumnInfo", new String[0]).emitEmptyLine();
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitField("long", this.columnIndexVarName(variableElement), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        }
        writer.emitEmptyLine();
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), "String", "path", "Table", "table");
        writer.emitStatement("final Map<String, Long> indicesMap = new HashMap<String, Long>(%s)", this.metadata.getFields().size());
        for (VariableElement variableElement : this.metadata.getFields()) {
            String columnName = variableElement.getSimpleName().toString();
            String columnIndexVarName = this.columnIndexVarName(variableElement);
            writer.emitStatement("this.%s = getValidColumnIndex(path, table, \"%s\", \"%s\")", columnIndexVarName, this.className, columnName);
            writer.emitStatement("indicesMap.put(\"%s\", this.%s)", columnName, columnIndexVarName);
            writer.emitEmptyLine();
        }
        writer.emitStatement("setIndicesMap(indicesMap)", new Object[0]);
        writer.endConstructor();
        writer.endType();
        writer.emitEmptyLine();
    }

    private void emitClassFields(JavaWriter writer) throws IOException {
        writer.emitField(this.columnInfoClassName(), "columnInfo", EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        for (VariableElement variableElement : this.metadata.getFields()) {
            if (!Utils.isRealmList(variableElement)) continue;
            String genericType = Utils.getGenericType(variableElement);
            writer.emitField("RealmList<" + genericType + ">", variableElement.getSimpleName().toString() + "RealmList", EnumSet.of(Modifier.PRIVATE));
        }
        writer.emitField("List<String>", "FIELD_NAMES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL));
        writer.beginInitializer(true);
        writer.emitStatement("List<String> fieldNames = new ArrayList<String>()", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("fieldNames.add(\"%s\")", field.getSimpleName().toString());
        }
        writer.emitStatement("FIELD_NAMES = Collections.unmodifiableList(fieldNames)", new Object[0]);
        writer.endInitializer();
        writer.emitEmptyLine();
    }

    private void emitConstructor(JavaWriter writer) throws IOException {
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), "ColumnInfo", "columnInfo");
        writer.emitStatement("this.columnInfo = (%s) columnInfo", this.columnInfoClassName());
        writer.endConstructor();
        writer.emitEmptyLine();
    }

    private void emitAccessors(JavaWriter writer) throws IOException {
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String castingBackType;
                String realmType = Constants.JAVA_TO_REALM_TYPES.get(fieldTypeCanonicalName);
                writer.emitAnnotation("Override");
                writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                if (this.metadata.isNullable(field) && !Utils.isString(field) && !Utils.isByteArray(field)) {
                    writer.beginControlFlow("if (row.isNull(%s))", this.fieldIndexVariableReference(field));
                    writer.emitStatement("return null", new Object[0]);
                    writer.endControlFlow();
                }
                if (Utils.isBoxedType(field.asType().toString())) {
                    Types typeUtils = this.processingEnvironment.getTypeUtils();
                    castingBackType = typeUtils.unboxedType(field.asType()).toString();
                } else {
                    castingBackType = fieldTypeCanonicalName;
                }
                writer.emitStatement("return (%s) row.get%s(%s)", castingBackType, realmType, this.fieldIndexVariableReference(field));
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                if (this.metadata.isNullable(field)) {
                    writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("row.setNull(%s)", this.fieldIndexVariableReference(field)).emitStatement("return", new Object[0]).endControlFlow();
                } else if (!this.metadata.isNullable(field) && !Utils.isPrimitiveType(field)) {
                    writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Trying to set non-nullable field %s to null.\")", fieldName).endControlFlow();
                }
                writer.emitStatement("row.set%s(%s, value)", realmType, this.fieldIndexVariableReference(field));
                writer.endMethod();
            } else if (Utils.isRealmObject(field)) {
                writer.emitAnnotation("Override");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.beginControlFlow("if (row.isNullLink(%s))", this.fieldIndexVariableReference(field));
                writer.emitStatement("return null", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("return realm.get(%s.class, row.getLink(%s))", fieldTypeCanonicalName, this.fieldIndexVariableReference(field));
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("row.nullifyLink(%s)", this.fieldIndexVariableReference(field));
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (!value.isValid())", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"'value' is not a valid managed object.\")", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (value.realm != this.realm)", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"'value' belongs to a different Realm.\")", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("row.setLink(%s, value.row.getIndex())", this.fieldIndexVariableReference(field));
                writer.endMethod();
            } else if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericType(field);
                writer.emitAnnotation("Override");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.emitSingleLineComment("use the cached value if available", new Object[0]);
                writer.beginControlFlow("if (" + fieldName + "RealmList != null)", new Object[0]);
                writer.emitStatement("return " + fieldName + "RealmList", new Object[0]);
                writer.nextControlFlow("else", new Object[0]);
                writer.emitStatement("LinkView linkView = row.getLinkList(%s)", this.fieldIndexVariableReference(field));
                writer.emitStatement(fieldName + "RealmList = new RealmList<%s>(%s.class, linkView, realm)", genericType, genericType);
                writer.emitStatement("return " + fieldName + "RealmList", new Object[0]);
                writer.endControlFlow();
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.emitStatement("LinkView links = row.getLinkList(%s)", this.fieldIndexVariableReference(field));
                writer.emitStatement("links.clear()", new Object[0]);
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("for (RealmObject linkedObject : (RealmList<? extends RealmObject>) value)", new Object[0]);
                writer.beginControlFlow("if (!linkedObject.isValid())", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"Each element of 'value' must be a valid managed object.\")", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (linkedObject.realm != this.realm)", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"Each element of 'value' must belong to the same Realm.\")", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("links.add(linkedObject.row.getIndex())", new Object[0]);
                writer.endControlFlow();
                writer.endMethod();
            } else {
                throw new UnsupportedOperationException(String.format("Type %s of field %s is not supported", fieldTypeCanonicalName, fieldName));
            }
            writer.emitEmptyLine();
        }
    }

    private void emitInitTableMethod(JavaWriter writer) throws IOException {
        String fieldName;
        writer.beginMethod("Table", "initTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "ImplicitTransaction", "transaction");
        writer.beginControlFlow("if (!transaction.hasTable(\"class_" + this.className + "\"))", new Object[0]);
        writer.emitStatement("Table table = transaction.getTable(\"%s%s\")", "class_", this.className);
        for (VariableElement field : this.metadata.getFields()) {
            fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String nullableFlag = this.metadata.isNullable(field) ? "Table.NULLABLE" : "Table.NOT_NULLABLE";
                writer.emitStatement("table.addColumn(%s, \"%s\", %s)", Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName), fieldName, nullableFlag);
                continue;
            }
            if (Utils.isRealmObject(field)) {
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", fieldTypeSimpleName);
                writer.emitStatement("%s%s.initTable(transaction)", fieldTypeSimpleName, "RealmProxy");
                writer.endControlFlow();
                writer.emitStatement("table.addColumnLink(RealmFieldType.OBJECT, \"%s\", transaction.getTable(\"%s%s\"))", fieldName, "class_", fieldTypeSimpleName);
                continue;
            }
            if (!Utils.isRealmList(field)) continue;
            String genericType = Utils.getGenericType(field);
            writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", genericType);
            writer.emitStatement("%s%s.initTable(transaction)", genericType, "RealmProxy");
            writer.endControlFlow();
            writer.emitStatement("table.addColumnLink(RealmFieldType.LIST, \"%s\", transaction.getTable(\"%s%s\"))", fieldName, "class_", genericType);
        }
        for (VariableElement field : this.metadata.getIndexedFields()) {
            fieldName = field.getSimpleName().toString();
            writer.emitStatement("table.addSearchIndex(table.getColumnIndex(\"%s\"))", fieldName);
        }
        if (this.metadata.hasPrimaryKey()) {
            String fieldName2 = this.metadata.getPrimaryKey().getSimpleName().toString();
            writer.emitStatement("table.setPrimaryKey(\"%s\")", fieldName2);
        } else {
            writer.emitStatement("table.setPrimaryKey(\"\")", new Object[0]);
        }
        writer.emitStatement("return table", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("return transaction.getTable(\"%s%s\")", "class_", this.className);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitValidateTableMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.columnInfoClassName(), "validateTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "ImplicitTransaction", "transaction");
        writer.beginControlFlow("if (transaction.hasTable(\"class_" + this.className + "\"))", new Object[0]);
        writer.emitStatement("Table table = transaction.getTable(\"%s%s\")", "class_", this.className);
        writer.beginControlFlow("if (table.getColumnCount() != " + this.metadata.getFields().size() + ")", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field count does not match - expected %d but was \" + table.getColumnCount())", this.metadata.getFields().size());
        writer.endControlFlow();
        writer.emitStatement("Map<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>()", new Object[0]);
        writer.beginControlFlow("for (long i = 0; i < " + this.metadata.getFields().size() + "; i++)", new Object[0]);
        writer.emitStatement("columnTypes.put(table.getColumnName(i), table.getColumnType(i))", new Object[0]);
        writer.endControlFlow();
        writer.emitEmptyLine();
        writer.emitStatement("final %1$s columnInfo = new %1$s(transaction.getPath(), table)", this.columnInfoClassName());
        writer.emitEmptyLine();
        long fieldIndex = 0L;
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != %s)", fieldName, Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName));
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s' in existing Realm file.\")", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                if (this.metadata.isNullable(field)) {
                    writer.beginControlFlow("if (!table.isColumnNullable(%s))", this.fieldIndexVariableReference(field));
                    if (Utils.isBoxedType(fieldTypeCanonicalName)) {
                        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(),\"Field '%s' does not support null values in the existing Realm file. Either set @Required, use the primitive type for field '%s' or migrate using io.realm.internal.Table.convertColumnToNullable().\")", fieldName, fieldName);
                    } else {
                        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field '%s' is required. Either set @Required to field '%s' or migrate using io.realm.internal.Table.convertColumnToNullable().\")", fieldName, fieldName);
                    }
                    writer.endControlFlow();
                } else {
                    writer.beginControlFlow("if (table.isColumnNullable(%s))", this.fieldIndexVariableReference(field));
                    if (Utils.isPrimitiveType(fieldTypeCanonicalName)) {
                        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field '%s' does support null values in the existing Realm file. Use corresponding boxed type for field '%s' or migrate using io.realm.internal.Table.convertColumnToNotNullable().\")", fieldName, fieldName);
                    } else {
                        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field '%s' does support null values in the existing Realm file. Remove @Required or @PrimaryKey from field '%s' or migrate using io.realm.internal.Table.convertColumnToNotNullable().\")", fieldName, fieldName);
                    }
                    writer.endControlFlow();
                }
                if (field.equals(this.metadata.getPrimaryKey())) {
                    writer.beginControlFlow("if (table.getPrimaryKey() != table.getColumnIndex(\"%s\"))", fieldName);
                    writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Primary key not defined for field '%s' in existing Realm file. Add @PrimaryKey.\")", fieldName);
                    writer.endControlFlow();
                }
                if (this.metadata.getIndexedFields().contains(field)) {
                    writer.beginControlFlow("if (!table.hasSearchIndex(table.getColumnIndex(\"%s\")))", fieldName);
                    writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Index not defined for field '%s' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().\")", fieldName);
                    writer.endControlFlow();
                }
            } else if (Utils.isRealmObject(field)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != RealmFieldType.OBJECT)", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s'\")", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", fieldTypeSimpleName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing class '%s%s' for field '%s'\")", "class_", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = transaction.getTable(\"%s%s\")", fieldIndex, "class_", fieldTypeSimpleName);
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", this.fieldIndexVariableReference(field), fieldIndex);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid RealmObject for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", fieldName, this.fieldIndexVariableReference(field), fieldIndex);
                writer.endControlFlow();
            } else if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericType(field);
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s'\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != RealmFieldType.LIST)", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s'\")", genericType, fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", genericType);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing class '%s%s' for field '%s'\")", "class_", genericType, fieldName);
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = transaction.getTable(\"%s%s\")", fieldIndex, "class_", genericType);
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", this.fieldIndexVariableReference(field), fieldIndex);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid RealmList type for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", fieldName, this.fieldIndexVariableReference(field), fieldIndex);
                writer.endControlFlow();
            }
            ++fieldIndex;
        }
        writer.emitStatement("return %s", "columnInfo");
        writer.nextControlFlow("else", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"The %s class is missing from the schema for this Realm.\")", this.metadata.getSimpleClassName());
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetTableNameMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("String", "getTableName", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return \"%s%s\"", "class_", this.className);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetFieldNamesMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("List<String>", "getFieldNames", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return FIELD_NAMES", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "copyOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "Realm", "realm", this.className, "object", "boolean", "update", "Map<RealmObject,RealmObjectProxy>", "cache");
        writer.beginControlFlow("if (object.realm != null && object.realm.getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return object", new Object[0]).endControlFlow();
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("return copy(realm, object, update, cache)", new Object[0]);
        } else {
            writer.emitStatement("%s realmObject = null", this.className).emitStatement("boolean canUpdate = update", new Object[0]).beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", this.className).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
            if (Utils.isString(this.metadata.getPrimaryKey())) {
                writer.beginControlFlow("if (object.%s() == null)", this.metadata.getPrimaryKeyGetter()).emitStatement("throw new IllegalArgumentException(\"Primary key value must not be null.\")", new Object[0]).endControlFlow().emitStatement("long rowIndex = table.findFirstString(pkColumnIndex, object.%s())", this.metadata.getPrimaryKeyGetter());
            } else {
                writer.emitStatement("long rowIndex = table.findFirstLong(pkColumnIndex, object.%s())", this.metadata.getPrimaryKeyGetter());
            }
            writer.beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).emitStatement("realmObject = new %s(realm.schema.getColumnInfo(%s.class))", Utils.getProxyClassName(this.className), this.className).emitStatement("realmObject.realm = realm", new Object[0]).emitStatement("realmObject.row = table.getUncheckedRow(rowIndex)", new Object[0]).emitStatement("cache.put(object, (RealmObjectProxy) realmObject)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("canUpdate = false", new Object[0]).endControlFlow();
            writer.endControlFlow();
            writer.emitEmptyLine().beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("return update(realm, realmObject, object, cache)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("return copy(realm, object, update, cache)", new Object[0]).endControlFlow();
        }
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "copy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "Realm", "realm", this.className, "newObject", "boolean", "update", "Map<RealmObject,RealmObjectProxy>", "cache");
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s realmObject = realm.createObject(%s.class, newObject.%s())", this.className, this.className, this.metadata.getPrimaryKeyGetter());
        } else {
            writer.emitStatement("%s realmObject = realm.createObject(%s.class)", this.className, this.className);
        }
        writer.emitStatement("cache.put(newObject, (RealmObjectProxy) realmObject)", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmObject(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = newObject.%s()", fieldType, fieldName, getter).beginControlFlow("if (%sObj != null)", fieldName).emitStatement("%s cache%s = (%s) cache.get(%sObj)", fieldType, fieldName, fieldType, fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("realmObject.%s(cache%s)", setter, fieldName).nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(%s.copyOrUpdate(realm, %sObj, update, cache))", this.metadata.getSetter(fieldName), Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(null)", setter).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = newObject.%s()", Utils.getGenericType(field), fieldName, getter).beginControlFlow("if (%sList != null)", fieldName).emitStatement("RealmList<%s> %sRealmList = realmObject.%s()", Utils.getGenericType(field), fieldName, getter).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", fieldName).emitStatement("%s %sItem = %sList.get(i)", Utils.getGenericType(field), fieldName, fieldName).emitStatement("%s cache%s = (%s) cache.get(%sItem)", Utils.getGenericType(field), fieldName, Utils.getGenericType(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("%sRealmList.add(cache%s)", fieldName, fieldName).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), update, cache))", fieldName, Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            writer.emitStatement("realmObject.%s(newObject.%s())", this.metadata.getSetter(fieldName), getter);
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateDetachedCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "createDetachedCopy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), this.className, "realmObject", "int", "currentDepth", "int", "maxDepth", "Map<RealmObject, CacheData<RealmObject>>", "cache");
        writer.beginControlFlow("if (currentDepth > maxDepth || realmObject == null)", new Object[0]).emitStatement("return null", new Object[0]).endControlFlow().emitStatement("CacheData<%s> cachedObject = (CacheData) cache.get(realmObject)", this.className).emitStatement("%s standaloneObject", this.className).beginControlFlow("if (cachedObject != null)", new Object[0]).emitSingleLineComment("Reuse cached object or recreate it because it was encountered at a lower depth.", new Object[0]).beginControlFlow("if (currentDepth >= cachedObject.minDepth)", new Object[0]).emitStatement("return cachedObject.object", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("standaloneObject = cachedObject.object", new Object[0]).emitStatement("cachedObject.minDepth = currentDepth", new Object[0]).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("standaloneObject = new %s()", this.className).emitStatement("cache.put(realmObject, new RealmObjectProxy.CacheData<RealmObject>(currentDepth, standaloneObject))", new Object[0]).endControlFlow();
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmObject(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", fieldName).emitStatement("standaloneObject.%s(%s.createDetachedCopy(realmObject.%s(), currentDepth + 1, maxDepth, cache))", setter, Utils.getProxyClassSimpleName(field), getter);
                continue;
            }
            if (Utils.isRealmList(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", fieldName).beginControlFlow("if (currentDepth == maxDepth)", new Object[0]).emitStatement("standaloneObject.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("RealmList<%s> managed%sList = realmObject.%s()", Utils.getGenericType(field), fieldName, getter).emitStatement("RealmList<%1$s> standalone%2$sList = new RealmList<%1$s>()", Utils.getGenericType(field), fieldName).emitStatement("standaloneObject.%s(standalone%sList)", setter, fieldName).emitStatement("int nextDepth = currentDepth + 1", new Object[0]).emitStatement("int size = managed%sList.size()", fieldName).beginControlFlow("for (int i = 0; i < size; i++)", new Object[0]).emitStatement("%s item = %s.createDetachedCopy(managed%sList.get(i), nextDepth, maxDepth, cache)", Utils.getGenericType(field), Utils.getProxyClassSimpleName(field), fieldName).emitStatement("standalone%sList.add(item)", fieldName).endControlFlow().endControlFlow();
                continue;
            }
            writer.emitStatement("standaloneObject.%s(realmObject.%s())", this.metadata.getSetter(fieldName), getter);
        }
        writer.emitStatement("return standaloneObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitUpdateMethod(JavaWriter writer) throws IOException {
        if (!this.metadata.hasPrimaryKey()) {
            return;
        }
        writer.beginMethod(this.className, "update", EnumSet.of(Modifier.STATIC), "Realm", "realm", this.className, "realmObject", this.className, "newObject", "Map<RealmObject, RealmObjectProxy>", "cache");
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmObject(field)) {
                writer.emitStatement("%s %sObj = newObject.%s()", Utils.getFieldTypeSimpleName(field), fieldName, getter).beginControlFlow("if (%sObj != null)", fieldName).emitStatement("%s cache%s = (%s) cache.get(%sObj)", Utils.getFieldTypeSimpleName(field), fieldName, Utils.getFieldTypeSimpleName(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("realmObject.%s(cache%s)", this.metadata.getSetter(fieldName), fieldName).nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(%s.copyOrUpdate(realm, %sObj, true, cache))", this.metadata.getSetter(fieldName), Utils.getProxyClassSimpleName(field), fieldName, Utils.getFieldTypeSimpleName(field)).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(null)", setter).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                writer.emitStatement("RealmList<%s> %sList = newObject.%s()", Utils.getGenericType(field), fieldName, getter).emitStatement("RealmList<%s> %sRealmList = realmObject.%s()", Utils.getGenericType(field), fieldName, getter).emitStatement("%sRealmList.clear()", fieldName).beginControlFlow("if (%sList != null)", fieldName).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", fieldName).emitStatement("%s %sItem = %sList.get(i)", Utils.getGenericType(field), fieldName, fieldName).emitStatement("%s cache%s = (%s) cache.get(%sItem)", Utils.getGenericType(field), fieldName, Utils.getGenericType(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("%sRealmList.add(cache%s)", fieldName, fieldName).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), true, cache))", fieldName, Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (field == this.metadata.getPrimaryKey()) continue;
            writer.emitStatement("realmObject.%s(newObject.%s())", this.metadata.getSetter(fieldName), getter);
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitToStringMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("String", "toString", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.beginControlFlow("if (!isValid())", new Object[0]);
        writer.emitStatement("return \"Invalid object\"", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("StringBuilder stringBuilder = new StringBuilder(\"%s = [\")", this.className);
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            writer.emitStatement("stringBuilder.append(\"{%s:\")", fieldName);
            if (Utils.isRealmObject(field)) {
                String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(%s() != null ? \"%s\" : \"null\")", this.metadata.getGetter(fieldName), fieldTypeSimpleName);
            } else if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericType(field);
                writer.emitStatement("stringBuilder.append(\"RealmList<%s>[\").append(%s().size()).append(\"]\")", genericType, this.metadata.getGetter(fieldName));
            } else if (this.metadata.isNullable(field)) {
                writer.emitStatement("stringBuilder.append(%s() != null ? %s() : \"null\")", this.metadata.getGetter(fieldName), this.metadata.getGetter(fieldName));
            } else {
                writer.emitStatement("stringBuilder.append(%s())", this.metadata.getGetter(fieldName));
            }
            writer.emitStatement("stringBuilder.append(\"}\")", new Object[0]);
            if (i >= fields.size() - 1) continue;
            writer.emitStatement("stringBuilder.append(\",\")", new Object[0]);
        }
        writer.emitStatement("stringBuilder.append(\"]\")", new Object[0]);
        writer.emitStatement("return stringBuilder.toString()", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitHashcodeMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("String realmName = realm.getPath()", new Object[0]);
        writer.emitStatement("String tableName = row.getTable().getName()", new Object[0]);
        writer.emitStatement("long rowIndex = row.getIndex()", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("int result = 17", new Object[0]);
        writer.emitStatement("result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32))", new Object[0]);
        writer.emitStatement("return result", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitEqualsMethod(JavaWriter writer) throws IOException {
        String proxyClassName = this.className + "RealmProxy";
        writer.emitAnnotation("Override");
        writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), "Object", "o");
        writer.emitStatement("if (this == o) return true", new Object[0]);
        writer.emitStatement("if (o == null || getClass() != o.getClass()) return false", new Object[0]);
        writer.emitStatement("%s a%s = (%s)o", proxyClassName, this.className, proxyClassName);
        writer.emitEmptyLine();
        writer.emitStatement("String path = realm.getPath()", new Object[0]);
        writer.emitStatement("String otherPath = a%s.realm.getPath()", this.className);
        writer.emitStatement("if (path != null ? !path.equals(otherPath) : otherPath != null) return false;", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("String tableName = row.getTable().getName()", new Object[0]);
        writer.emitStatement("String otherTableName = a%s.row.getTable().getName()", this.className);
        writer.emitStatement("if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("if (row.getIndex() != a%s.row.getIndex()) return false", this.className);
        writer.emitEmptyLine();
        writer.emitStatement("return true", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.beginMethod(this.className, "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JSONObject", "json", "boolean", "update"), Arrays.asList("JSONException"));
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s obj = realm.createObject(%s.class)", this.className, this.className);
        } else {
            String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
            writer.emitStatement("%s obj = null", this.className).beginControlFlow("if (update)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", this.className).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]).beginControlFlow("if (!json.isNull(\"%s\"))", this.metadata.getPrimaryKey().getSimpleName()).emitStatement("long rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()).beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).emitStatement("obj = new %s(realm.schema.getColumnInfo(%s.class))", Utils.getProxyClassName(this.className), this.className).emitStatement("obj.realm = realm", new Object[0]).emitStatement("obj.row = table.getUncheckedRow(rowIndex)", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
            writer.beginControlFlow("if (obj == null)", new Object[0]);
            String primaryKeyFieldType = this.metadata.getPrimaryKey().asType().toString();
            String primaryKeyFieldName = this.metadata.getPrimaryKey().getSimpleName().toString();
            RealmJsonTypeHelper.emitCreateObjectWithPrimaryKeyValue(this.className, primaryKeyFieldType, primaryKeyFieldName, writer);
            writer.endControlFlow();
        }
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (Utils.isRealmObject(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectWithJsonValue(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmList(field)) {
                RealmJsonTypeHelper.emitFillRealmListWithJsonValue(this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), fieldName, ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeWithJsonValue(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.beginMethod(this.className, "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JsonReader", "reader"), Arrays.asList("IOException"));
        writer.emitStatement("%s obj = realm.createObject(%s.class)", this.className, this.className);
        writer.emitStatement("reader.beginObject()", new Object[0]);
        writer.beginControlFlow("while (reader.hasNext())", new Object[0]);
        writer.emitStatement("String name = reader.nextName()", new Object[0]);
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (i == 0) {
                writer.beginControlFlow("if (name.equals(\"%s\"))", fieldName);
            } else {
                writer.nextControlFlow("else if (name.equals(\"%s\"))", fieldName);
            }
            if (Utils.isRealmObject(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectFromStream(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmList(field)) {
                RealmJsonTypeHelper.emitFillRealmListFromStream(this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeFromStream(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        if (fields.size() > 0) {
            writer.nextControlFlow("else", new Object[0]);
            writer.emitStatement("reader.skipValue()", new Object[0]);
            writer.endControlFlow();
        }
        writer.endControlFlow();
        writer.emitStatement("reader.endObject()", new Object[0]);
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private String columnInfoClassName() {
        return this.className + "ColumnInfo";
    }

    private String columnIndexVarName(VariableElement variableElement) {
        return variableElement.getSimpleName().toString() + "Index";
    }

    private String fieldIndexVariableReference(VariableElement variableElement) {
        return "columnInfo." + this.columnIndexVarName(variableElement);
    }
}

