/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.RealmClass;
import io.realm.processor.ClassMetaData;
import io.realm.processor.DefaultModuleGenerator;
import io.realm.processor.ModuleMetaData;
import io.realm.processor.RealmAnalytics;
import io.realm.processor.RealmProxyClassGenerator;
import io.realm.processor.RealmProxyMediatorGenerator;
import io.realm.processor.RealmVersionChecker;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"io.realm.annotations.RealmClass", "io.realm.annotations.Ignore", "io.realm.annotations.Index", "io.realm.annotations.PrimaryKey", "io.realm.annotations.RealmModule", "io.realm.annotations.Required"})
public class RealmProcessor
extends AbstractProcessor {
    Set<ClassMetaData> classesToValidate = new HashSet<ClassMetaData>();
    private boolean hasProcessedModules = false;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.hasProcessedModules) {
            return true;
        }
        RealmVersionChecker updateChecker = RealmVersionChecker.getInstance(this.processingEnv);
        updateChecker.executeRealmVersionUpdate();
        Utils.initialize(this.processingEnv);
        TreeSet<String> packages = new TreeSet<String>();
        for (Element element : roundEnv.getElementsAnnotatedWith(RealmClass.class)) {
            ClassMetaData metadata;
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                Utils.error("The RealmClass annotation can only be applied to classes", element);
            }
            if (!(metadata = new ClassMetaData(this.processingEnv, (TypeElement)element)).isModelClass()) continue;
            Utils.note("Processing class " + metadata.getSimpleClassName());
            boolean success = metadata.generate();
            if (!success) {
                return true;
            }
            this.classesToValidate.add(metadata);
            packages.add(metadata.getPackageName());
            RealmProxyClassGenerator sourceCodeGenerator = new RealmProxyClassGenerator(this.processingEnv, metadata);
            try {
                sourceCodeGenerator.generate();
            }
            catch (IOException e) {
                Utils.error(e.getMessage(), element);
            }
            catch (UnsupportedOperationException e) {
                Utils.error(e.getMessage(), element);
            }
        }
        String environmentVariable = System.getenv("REALM_DISABLE_ANALYTICS");
        if (environmentVariable == null || !environmentVariable.equals("true")) {
            RealmAnalytics realmAnalytics = RealmAnalytics.getInstance(packages);
            realmAnalytics.execute();
        }
        this.hasProcessedModules = true;
        return this.processModules(roundEnv);
    }

    private boolean processModules(RoundEnvironment roundEnv) {
        ModuleMetaData moduleMetaData = new ModuleMetaData(roundEnv, this.classesToValidate);
        if (!moduleMetaData.generate(this.processingEnv)) {
            return false;
        }
        if (moduleMetaData.shouldCreateDefaultModule() && !this.createDefaultModule()) {
            return false;
        }
        for (Map.Entry<String, Set<ClassMetaData>> module : moduleMetaData.getAllModules().entrySet()) {
            if (this.createMediator(Utils.stripPackage(module.getKey()), module.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean createDefaultModule() {
        Utils.note("Creating DefaultRealmModule");
        DefaultModuleGenerator defaultModuleGenerator = new DefaultModuleGenerator(this.processingEnv);
        try {
            defaultModuleGenerator.generate();
        }
        catch (IOException e) {
            Utils.error(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createMediator(String simpleModuleName, Set<ClassMetaData> moduleClasses) {
        RealmProxyMediatorGenerator mediatorImplGenerator = new RealmProxyMediatorGenerator(this.processingEnv, simpleModuleName, moduleClasses);
        try {
            mediatorImplGenerator.generate();
        }
        catch (IOException e) {
            Utils.error(e.getMessage());
            return false;
        }
        return true;
    }
}

