/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.Group;
import io.realm.internal.SharedGroup;

public class WriteTransaction
extends Group {
    private final SharedGroup db;
    private boolean committed;

    @Override
    public void commit() {
        if (this.committed) {
            throw new IllegalStateException("You can only commit once after a WriteTransaction has been made.");
        }
        this.db.commit();
        this.committed = true;
    }

    public void rollback() {
        this.db.rollback();
    }

    @Override
    public void close() {
        if (!this.committed) {
            this.rollback();
        }
    }

    WriteTransaction(Context context, SharedGroup db, long nativePtr) {
        super(context, nativePtr, false);
        this.db = db;
        this.committed = false;
    }

    @Override
    protected void finalize() {
    }
}

