/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.Sort;
import io.realm.internal.Context;
import io.realm.internal.Mixed;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import java.io.Closeable;
import java.util.Date;
import java.util.List;

public class TableView
implements TableOrView,
Closeable {
    private static final boolean DEBUG = false;
    private final TableQuery query;
    protected long nativePtr;
    protected final Table parent;
    private final Context context;

    protected TableView(Context context, Table parent, long nativePtr) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePtr;
        this.query = null;
    }

    protected TableView(Context context, Table parent, long nativePtr, TableQuery query) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePtr;
        this.query = query;
    }

    @Override
    public Table getTable() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                TableView.nativeClose(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeTableView(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public long size() {
        return this.nativeSize(this.nativePtr);
    }

    public long getSourceRowIndex(long rowIndex) {
        return this.nativeGetSourceRowIndex(this.nativePtr, rowIndex);
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    @Override
    public long getLong(long columnIndex, long rowIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public boolean getBoolean(long columnIndex, long rowIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public float getFloat(long columnIndex, long rowIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public double getDouble(long columnIndex, long rowIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public Date getDate(long columnIndex, long rowIndex) {
        return new Date(this.nativeGetDateTimeValue(this.nativePtr, columnIndex, rowIndex) * 1000L);
    }

    @Override
    public String getString(long columnIndex, long rowIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public byte[] getBinaryByteArray(long columnIndex, long rowIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public RealmFieldType getMixedType(long columnIndex, long rowIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetMixedType(this.nativePtr, columnIndex, rowIndex));
    }

    @Override
    public Mixed getMixed(long columnIndex, long rowIndex) {
        return this.nativeGetMixed(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public long getLink(long columnIndex, long rowIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public Table getSubtable(long columnIndex, long rowIndex) {
        this.context.executeDelayedDisposal();
        long nativeSubtablePtr = this.nativeGetSubtable(this.nativePtr, columnIndex, rowIndex);
        try {
            return new Table(this.context, this.parent, nativeSubtablePtr);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeSubtablePtr);
            throw e;
        }
    }

    @Override
    public long getSubtableSize(long columnIndex, long rowIndex) {
        return this.nativeGetSubtableSize(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void clearSubtable(long columnIndex, long rowIndex) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeClearSubtable(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void setLong(long columnIndex, long rowIndex, long value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetLong(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setBoolean(long columnIndex, long rowIndex, boolean value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setFloat(long columnIndex, long rowIndex, float value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setDouble(long columnIndex, long rowIndex, double value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setDate(long columnIndex, long rowIndex, Date value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetDateTimeValue(this.nativePtr, columnIndex, rowIndex, value.getTime() / 1000L);
    }

    @Override
    public void setString(long columnIndex, long rowIndex, String value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetString(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setBinaryByteArray(long columnIndex, long rowIndex, byte[] data) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, data);
    }

    @Override
    public void setMixed(long columnIndex, long rowIndex, Mixed data) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetMixed(this.nativePtr, columnIndex, rowIndex, data);
    }

    @Override
    public void setLink(long columnIndex, long rowIndex, long value) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeSetLink(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public boolean isNullLink(long columnIndex, long rowIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void nullifyLink(long columnIndex, long rowIndex) {
        this.nativeNullifyLink(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void clear() {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeClear(this.nativePtr);
    }

    @Override
    public void remove(long rowIndex) {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        this.nativeRemoveRow(this.nativePtr, rowIndex);
    }

    @Override
    public void removeLast() {
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        if (!this.isEmpty()) {
            this.nativeRemoveRow(this.nativePtr, this.size() - 1L);
        }
    }

    @Override
    public long findFirstLong(long columnIndex, long value) {
        return this.nativeFindFirstInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstBoolean(long columnIndex, boolean value) {
        return this.nativeFindFirstBool(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstFloat(long columnIndex, float value) {
        return this.nativeFindFirstFloat(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDouble(long columnIndex, double value) {
        return this.nativeFindFirstDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDate(long columnIndex, Date date) {
        return this.nativeFindFirstDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
    }

    @Override
    public long findFirstString(long columnIndex, String value) {
        return this.nativeFindFirstString(this.nativePtr, columnIndex, value);
    }

    @Override
    public long lowerBoundLong(long columnIndex, long value) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public long upperBoundLong(long columnIndex, long value) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public TableView findAllLong(long columnIndex, long value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllInt(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllBoolean(long columnIndex, boolean value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllBool(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllFloat(long columnIndex, float value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllFloat(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllDouble(long columnIndex, double value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDouble(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllDate(long columnIndex, Date date) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllString(long columnIndex, String value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllString(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public long sumLong(long columnIndex) {
        return this.nativeSumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long maximumLong(long columnIndex) {
        return this.nativeMaximumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long minimumLong(long columnIndex) {
        return this.nativeMinimumInt(this.nativePtr, columnIndex);
    }

    @Override
    public double averageLong(long columnIndex) {
        return this.nativeAverageInt(this.nativePtr, columnIndex);
    }

    @Override
    public double sumFloat(long columnIndex) {
        return this.nativeSumFloat(this.nativePtr, columnIndex);
    }

    @Override
    public Float maximumFloat(long columnIndex) {
        return this.nativeMaximumFloat(this.nativePtr, columnIndex);
    }

    @Override
    public Float minimumFloat(long columnIndex) {
        return this.nativeMinimumFloat(this.nativePtr, columnIndex);
    }

    @Override
    public double averageFloat(long columnIndex) {
        return this.nativeAverageFloat(this.nativePtr, columnIndex);
    }

    @Override
    public double sumDouble(long columnIndex) {
        return this.nativeSumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double maximumDouble(long columnIndex) {
        return this.nativeMaximumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double minimumDouble(long columnIndex) {
        return this.nativeMinimumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public double averageDouble(long columnIndex) {
        return this.nativeAverageDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Date maximumDate(long columnIndex) {
        Long result = this.nativeMaximumDate(this.nativePtr, columnIndex);
        if (result == null) {
            return null;
        }
        return new Date(result * 1000L);
    }

    @Override
    public Date minimumDate(long columnIndex) {
        Long result = this.nativeMinimumDate(this.nativePtr, columnIndex);
        if (result == null) {
            return null;
        }
        return new Date(result * 1000L);
    }

    public void sort(long columnIndex, Sort sortOrder) {
        this.nativeSort(this.nativePtr, columnIndex, sortOrder.getValue());
    }

    public void sort(long columnIndex) {
        this.nativeSort(this.nativePtr, columnIndex, true);
    }

    public void sort(List<Long> columnIndices, Sort[] sortOrders) {
        long[] indices = new long[columnIndices.size()];
        for (int i = 0; i < columnIndices.size(); ++i) {
            indices[i] = columnIndices.get(i);
        }
        boolean[] nativeSortOrder = TableQuery.getNativeSortOrderValues(sortOrders);
        this.nativeSortMulti(this.nativePtr, indices, nativeSortOrder);
    }

    @Override
    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    @Override
    public String toString() {
        return this.nativeToString(this.nativePtr, 500L);
    }

    @Override
    public String toString(long maxRows) {
        return this.nativeToString(this.nativePtr, maxRows);
    }

    @Override
    public String rowToString(long rowIndex) {
        return this.nativeRowToString(this.nativePtr, rowIndex);
    }

    @Override
    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativePtr);
        try {
            return new TableQuery(this.context, this.parent, nativeQueryPtr, this);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }

    @Override
    public long count(long columnIndex, String value) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public Table pivot(long stringCol, long intCol, TableOrView.PivotType pivotType) {
        if (!this.getColumnType(stringCol).equals((Object)RealmFieldType.STRING)) {
            throw new UnsupportedOperationException("Group by column must be of type String");
        }
        if (!this.getColumnType(intCol).equals((Object)RealmFieldType.INTEGER)) {
            throw new UnsupportedOperationException("Aggregation column must be of type Int");
        }
        Table result = new Table();
        this.nativePivot(this.nativePtr, stringCol, intCol, pivotType.value, result.nativePtr);
        return result;
    }

    @Override
    public long sync() {
        return this.nativeSync(this.nativePtr);
    }

    static native void nativeClose(long var0);

    private native long nativeSize(long var1);

    private native long nativeGetSourceRowIndex(long var1, long var3);

    private native long nativeGetColumnCount(long var1);

    private native String nativeGetColumnName(long var1, long var3);

    private native long nativeGetColumnIndex(long var1, String var3);

    private native int nativeGetColumnType(long var1, long var3);

    private native long nativeGetLong(long var1, long var3, long var5);

    private native boolean nativeGetBoolean(long var1, long var3, long var5);

    private native float nativeGetFloat(long var1, long var3, long var5);

    private native double nativeGetDouble(long var1, long var3, long var5);

    private native long nativeGetDateTimeValue(long var1, long var3, long var5);

    private native String nativeGetString(long var1, long var3, long var5);

    private native byte[] nativeGetByteArray(long var1, long var3, long var5);

    private native int nativeGetMixedType(long var1, long var3, long var5);

    private native Mixed nativeGetMixed(long var1, long var3, long var5);

    private native long nativeGetLink(long var1, long var3, long var5);

    private native long nativeGetSubtable(long var1, long var3, long var5);

    private native long nativeGetSubtableSize(long var1, long var3, long var5);

    private native void nativeClearSubtable(long var1, long var3, long var5);

    private native void nativeSetLong(long var1, long var3, long var5, long var7);

    private native void nativeSetBoolean(long var1, long var3, long var5, boolean var7);

    private native void nativeSetFloat(long var1, long var3, long var5, float var7);

    private native void nativeSetDouble(long var1, long var3, long var5, double var7);

    private native void nativeSetDateTimeValue(long var1, long var3, long var5, long var7);

    private native void nativeSetString(long var1, long var3, long var5, String var7);

    private native void nativeSetByteArray(long var1, long var3, long var5, byte[] var7);

    private native void nativeSetMixed(long var1, long var3, long var5, Mixed var7);

    private native void nativeSetLink(long var1, long var3, long var5, long var7);

    private native boolean nativeIsNullLink(long var1, long var3, long var5);

    private native void nativeNullifyLink(long var1, long var3, long var5);

    private native void nativeClear(long var1);

    private native void nativeRemoveRow(long var1, long var3);

    private native long nativeFindFirstInt(long var1, long var3, long var5);

    private native long nativeFindFirstBool(long var1, long var3, boolean var5);

    private native long nativeFindFirstFloat(long var1, long var3, float var5);

    private native long nativeFindFirstDouble(long var1, long var3, double var5);

    private native long nativeFindFirstDate(long var1, long var3, long var5);

    private native long nativeFindFirstString(long var1, long var3, String var5);

    private native long nativeFindAllInt(long var1, long var3, long var5);

    private native long nativeFindAllBool(long var1, long var3, boolean var5);

    private native long nativeFindAllFloat(long var1, long var3, float var5);

    private native long nativeFindAllDouble(long var1, long var3, double var5);

    private native long nativeFindAllDate(long var1, long var3, long var5);

    private native long nativeSumInt(long var1, long var3);

    private native long nativeFindAllString(long var1, long var3, String var5);

    private native Long nativeMaximumInt(long var1, long var3);

    private native Long nativeMinimumInt(long var1, long var3);

    private native double nativeAverageInt(long var1, long var3);

    private native double nativeSumFloat(long var1, long var3);

    private native Float nativeMaximumFloat(long var1, long var3);

    private native Float nativeMinimumFloat(long var1, long var3);

    private native double nativeAverageFloat(long var1, long var3);

    private native double nativeSumDouble(long var1, long var3);

    private native Double nativeMaximumDouble(long var1, long var3);

    private native Double nativeMinimumDouble(long var1, long var3);

    private native double nativeAverageDouble(long var1, long var3);

    private native Long nativeMaximumDate(long var1, long var3);

    private native Long nativeMinimumDate(long var1, long var3);

    private native void nativeSort(long var1, long var3, boolean var5);

    private native void nativeSortMulti(long var1, long[] var3, boolean[] var4);

    private native long createNativeTableView(Table var1, long var2);

    private native String nativeToJson(long var1);

    private native String nativeToString(long var1, long var3);

    private native String nativeRowToString(long var1, long var3);

    private native long nativeWhere(long var1);

    private native void nativePivot(long var1, long var3, long var5, int var7, long var8);

    private native long nativeSync(long var1);
}

