/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.Sort;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import io.realm.internal.CheckedRow;
import io.realm.internal.Context;
import io.realm.internal.Group;
import io.realm.internal.Mixed;
import io.realm.internal.RealmCore;
import io.realm.internal.SubtableSchema;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import io.realm.internal.TableSchema;
import io.realm.internal.TableSpec;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import java.io.Closeable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class Table
implements TableOrView,
TableSchema,
Closeable {
    public static final int TABLE_MAX_LENGTH = 56;
    public static final String TABLE_PREFIX = Util.getTablePrefix();
    public static final long INFINITE = -1L;
    public static final String STRING_DEFAULT_VALUE = "";
    public static final long INTEGER_DEFAULT_VALUE = 0L;
    public static final String METADATA_TABLE_NAME = "metadata";
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    private static final String PRIMARY_KEY_TABLE_NAME = "pk";
    private static final String PRIMARY_KEY_CLASS_COLUMN_NAME = "pk_table";
    private static final long PRIMARY_KEY_CLASS_COLUMN_INDEX = 0L;
    private static final String PRIMARY_KEY_FIELD_COLUMN_NAME = "pk_property";
    private static final long PRIMARY_KEY_FIELD_COLUMN_INDEX = 1L;
    private static final long NO_PRIMARY_KEY = -2L;
    protected long nativePtr;
    protected final Object parent;
    private final Context context;
    private long cachedPrimaryKeyColumnIndex = -1L;
    protected int tableNo;
    private static final boolean DEBUG = false;
    static AtomicInteger tableCount = new AtomicInteger(0);

    public Table() {
        this.parent = null;
        this.context = new Context();
        this.nativePtr = this.createNative();
        if (this.nativePtr == 0L) {
            throw new OutOfMemoryError("Out of native memory.");
        }
    }

    Table(Context context, Object parent, long nativePointer) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePointer;
    }

    @Override
    public Table getTable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                Table.nativeClose(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                boolean isRoot = this.parent == null;
                this.context.asyncDisposeTable(this.nativePtr, isRoot);
                this.nativePtr = 0L;
            }
        }
    }

    public boolean isValid() {
        return this.nativePtr != 0L && this.nativeIsValid(this.nativePtr);
    }

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    @Override
    public TableSchema getSubtableSchema(long columnIndex) {
        if (!this.nativeIsRootTable(this.nativePtr)) {
            throw new UnsupportedOperationException("This is a subtable. Can only be called on root table.");
        }
        long[] newPath = new long[]{columnIndex};
        return new SubtableSchema(this.nativePtr, newPath);
    }

    public long addColumn(RealmFieldType type, String name, boolean isNullable) {
        this.verifyColumnName(name);
        return this.nativeAddColumn(this.nativePtr, type.getNativeValue(), name, isNullable);
    }

    @Override
    public long addColumn(RealmFieldType type, String name) {
        return this.addColumn(type, name, false);
    }

    public long addColumnLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnLink(this.nativePtr, type.getNativeValue(), name, table.nativePtr);
    }

    @Override
    public void removeColumn(long columnIndex) {
        this.nativeRemoveColumn(this.nativePtr, columnIndex);
    }

    @Override
    public void renameColumn(long columnIndex, String newName) {
        this.verifyColumnName(newName);
        this.nativeRenameColumn(this.nativePtr, columnIndex, newName);
    }

    public boolean isColumnNullable(long columnIndex) {
        return this.nativeIsColumnNullable(this.nativePtr, columnIndex);
    }

    public void convertColumnToNullable(long columnIndex) {
        this.nativeConvertColumnToNullable(this.nativePtr, columnIndex);
    }

    public void convertColumnToNotNullable(long columnIndex) {
        this.nativeConvertColumnToNotNullable(this.nativePtr, columnIndex);
    }

    public void updateFromSpec(TableSpec tableSpec) {
        this.checkImmutable();
        this.nativeUpdateFromSpec(this.nativePtr, tableSpec);
    }

    @Override
    public long size() {
        return this.nativeSize(this.nativePtr);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void clear() {
        this.checkImmutable();
        this.nativeClear(this.nativePtr);
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    public TableSpec getTableSpec() {
        return this.nativeGetTableSpec(this.nativePtr);
    }

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    @Override
    public void remove(long rowIndex) {
        this.checkImmutable();
        this.nativeRemove(this.nativePtr, rowIndex);
    }

    @Override
    public void removeLast() {
        this.checkImmutable();
        this.nativeRemoveLast(this.nativePtr);
    }

    public void moveLastOver(long rowIndex) {
        this.checkImmutable();
        this.nativeMoveLastOver(this.nativePtr, rowIndex);
    }

    public long addEmptyRow() {
        this.checkImmutable();
        if (this.hasPrimaryKey()) {
            long primaryKeyColumnIndex = this.getPrimaryKey();
            RealmFieldType type = this.getColumnType(primaryKeyColumnIndex);
            switch (type) {
                case STRING: {
                    if (this.findFirstString(primaryKeyColumnIndex, STRING_DEFAULT_VALUE) == -1L) break;
                    this.throwDuplicatePrimaryKeyException(STRING_DEFAULT_VALUE);
                    break;
                }
                case INTEGER: {
                    if (this.findFirstLong(primaryKeyColumnIndex, 0L) == -1L) break;
                    this.throwDuplicatePrimaryKeyException(0L);
                    break;
                }
                default: {
                    throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
                }
            }
        }
        return this.nativeAddEmptyRow(this.nativePtr, 1L);
    }

    public long addEmptyRowWithPrimaryKey(Object primaryKeyValue) {
        long rowIndex;
        this.checkImmutable();
        this.checkHasPrimaryKey();
        long primaryKeyColumnIndex = this.getPrimaryKey();
        RealmFieldType type = this.getColumnType(primaryKeyColumnIndex);
        switch (type) {
            case STRING: {
                if (!(primaryKeyValue instanceof String)) {
                    throw new IllegalArgumentException("Primary key value is not a String: " + primaryKeyValue);
                }
                if (this.findFirstString(primaryKeyColumnIndex, (String)primaryKeyValue) != -1L) {
                    this.throwDuplicatePrimaryKeyException(primaryKeyValue);
                }
                rowIndex = this.nativeAddEmptyRow(this.nativePtr, 1L);
                UncheckedRow row = this.getUncheckedRow(rowIndex);
                row.setString(primaryKeyColumnIndex, (String)primaryKeyValue);
                break;
            }
            case INTEGER: {
                long pkValue;
                try {
                    pkValue = Long.parseLong(primaryKeyValue.toString());
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Primary key value is not a long: " + primaryKeyValue);
                }
                if (this.findFirstLong(primaryKeyColumnIndex, pkValue) != -1L) {
                    this.throwDuplicatePrimaryKeyException(pkValue);
                }
                rowIndex = this.nativeAddEmptyRow(this.nativePtr, 1L);
                UncheckedRow row = this.getUncheckedRow(rowIndex);
                row.setLong(primaryKeyColumnIndex, pkValue);
                break;
            }
            default: {
                throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
            }
        }
        return rowIndex;
    }

    public long addEmptyRows(long rows) {
        this.checkImmutable();
        if (rows < 1L) {
            throw new IllegalArgumentException("'rows' must be > 0.");
        }
        if (this.hasPrimaryKey()) {
            if (rows > 1L) {
                throw new RealmException("Multiple empty rows cannot be created if a primary key is defined for the table.");
            }
            return this.addEmptyRow();
        }
        return this.nativeAddEmptyRow(this.nativePtr, rows);
    }

    protected long add(Object ... values) {
        long rowIndex = this.addEmptyRow();
        this.checkImmutable();
        int columns = (int)this.getColumnCount();
        if (columns != values.length) {
            throw new IllegalArgumentException("The number of value parameters (" + String.valueOf(values.length) + ") does not match the number of columns in the table (" + String.valueOf(columns) + ").");
        }
        RealmFieldType[] colTypes = new RealmFieldType[columns];
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            RealmFieldType colType;
            Object value = values[columnIndex];
            colTypes[columnIndex] = colType = this.getColumnType(columnIndex);
            if (colType.isValid(value)) continue;
            String providedType = value == null ? "null" : value.getClass().toString();
            throw new IllegalArgumentException("Invalid argument no " + String.valueOf(1 + columnIndex) + ". Expected a value compatible with column type " + (Object)((Object)colType) + ", but got " + providedType + ".");
        }
        block12: for (long columnIndex = 0L; columnIndex < (long)columns; ++columnIndex) {
            Object value = values[(int)columnIndex];
            switch (colTypes[(int)columnIndex]) {
                case BOOLEAN: {
                    this.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, (Boolean)value);
                    continue block12;
                }
                case INTEGER: {
                    long intValue = ((Number)value).longValue();
                    this.checkIntValueIsLegal(columnIndex, rowIndex, intValue);
                    this.nativeSetLong(this.nativePtr, columnIndex, rowIndex, intValue);
                    continue block12;
                }
                case FLOAT: {
                    this.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, ((Float)value).floatValue());
                    continue block12;
                }
                case DOUBLE: {
                    this.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, (Double)value);
                    continue block12;
                }
                case STRING: {
                    String stringValue = (String)value;
                    this.checkStringValueIsLegal(columnIndex, rowIndex, stringValue);
                    this.nativeSetString(this.nativePtr, columnIndex, rowIndex, (String)value);
                    continue block12;
                }
                case DATE: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null Date is not allowed.");
                    }
                    this.nativeSetDate(this.nativePtr, columnIndex, rowIndex, ((Date)value).getTime() / 1000L);
                    continue block12;
                }
                case UNSUPPORTED_MIXED: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null Mixed data is not allowed");
                    }
                    this.nativeSetMixed(this.nativePtr, columnIndex, rowIndex, Mixed.mixedValue(value));
                    continue block12;
                }
                case BINARY: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null Array is not allowed");
                    }
                    this.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, (byte[])value);
                    continue block12;
                }
                case UNSUPPORTED_TABLE: {
                    this.insertSubTable(columnIndex, rowIndex, value);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unexpected columnType: " + String.valueOf((Object)colTypes[(int)columnIndex]));
                }
            }
        }
        return rowIndex;
    }

    private boolean isPrimaryKeyColumn(long columnIndex) {
        return columnIndex == this.getPrimaryKey();
    }

    public TableView getSortedView(long columnIndex, Sort sortOrder) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetSortedView(this.nativePtr, columnIndex, sortOrder.getValue());
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public TableView getSortedView(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetSortedView(this.nativePtr, columnIndex, true);
        return new TableView(this.context, this, nativeViewPtr);
    }

    public TableView getSortedView(long[] columnIndices, Sort[] sortOrders) {
        this.context.executeDelayedDisposal();
        boolean[] nativeSortOrder = new boolean[sortOrders.length];
        for (int i = 0; i < sortOrders.length; ++i) {
            nativeSortOrder[i] = sortOrders[i].getValue();
        }
        long nativeViewPtr = this.nativeGetSortedViewMulti(this.nativePtr, columnIndices, nativeSortOrder);
        return new TableView(this.context, this, nativeViewPtr);
    }

    public long getPrimaryKey() {
        long rowIndex;
        if (this.cachedPrimaryKeyColumnIndex >= 0L || this.cachedPrimaryKeyColumnIndex == -2L) {
            return this.cachedPrimaryKeyColumnIndex;
        }
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            return -2L;
        }
        String tableName = this.getName();
        if (tableName.startsWith(TABLE_PREFIX)) {
            tableName = tableName.substring(TABLE_PREFIX.length());
        }
        if ((rowIndex = pkTable.findFirstString(0L, tableName)) != -1L) {
            String pkColumnName = pkTable.getUncheckedRow(rowIndex).getString(1L);
            this.cachedPrimaryKeyColumnIndex = this.getColumnIndex(pkColumnName);
        } else {
            this.cachedPrimaryKeyColumnIndex = -2L;
        }
        return this.cachedPrimaryKeyColumnIndex;
    }

    public boolean isPrimaryKey(long columnIndex) {
        return columnIndex >= 0L && columnIndex == this.getPrimaryKey();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() >= 0L;
    }

    void checkStringValueIsLegal(long columnIndex, long rowToUpdate, String value) {
        long rowIndex;
        if (this.isPrimaryKey(columnIndex) && (rowIndex = this.findFirstString(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            this.throwDuplicatePrimaryKeyException(value);
        }
    }

    void checkIntValueIsLegal(long columnIndex, long rowToUpdate, long value) {
        long rowIndex;
        if (this.isPrimaryKeyColumn(columnIndex) && (rowIndex = this.findFirstLong(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            this.throwDuplicatePrimaryKeyException(value);
        }
    }

    private void throwDuplicatePrimaryKeyException(Object value) {
        throw new RealmPrimaryKeyConstraintException("Value already exists: " + value);
    }

    @Override
    public long getLong(long columnIndex, long rowIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public boolean getBoolean(long columnIndex, long rowIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public float getFloat(long columnIndex, long rowIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public double getDouble(long columnIndex, long rowIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public Date getDate(long columnIndex, long rowIndex) {
        return new Date(this.nativeGetDateTime(this.nativePtr, columnIndex, rowIndex) * 1000L);
    }

    @Override
    public String getString(long columnIndex, long rowIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public byte[] getBinaryByteArray(long columnIndex, long rowIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public Mixed getMixed(long columnIndex, long rowIndex) {
        return this.nativeGetMixed(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public RealmFieldType getMixedType(long columnIndex, long rowIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetMixedType(this.nativePtr, columnIndex, rowIndex));
    }

    @Override
    public long getLink(long columnIndex, long rowIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex, rowIndex);
    }

    public Table getLinkTarget(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetLinkTarget(this.nativePtr, columnIndex);
        try {
            return new Table(this.context, this.parent, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    @Override
    public Table getSubtable(long columnIndex, long rowIndex) {
        this.context.executeDelayedDisposal();
        long nativeSubtablePtr = this.nativeGetSubtable(this.nativePtr, columnIndex, rowIndex);
        try {
            return new Table(this.context, this, nativeSubtablePtr);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeSubtablePtr);
            throw e;
        }
    }

    private Table getSubtableDuringInsert(long columnIndex, long rowIndex) {
        this.context.executeDelayedDisposal();
        long nativeSubtablePtr = this.nativeGetSubtableDuringInsert(this.nativePtr, columnIndex, rowIndex);
        try {
            return new Table(this.context, this, nativeSubtablePtr);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeSubtablePtr);
            throw e;
        }
    }

    @Override
    public long getSubtableSize(long columnIndex, long rowIndex) {
        return this.nativeGetSubtableSize(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void clearSubtable(long columnIndex, long rowIndex) {
        this.checkImmutable();
        this.nativeClearSubtable(this.nativePtr, columnIndex, rowIndex);
    }

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.getByRowIndex(this.context, this, index);
    }

    public UncheckedRow getUncheckedRowByPointer(long nativeRowPointer) {
        return UncheckedRow.getByRowPointer(this.context, this, nativeRowPointer);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    @Override
    public void setLong(long columnIndex, long rowIndex, long value) {
        this.checkImmutable();
        this.checkIntValueIsLegal(columnIndex, rowIndex, value);
        this.nativeSetLong(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setBoolean(long columnIndex, long rowIndex, boolean value) {
        this.checkImmutable();
        this.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setFloat(long columnIndex, long rowIndex, float value) {
        this.checkImmutable();
        this.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setDouble(long columnIndex, long rowIndex, double value) {
        this.checkImmutable();
        this.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setDate(long columnIndex, long rowIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        this.checkImmutable();
        this.nativeSetDate(this.nativePtr, columnIndex, rowIndex, date.getTime() / 1000L);
    }

    @Override
    public void setString(long columnIndex, long rowIndex, String value) {
        this.checkImmutable();
        this.checkStringValueIsLegal(columnIndex, rowIndex, value);
        this.nativeSetString(this.nativePtr, columnIndex, rowIndex, value);
    }

    @Override
    public void setBinaryByteArray(long columnIndex, long rowIndex, byte[] data) {
        this.checkImmutable();
        this.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, data);
    }

    @Override
    public void setMixed(long columnIndex, long rowIndex, Mixed data) {
        this.checkImmutable();
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.nativeSetMixed(this.nativePtr, columnIndex, rowIndex, data);
    }

    @Override
    public void setLink(long columnIndex, long rowIndex, long value) {
        this.checkImmutable();
        this.nativeSetLink(this.nativePtr, columnIndex, rowIndex, value);
    }

    private void insertSubTable(long columnIndex, long rowIndex, Object value) {
        this.checkImmutable();
        if (value != null) {
            Table subtable = this.getSubtableDuringInsert(columnIndex, rowIndex);
            int rows = ((Object[])value).length;
            for (int i = 0; i < rows; ++i) {
                Object rowArr = ((Object[])value)[i];
                subtable.add((Object[])rowArr);
            }
        }
    }

    public void addSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeAddSearchIndex(this.nativePtr, columnIndex);
    }

    public void removeSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeRemoveSearchIndex(this.nativePtr, columnIndex);
    }

    public void setPrimaryKey(String columnName) {
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            throw new RealmException("Primary keys are only supported if Table is part of a Group");
        }
        this.cachedPrimaryKeyColumnIndex = this.nativeSetPrimaryKey(pkTable.nativePtr, this.nativePtr, columnName);
    }

    public void setPrimaryKey(long columnIndex) {
        this.setPrimaryKey(this.nativeGetColumnName(this.nativePtr, columnIndex));
    }

    private Table getPrimaryKeyTable() {
        Group group = this.getTableGroup();
        if (group == null) {
            return null;
        }
        Table pkTable = group.getTable(PRIMARY_KEY_TABLE_NAME);
        if (pkTable.getColumnCount() == 0L) {
            pkTable.addColumn(RealmFieldType.STRING, PRIMARY_KEY_CLASS_COLUMN_NAME);
            pkTable.addColumn(RealmFieldType.STRING, PRIMARY_KEY_FIELD_COLUMN_NAME);
        } else {
            this.migratePrimaryKeyTableIfNeeded(group, pkTable);
        }
        return pkTable;
    }

    private void migratePrimaryKeyTableIfNeeded(Group group, Table pkTable) {
        this.nativeMigratePrimaryKeyTableIfNeeded(group.nativePtr, pkTable.nativePtr);
    }

    Group getTableGroup() {
        if (this.parent instanceof Group) {
            return (Group)this.parent;
        }
        if (this.parent instanceof Table) {
            return ((Table)this.parent).getTableGroup();
        }
        return null;
    }

    public boolean hasSearchIndex(long columnIndex) {
        return this.nativeHasSearchIndex(this.nativePtr, columnIndex);
    }

    @Override
    public boolean isNullLink(long columnIndex, long rowIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public void nullifyLink(long columnIndex, long rowIndex) {
        this.nativeNullifyLink(this.nativePtr, columnIndex, rowIndex);
    }

    boolean isImmutable() {
        if (!(this.parent instanceof Table)) {
            return this.parent != null && ((Group)this.parent).immutable;
        }
        return ((Table)this.parent).isImmutable();
    }

    void checkImmutable() {
        if (this.isImmutable()) {
            this.throwImmutable();
        }
    }

    private void checkHasPrimaryKey() {
        if (!this.hasPrimaryKey()) {
            throw new IllegalStateException(this.getName() + " has no primary key defined");
        }
    }

    @Override
    public long sumLong(long columnIndex) {
        return this.nativeSumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long maximumLong(long columnIndex) {
        return this.nativeMaximumInt(this.nativePtr, columnIndex);
    }

    @Override
    public Long minimumLong(long columnIndex) {
        return this.nativeMinimumInt(this.nativePtr, columnIndex);
    }

    @Override
    public double averageLong(long columnIndex) {
        return this.nativeAverageInt(this.nativePtr, columnIndex);
    }

    @Override
    public double sumFloat(long columnIndex) {
        return this.nativeSumFloat(this.nativePtr, columnIndex);
    }

    @Override
    public Float maximumFloat(long columnIndex) {
        return Float.valueOf(this.nativeMaximumFloat(this.nativePtr, columnIndex));
    }

    @Override
    public Float minimumFloat(long columnIndex) {
        return Float.valueOf(this.nativeMinimumFloat(this.nativePtr, columnIndex));
    }

    @Override
    public double averageFloat(long columnIndex) {
        return this.nativeAverageFloat(this.nativePtr, columnIndex);
    }

    @Override
    public double sumDouble(long columnIndex) {
        return this.nativeSumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double maximumDouble(long columnIndex) {
        return this.nativeMaximumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Double minimumDouble(long columnIndex) {
        return this.nativeMinimumDouble(this.nativePtr, columnIndex);
    }

    @Override
    public double averageDouble(long columnIndex) {
        return this.nativeAverageDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Date maximumDate(long columnIndex) {
        return new Date(this.nativeMaximumDate(this.nativePtr, columnIndex) * 1000L);
    }

    @Override
    public Date minimumDate(long columnIndex) {
        return new Date(this.nativeMinimumDate(this.nativePtr, columnIndex) * 1000L);
    }

    public long count(long columnIndex, long value) {
        return this.nativeCountLong(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, float value) {
        return this.nativeCountFloat(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, double value) {
        return this.nativeCountDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public long count(long columnIndex, String value) {
        return this.nativeCountString(this.nativePtr, columnIndex, value);
    }

    @Override
    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativePtr);
        try {
            return new TableQuery(this.context, this, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    @Override
    public long findFirstLong(long columnIndex, long value) {
        return this.nativeFindFirstInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstBoolean(long columnIndex, boolean value) {
        return this.nativeFindFirstBool(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstFloat(long columnIndex, float value) {
        return this.nativeFindFirstFloat(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDouble(long columnIndex, double value) {
        return this.nativeFindFirstDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public long findFirstDate(long columnIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
    }

    @Override
    public long findFirstString(long columnIndex, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstString(this.nativePtr, columnIndex, value);
    }

    @Override
    public TableView findAllLong(long columnIndex, long value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllInt(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllBoolean(long columnIndex, boolean value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllBool(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllFloat(long columnIndex, float value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllFloat(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllDouble(long columnIndex, double value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDouble(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllDate(long columnIndex, Date date) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public TableView findAllString(long columnIndex, String value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllString(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    @Override
    public long lowerBoundLong(long columnIndex, long value) {
        return this.nativeLowerBoundInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long upperBoundLong(long columnIndex, long value) {
        return this.nativeUpperBoundInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public Table pivot(long stringCol, long intCol, TableOrView.PivotType pivotType) {
        if (!this.getColumnType(stringCol).equals((Object)RealmFieldType.STRING)) {
            throw new UnsupportedOperationException("Group by column must be of type String");
        }
        if (!this.getColumnType(intCol).equals((Object)RealmFieldType.INTEGER)) {
            throw new UnsupportedOperationException("Aggregation column must be of type Int");
        }
        Table result = new Table();
        this.nativePivot(this.nativePtr, stringCol, intCol, pivotType.value, result.nativePtr);
        return result;
    }

    public TableView getDistinctView(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetDistinctView(this.nativePtr, columnIndex);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public String getName() {
        return this.nativeGetName(this.nativePtr);
    }

    public void optimize() {
        this.checkImmutable();
        this.nativeOptimize(this.nativePtr);
    }

    @Override
    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    @Override
    public String toString() {
        return this.nativeToString(this.nativePtr, -1L);
    }

    @Override
    public String toString(long maxRows) {
        return this.nativeToString(this.nativePtr, maxRows);
    }

    @Override
    public String rowToString(long rowIndex) {
        return this.nativeRowToString(this.nativePtr, rowIndex);
    }

    @Override
    public long sync() {
        throw new RuntimeException("Not supported for tables");
    }

    private void throwImmutable() {
        throw new IllegalStateException("Changing Realm data can only be done from inside a transaction.");
    }

    public boolean hasSameSchema(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        return this.nativeHasSameSchema(this.nativePtr, table.nativePtr);
    }

    public static boolean isMetaTable(String tableName) {
        return tableName.equals(METADATA_TABLE_NAME) || tableName.equals(PRIMARY_KEY_TABLE_NAME);
    }

    public long version() {
        return this.nativeVersion(this.nativePtr);
    }

    protected native long createNative();

    static native void nativeClose(long var0);

    private native boolean nativeIsValid(long var1);

    private native boolean nativeIsRootTable(long var1);

    private native long nativeAddColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddColumnLink(long var1, int var3, String var4, long var5);

    private native void nativeRenameColumn(long var1, long var3, String var5);

    private native void nativeRemoveColumn(long var1, long var3);

    private native boolean nativeIsColumnNullable(long var1, long var3);

    private native void nativeConvertColumnToNullable(long var1, long var3);

    private native void nativeConvertColumnToNotNullable(long var1, long var3);

    private native void nativeUpdateFromSpec(long var1, TableSpec var3);

    private native long nativeSize(long var1);

    private native void nativeClear(long var1);

    private native long nativeGetColumnCount(long var1);

    private native TableSpec nativeGetTableSpec(long var1);

    private native String nativeGetColumnName(long var1, long var3);

    private native long nativeGetColumnIndex(long var1, String var3);

    private native int nativeGetColumnType(long var1, long var3);

    private native void nativeRemove(long var1, long var3);

    private native void nativeRemoveLast(long var1);

    private native void nativeMoveLastOver(long var1, long var3);

    private native long nativeAddEmptyRow(long var1, long var3);

    private native long nativeGetSortedView(long var1, long var3, boolean var5);

    private native long nativeGetSortedViewMulti(long var1, long[] var3, boolean[] var4);

    private native long nativeGetLong(long var1, long var3, long var5);

    private native boolean nativeGetBoolean(long var1, long var3, long var5);

    private native float nativeGetFloat(long var1, long var3, long var5);

    private native double nativeGetDouble(long var1, long var3, long var5);

    private native long nativeGetDateTime(long var1, long var3, long var5);

    private native String nativeGetString(long var1, long var3, long var5);

    private native byte[] nativeGetByteArray(long var1, long var3, long var5);

    private native int nativeGetMixedType(long var1, long var3, long var5);

    private native Mixed nativeGetMixed(long var1, long var3, long var5);

    private native long nativeGetLink(long var1, long var3, long var5);

    private native long nativeGetLinkTarget(long var1, long var3);

    private native long nativeGetSubtable(long var1, long var3, long var5);

    private native long nativeGetSubtableDuringInsert(long var1, long var3, long var5);

    private native long nativeGetSubtableSize(long var1, long var3, long var5);

    private native void nativeClearSubtable(long var1, long var3, long var5);

    native long nativeGetRowPtr(long var1, long var3);

    private native void nativeSetLong(long var1, long var3, long var5, long var7);

    private native void nativeSetBoolean(long var1, long var3, long var5, boolean var7);

    private native void nativeSetFloat(long var1, long var3, long var5, float var7);

    private native void nativeSetDouble(long var1, long var3, long var5, double var7);

    private native void nativeSetDate(long var1, long var3, long var5, long var7);

    private native void nativeSetString(long var1, long var3, long var5, String var7);

    private native void nativeSetByteArray(long var1, long var3, long var5, byte[] var7);

    private native void nativeSetMixed(long var1, long var3, long var5, Mixed var7);

    private native void nativeSetLink(long var1, long var3, long var5, long var7);

    private native long nativeSetPrimaryKey(long var1, long var3, String var5);

    private native void nativeMigratePrimaryKeyTableIfNeeded(long var1, long var3);

    private native void nativeAddSearchIndex(long var1, long var3);

    private native void nativeRemoveSearchIndex(long var1, long var3);

    private native boolean nativeHasSearchIndex(long var1, long var3);

    private native boolean nativeIsNullLink(long var1, long var3, long var5);

    private native void nativeNullifyLink(long var1, long var3, long var5);

    private native long nativeSumInt(long var1, long var3);

    private native long nativeMaximumInt(long var1, long var3);

    private native long nativeMinimumInt(long var1, long var3);

    private native double nativeAverageInt(long var1, long var3);

    private native double nativeSumFloat(long var1, long var3);

    private native float nativeMaximumFloat(long var1, long var3);

    private native float nativeMinimumFloat(long var1, long var3);

    private native double nativeAverageFloat(long var1, long var3);

    private native double nativeSumDouble(long var1, long var3);

    private native double nativeMaximumDouble(long var1, long var3);

    private native double nativeMinimumDouble(long var1, long var3);

    private native double nativeAverageDouble(long var1, long var3);

    private native long nativeMaximumDate(long var1, long var3);

    private native long nativeMinimumDate(long var1, long var3);

    private native long nativeCountLong(long var1, long var3, long var5);

    private native long nativeCountFloat(long var1, long var3, float var5);

    private native long nativeCountDouble(long var1, long var3, double var5);

    private native long nativeCountString(long var1, long var3, String var5);

    private native long nativeWhere(long var1);

    private native long nativeFindFirstInt(long var1, long var3, long var5);

    private native long nativeFindFirstBool(long var1, long var3, boolean var5);

    private native long nativeFindFirstFloat(long var1, long var3, float var5);

    private native long nativeFindFirstDouble(long var1, long var3, double var5);

    private native long nativeFindFirstDate(long var1, long var3, long var5);

    private native long nativeFindFirstString(long var1, long var3, String var5);

    private native long nativeFindAllInt(long var1, long var3, long var5);

    private native long nativeFindAllBool(long var1, long var3, boolean var5);

    private native long nativeFindAllFloat(long var1, long var3, float var5);

    private native long nativeFindAllDouble(long var1, long var3, double var5);

    private native long nativeFindAllDate(long var1, long var3, long var5);

    private native long nativeFindAllString(long var1, long var3, String var5);

    private native long nativeLowerBoundInt(long var1, long var3, long var5);

    private native long nativeUpperBoundInt(long var1, long var3, long var5);

    private native void nativePivot(long var1, long var3, long var5, int var7, long var8);

    private native long nativeGetDistinctView(long var1, long var3);

    private native String nativeGetName(long var1);

    private native void nativeOptimize(long var1);

    private native String nativeToJson(long var1);

    private native String nativeToString(long var1, long var3);

    private native boolean nativeHasSameSchema(long var1, long var3);

    private native long nativeVersion(long var1);

    private native String nativeRowToString(long var1, long var3);

    static {
        RealmCore.loadLibrary();
    }
}

