/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.TableSchema;

public class SubtableSchema
implements TableSchema {
    private long[] path;
    private long parentNativePtr;

    SubtableSchema(long parentNativePtr, long[] path) {
        this.parentNativePtr = parentNativePtr;
        this.path = path;
    }

    @Override
    public SubtableSchema getSubtableSchema(long columnIndex) {
        long[] newPath = new long[this.path.length + 1];
        for (int i = 0; i < this.path.length; ++i) {
            newPath[i] = this.path[i];
        }
        newPath[this.path.length] = columnIndex;
        return new SubtableSchema(this.parentNativePtr, newPath);
    }

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    @Override
    public long addColumn(RealmFieldType type, String name) {
        this.verifyColumnName(name);
        return this.nativeAddColumn(this.parentNativePtr, this.path, type.getNativeValue(), name);
    }

    protected native long nativeAddColumn(long var1, long[] var3, int var4, String var5);

    @Override
    public void removeColumn(long columnIndex) {
        this.nativeRemoveColumn(this.parentNativePtr, this.path, columnIndex);
    }

    protected native void nativeRemoveColumn(long var1, long[] var3, long var4);

    @Override
    public void renameColumn(long columnIndex, String newName) {
        this.verifyColumnName(newName);
        this.nativeRenameColumn(this.parentNativePtr, this.path, columnIndex, newName);
    }

    protected native void nativeRenameColumn(long var1, long[] var3, long var4, String var6);
}

