/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.exceptions.RealmIOException;
import io.realm.internal.Context;
import io.realm.internal.Group;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.ReadTransaction;
import io.realm.internal.RealmCore;
import io.realm.internal.WriteTransaction;
import java.io.Closeable;
import java.io.IOError;

public class SharedGroup
implements Closeable {
    public static final boolean IMPLICIT_TRANSACTION = true;
    public static final boolean EXPLICIT_TRANSACTION = false;
    private static final boolean CREATE_FILE_YES = false;
    private static final boolean CREATE_FILE_NO = true;
    private static final boolean ENABLE_REPLICATION = true;
    private static final boolean DISABLE_REPLICATION = false;
    private final String path;
    private long nativePtr;
    private long nativeReplicationPtr;
    private boolean implicitTransactionsEnabled = false;
    private boolean activeTransaction;
    private final Context context;

    public SharedGroup(String databaseFile) {
        this.context = new Context();
        this.path = databaseFile;
        this.nativePtr = this.nativeCreate(databaseFile, Durability.FULL.value, false, false, null);
        this.checkNativePtrNotZero();
    }

    public SharedGroup(String canonicalPath, boolean enableImplicitTransactions, Durability durability, byte[] key) {
        if (enableImplicitTransactions) {
            this.nativeReplicationPtr = this.nativeCreateReplication(canonicalPath, key);
            this.nativePtr = this.createNativeWithImplicitTransactions(this.nativeReplicationPtr, durability.value, key);
            this.implicitTransactionsEnabled = true;
        } else {
            this.nativePtr = this.nativeCreate(canonicalPath, Durability.FULL.value, false, false, key);
        }
        this.context = new Context();
        this.path = canonicalPath;
        this.checkNativePtrNotZero();
    }

    public SharedGroup(String canonicalPath, Durability durability, byte[] key) {
        this.path = canonicalPath;
        this.context = new Context();
        this.nativePtr = this.nativeCreate(canonicalPath, durability.value, false, false, key);
        this.checkNativePtrNotZero();
    }

    void advanceRead() {
        this.nativeAdvanceRead(this.nativePtr, this.nativeReplicationPtr);
    }

    void advanceRead(VersionID versionID) {
        this.nativeAdvanceReadToVersion(this.nativePtr, this.nativeReplicationPtr, versionID.version, versionID.index);
    }

    void promoteToWrite() {
        this.nativePromoteToWrite(this.nativePtr, this.nativeReplicationPtr);
    }

    void commitAndContinueAsRead() {
        this.nativeCommitAndContinueAsRead(this.nativePtr);
    }

    void rollbackAndContinueAsRead() {
        this.nativeRollbackAndContinueAsRead(this.nativePtr, this.nativeReplicationPtr);
    }

    public ImplicitTransaction beginImplicitTransaction() {
        if (this.activeTransaction) {
            throw new IllegalStateException("Can't beginImplicitTransaction() during another active transaction");
        }
        long nativeGroupPtr = this.nativeBeginImplicit(this.nativePtr);
        ImplicitTransaction transaction = new ImplicitTransaction(this.context, this, nativeGroupPtr);
        this.activeTransaction = true;
        return transaction;
    }

    public WriteTransaction beginWrite() {
        if (this.activeTransaction) {
            throw new IllegalStateException("Can't beginWrite() during another active transaction");
        }
        long nativeWritePtr = this.nativeBeginWrite(this.nativePtr);
        try {
            WriteTransaction t = new WriteTransaction(this.context, this, nativeWritePtr);
            this.activeTransaction = true;
            return t;
        }
        catch (RuntimeException e) {
            Group.nativeClose(nativeWritePtr);
            throw e;
        }
    }

    public ReadTransaction beginRead() {
        if (this.activeTransaction) {
            throw new IllegalStateException("Can't beginRead() during another active transaction");
        }
        long nativeReadPtr = this.nativeBeginRead(this.nativePtr);
        try {
            ReadTransaction t = new ReadTransaction(this.context, this, nativeReadPtr);
            this.activeTransaction = true;
            return t;
        }
        catch (RuntimeException e) {
            Group.nativeClose(nativeReadPtr);
            throw e;
        }
    }

    void endRead() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't endRead() on closed group. ReadTransaction is invalid.");
        }
        this.nativeEndRead(this.nativePtr);
        this.activeTransaction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                SharedGroup.nativeClose(this.nativePtr);
                this.nativePtr = 0L;
                if (this.implicitTransactionsEnabled && this.nativeReplicationPtr != 0L) {
                    this.nativeCloseReplication(this.nativeReplicationPtr);
                    this.nativeReplicationPtr = 0L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeSharedGroup(this.nativePtr);
                this.nativePtr = 0L;
                if (this.implicitTransactionsEnabled && this.nativeReplicationPtr != 0L) {
                    this.nativeCloseReplication(this.nativeReplicationPtr);
                    this.nativeReplicationPtr = 0L;
                }
            }
        }
    }

    void commit() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't commit() on closed group. WriteTransaction is invalid.");
        }
        this.nativeCommit(this.nativePtr);
        this.activeTransaction = false;
    }

    void rollback() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't rollback() on closed group. WriteTransaction is invalid.");
        }
        this.nativeRollback(this.nativePtr);
        this.activeTransaction = false;
    }

    public boolean isClosed() {
        return this.nativePtr == 0L;
    }

    public boolean hasChanged() {
        return this.nativeHasChanged(this.nativePtr);
    }

    public void reserve(long bytes) {
        this.nativeReserve(this.nativePtr, bytes);
    }

    public boolean compact() {
        return this.nativeCompact(this.nativePtr);
    }

    public String getPath() {
        return this.path;
    }

    private void checkNativePtrNotZero() {
        if (this.nativePtr == 0L) {
            throw new IOError(new RealmIOException("Realm could not be opened"));
        }
    }

    public long getNativePointer() {
        return this.nativePtr;
    }

    public long getNativeReplicationPointer() {
        return this.nativeReplicationPtr;
    }

    public VersionID getVersion() {
        long[] versionId = this.nativeGetVersionID(this.nativePtr);
        return new VersionID(versionId[0], versionId[1]);
    }

    private native long createNativeWithImplicitTransactions(long var1, int var3, byte[] var4);

    private native long nativeCreateReplication(String var1, byte[] var2);

    private native void nativeCommitAndContinueAsRead(long var1);

    private native long nativeBeginImplicit(long var1);

    private native String nativeGetDefaultReplicationDatabaseFileName();

    private native void nativeReserve(long var1, long var3);

    private native boolean nativeHasChanged(long var1);

    private native long nativeBeginRead(long var1);

    private native void nativeEndRead(long var1);

    private native long nativeBeginWrite(long var1);

    private native void nativeCommit(long var1);

    private native void nativeRollback(long var1);

    private native long nativeCreate(String var1, int var2, boolean var3, boolean var4, byte[] var5);

    private native boolean nativeCompact(long var1);

    protected static native void nativeClose(long var0);

    private native void nativeCloseReplication(long var1);

    private native void nativeRollbackAndContinueAsRead(long var1, long var3);

    private native long[] nativeGetVersionID(long var1);

    private native void nativeAdvanceRead(long var1, long var3);

    private native void nativeAdvanceReadToVersion(long var1, long var3, long var5, long var7);

    private native void nativePromoteToWrite(long var1, long var3);

    static {
        RealmCore.loadLibrary();
    }

    public static class VersionID
    implements Comparable<VersionID> {
        final long version;
        final long index;

        VersionID(long version, long index) {
            this.version = version;
            this.index = index;
        }

        @Override
        public int compareTo(VersionID another) {
            if (this.version > another.version) {
                return 1;
            }
            if (this.version < another.version) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "VersionID{version=" + this.version + ", index=" + this.index + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            VersionID versionID = (VersionID)object;
            if (this.version != versionID.version) {
                return false;
            }
            return this.index == versionID.index;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            return result;
        }
    }

    public static enum Durability {
        FULL(0),
        MEM_ONLY(1);

        final int value;

        private Durability(int value) {
            this.value = value;
        }
    }
}

