/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.IllegalMixedTypeException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;

public class Mixed {
    public static final int BINARY_TYPE_BYTE_ARRAY = 0;
    public static final int BINARY_TYPE_BYTE_BUFFER = 1;
    private Object value;

    public Mixed(long value) {
        this.value = value;
    }

    public Mixed(float value) {
        this.value = Float.valueOf(value);
    }

    public Mixed(double value) {
        this.value = value;
    }

    public Mixed(RealmFieldType columnType) {
        if (columnType == null || columnType == RealmFieldType.UNSUPPORTED_TABLE) {
            throw new AssertionError();
        }
        this.value = null;
    }

    public Mixed(boolean value) {
        this.value = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public Mixed(Date value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(String value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(ByteBuffer value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(byte[] value) {
        assert (value != null);
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mixed mixed = (Mixed)obj;
        if (this.value.getClass() != mixed.value.getClass()) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Arrays.equals((byte[])this.value, (byte[])mixed.value);
        }
        if (this.value instanceof ByteBuffer) {
            return ((ByteBuffer)this.value).compareTo((ByteBuffer)mixed.value) == 0;
        }
        return this.value.equals(mixed.value);
    }

    public int hashCode() {
        if (this.value instanceof byte[]) {
            return Arrays.hashCode((byte[])this.value);
        }
        return this.value.hashCode();
    }

    public RealmFieldType getType() {
        if (this.value == null) {
            return RealmFieldType.UNSUPPORTED_TABLE;
        }
        if (this.value instanceof String) {
            return RealmFieldType.STRING;
        }
        if (this.value instanceof Long) {
            return RealmFieldType.INTEGER;
        }
        if (this.value instanceof Float) {
            return RealmFieldType.FLOAT;
        }
        if (this.value instanceof Double) {
            return RealmFieldType.DOUBLE;
        }
        if (this.value instanceof Date) {
            return RealmFieldType.DATE;
        }
        if (this.value instanceof Boolean) {
            return RealmFieldType.BOOLEAN;
        }
        if (this.value instanceof ByteBuffer || this.value instanceof byte[]) {
            return RealmFieldType.BINARY;
        }
        throw new IllegalStateException("Unknown column type!");
    }

    public static Mixed mixedValue(Object value) {
        if (value instanceof String) {
            return new Mixed((String)value);
        }
        if (value instanceof Long) {
            return new Mixed((Long)value);
        }
        if (value instanceof Integer) {
            return new Mixed(((Integer)value).longValue());
        }
        if (value instanceof Boolean) {
            return new Mixed((Boolean)value);
        }
        if (value instanceof Float) {
            return new Mixed(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new Mixed((Double)value);
        }
        if (value instanceof Date) {
            return new Mixed((Date)value);
        }
        if (value instanceof ByteBuffer) {
            return new Mixed((ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return new Mixed((byte[])value);
        }
        if (value instanceof Mixed) {
            return (Mixed)value;
        }
        throw new IllegalArgumentException("The value is of unsupported type: " + value.getClass());
    }

    public long getLongValue() {
        if (!(this.value instanceof Long)) {
            throw new IllegalMixedTypeException("Can't get a long from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (Long)this.value;
    }

    public boolean getBooleanValue() {
        if (!(this.value instanceof Boolean)) {
            throw new IllegalMixedTypeException("Can't get a boolean from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (Boolean)this.value;
    }

    public float getFloatValue() {
        if (!(this.value instanceof Float)) {
            throw new IllegalMixedTypeException("Can't get a float from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return ((Float)this.value).floatValue();
    }

    public double getDoubleValue() {
        if (!(this.value instanceof Double)) {
            throw new IllegalMixedTypeException("Can't get a double from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (Double)this.value;
    }

    public String getStringValue() {
        if (!(this.value instanceof String)) {
            throw new IllegalMixedTypeException("Can't get a String from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (String)this.value;
    }

    public Date getDateValue() {
        if (!(this.value instanceof Date)) {
            throw new IllegalMixedTypeException("Can't get a Date from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (Date)this.value;
    }

    protected long getDateTimeValue() {
        return this.getDateValue().getTime();
    }

    public ByteBuffer getBinaryValue() {
        if (!(this.value instanceof ByteBuffer)) {
            throw new IllegalMixedTypeException("Can't get a ByteBuffer from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (ByteBuffer)this.value;
    }

    public byte[] getBinaryByteArray() {
        if (!(this.value instanceof byte[])) {
            throw new IllegalMixedTypeException("Can't get a byte[] from a Mixed containing a " + (Object)((Object)this.getType()));
        }
        return (byte[])this.value;
    }

    public int getBinaryType() {
        if (this.value instanceof byte[]) {
            return 0;
        }
        if (this.value instanceof ByteBuffer) {
            return 1;
        }
        return -1;
    }

    public Object getValue() {
        return this.value;
    }

    public String getReadableValue() {
        RealmFieldType type = this.getType();
        try {
            switch (type) {
                case BINARY: {
                    return "Binary";
                }
                case BOOLEAN: {
                    return String.valueOf(this.getBooleanValue());
                }
                case DATE: {
                    return String.valueOf(this.getDateValue());
                }
                case DOUBLE: {
                    return String.valueOf(this.getDoubleValue());
                }
                case FLOAT: {
                    return String.valueOf(this.getFloatValue());
                }
                case INTEGER: {
                    return String.valueOf(this.getLongValue());
                }
                case STRING: {
                    return String.valueOf(this.getStringValue());
                }
                case UNSUPPORTED_TABLE: {
                    return "Subtable";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "ERROR";
    }
}

