/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import io.realm.BaseRealm;
import io.realm.Case;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.internal.LinkView;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import io.realm.internal.async.ArgumentsHolder;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.internal.log.RealmLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class RealmQuery<E extends RealmObject> {
    private BaseRealm realm;
    private Class<E> clazz;
    private String className;
    private TableOrView table;
    private RealmObjectSchema schema;
    private LinkView view;
    private TableQuery query;
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    private static final Long INVALID_NATIVE_POINTER = 0L;
    private ArgumentsHolder argumentsHolder;

    public static <E extends RealmObject> RealmQuery<E> createQuery(Realm realm, Class<E> clazz) {
        return new RealmQuery<E>(realm, clazz);
    }

    public static <E extends RealmObject> RealmQuery<E> createDynamicQuery(DynamicRealm realm, String className) {
        return new RealmQuery<E>(realm, className);
    }

    public static <E extends RealmObject> RealmQuery<E> createQueryFromResult(RealmResults<E> queryResults) {
        if (queryResults.classSpec != null) {
            return new RealmQuery<E>(queryResults, queryResults.classSpec);
        }
        return new RealmQuery<E>(queryResults, queryResults.className);
    }

    public static <E extends RealmObject> RealmQuery<E> createQueryFromList(RealmList<E> list) {
        if (list.clazz != null) {
            return new RealmQuery(list.realm, list.view, list.clazz);
        }
        return new RealmQuery<E>(list.realm, list.view, list.className);
    }

    private RealmQuery(Realm realm, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.schema = realm.schema.getSchemaForClass(clazz);
        this.table = this.schema.table;
        this.view = null;
        this.query = this.table.where();
    }

    private RealmQuery(RealmResults<E> queryResults, Class<E> clazz) {
        this.realm = queryResults.realm;
        this.clazz = clazz;
        this.schema = this.realm.schema.getSchemaForClass(clazz);
        this.table = queryResults.getTable();
        this.view = null;
        this.query = queryResults.getTable().where();
    }

    private RealmQuery(BaseRealm realm, LinkView view, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.query = view.where();
        this.view = view;
        this.schema = realm.schema.getSchemaForClass(clazz);
        this.table = this.schema.table;
    }

    private RealmQuery(BaseRealm realm, String className) {
        this.realm = realm;
        this.className = className;
        this.schema = realm.schema.getSchemaForClass(className);
        this.table = this.schema.table;
        this.query = this.table.where();
    }

    private RealmQuery(RealmResults<DynamicRealmObject> queryResults, String className) {
        this.realm = queryResults.realm;
        this.className = className;
        this.schema = this.realm.schema.getSchemaForClass(className);
        this.table = this.schema.table;
        this.query = queryResults.getTable().where();
    }

    private RealmQuery(BaseRealm realm, LinkView view, String className) {
        this.realm = realm;
        this.className = className;
        this.query = view.where();
        this.view = view;
        this.schema = realm.schema.getSchemaForClass(className);
        this.table = this.schema.table;
    }

    public boolean isValid() {
        if (this.realm == null || this.realm.isClosed()) {
            return false;
        }
        if (this.view != null) {
            return this.view.isAttached();
        }
        return this.table != null && this.table.getTable().isValid();
    }

    public RealmQuery<E> isNull(String fieldName) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, new RealmFieldType[0]);
        this.query.isNull(columnIndices);
        return this;
    }

    public RealmQuery<E> isNotNull(String fieldName) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, new RealmFieldType[0]);
        this.query.isNotNull(columnIndices);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, String value) {
        return this.equalTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> equalTo(String fieldName, String value, Case casing) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.equalTo(columnIndices, value, casing);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Byte value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Short value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Integer value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.intValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Boolean value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.BOOLEAN);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value) {
        return this.notEqualTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value, Case casing) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        if (columnIndices.length > 1 && !casing.getValue()) {
            throw new IllegalArgumentException("Link queries cannot be case insensitive - coming soon.");
        }
        this.query.notEqualTo(columnIndices, value, casing);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Byte value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Short value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Integer value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.intValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Boolean value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.BOOLEAN);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value == false);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, int value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, int value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> between(String fieldName, int from, int to) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, long from, long to) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, double from, double to) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, float from, float to) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, Date from, Date to) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> contains(String fieldName, String value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> contains(String fieldName, String value, Case casing) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.contains(columnIndices, value, casing);
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, String value) {
        return this.beginsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> beginsWith(String fieldName, String value, Case casing) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.beginsWith(columnIndices, value, casing);
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> endsWith(String fieldName, String value, Case casing) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.endsWith(columnIndices, value, casing);
        return this;
    }

    public RealmQuery<E> beginGroup() {
        this.query.group();
        return this;
    }

    public RealmQuery<E> endGroup() {
        this.query.endGroup();
        return this;
    }

    public RealmQuery<E> or() {
        this.query.or();
        return this;
    }

    public RealmQuery<E> not() {
        this.query.not();
        return this;
    }

    public RealmQuery<E> isEmpty(String fieldName) {
        long[] columnIndices = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING, RealmFieldType.BINARY, RealmFieldType.LIST);
        this.query.isEmpty(columnIndices);
        return this;
    }

    public Number sum(String fieldName) {
        long columnIndex = this.schema.getFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.sumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.sumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.sumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public double average(String fieldName) {
        long columnIndex = this.schema.getFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.averageInt(columnIndex);
            }
            case DOUBLE: {
                return this.query.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.query.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.minimumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.minimumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.minimumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public Date minimumDate(String fieldName) {
        long columnIndex = this.schema.getFieldIndex(fieldName);
        return this.query.minimumDate(columnIndex);
    }

    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.maximumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.maximumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.maximumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public Date maximumDate(String fieldName) {
        long columnIndex = this.schema.getFieldIndex(fieldName);
        return this.query.maximumDate(columnIndex);
    }

    public long count() {
        return this.query.count();
    }

    RealmResults<E> distinctAsync(final long columnIndex) {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(4);
        this.argumentsHolder.columnIndex = columnIndex;
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicClass(this.realm, this.query, this.className) : RealmResults.createFromTableQuery(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = this.realm.handlerController.addToAsyncRealmResults(realmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findDistinctWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, columnIndex);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage(), e);
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null && !sharedGroup.isClosed()) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAll() {
        this.checkQueryIsNotReused();
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicTableOrView(this.realm, this.query.findAll(), this.className) : RealmResults.createFromTableOrView(this.realm, this.query.findAll(), this.clazz);
        if (this.realm.handlerController != null) {
            this.realm.handlerController.addToRealmResults(realmResults);
        }
        return realmResults;
    }

    public RealmResults<E> findAllAsync() {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(0);
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicClass(this.realm, this.query, this.className) : RealmResults.createFromTableQuery(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = this.realm.handlerController.addToAsyncRealmResults(realmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage(), e);
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null && !sharedGroup.isClosed()) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName, Sort sortOrder) {
        this.checkQueryIsNotReused();
        TableView tableView = this.query.findAll();
        Long columnIndex = this.schema.getFieldIndex(fieldName);
        if (columnIndex == null || columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        tableView.sort(columnIndex, sortOrder);
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicTableOrView(this.realm, tableView, this.className) : RealmResults.createFromTableOrView(this.realm, tableView, this.clazz);
        if (this.realm.handlerController != null) {
            this.realm.handlerController.addToRealmResults(realmResults);
        }
        return realmResults;
    }

    public RealmResults<E> findAllSortedAsync(String fieldName, final Sort sortOrder) {
        this.checkQueryIsNotReused();
        final Long columnIndex = this.schema.getFieldIndex(fieldName);
        if (columnIndex == null || columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        this.argumentsHolder = new ArgumentsHolder(1);
        this.argumentsHolder.sortOrder = sortOrder;
        this.argumentsHolder.columnIndex = columnIndex;
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicClass(this.realm, this.query, this.className) : RealmResults.createFromTableQuery(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = this.realm.handlerController.addToAsyncRealmResults(realmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, columnIndex, sortOrder);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage(), e);
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null && !sharedGroup.isClosed()) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName) {
        return this.findAllSorted(fieldName, Sort.ASCENDING);
    }

    public RealmResults<E> findAllSortedAsync(String fieldName) {
        return this.findAllSortedAsync(fieldName, Sort.ASCENDING);
    }

    public RealmResults<E> findAllSorted(String[] fieldNames, Sort[] sortOrders) {
        this.checkSortParameters(fieldNames, sortOrders);
        if (fieldNames.length == 1 && sortOrders.length == 1) {
            return this.findAllSorted(fieldNames[0], sortOrders[0]);
        }
        TableView tableView = this.query.findAll();
        ArrayList<Long> columnIndices = new ArrayList<Long>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Long columnIndex = this.schema.getFieldIndex(fieldName);
            if (columnIndex == null || columnIndex < 0L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices.add(columnIndex);
        }
        tableView.sort(columnIndices, sortOrders);
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicTableOrView(this.realm, tableView, this.className) : RealmResults.createFromTableOrView(this.realm, tableView, this.clazz);
        if (this.realm.handlerController != null) {
            this.realm.handlerController.addToRealmResults(realmResults);
        }
        return realmResults;
    }

    private boolean isDynamicQuery() {
        return this.className != null;
    }

    public RealmResults<E> findAllSortedAsync(String[] fieldNames, final Sort[] sortOrders) {
        this.checkQueryIsNotReused();
        this.checkSortParameters(fieldNames, sortOrders);
        if (fieldNames.length == 1 && sortOrders.length == 1) {
            return this.findAllSortedAsync(fieldNames[0], sortOrders[0]);
        }
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        final long[] indices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Long columnIndex = this.schema.getFieldIndex(fieldName);
            if (columnIndex == null || columnIndex < 0L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            indices[i] = columnIndex;
        }
        this.argumentsHolder = new ArgumentsHolder(2);
        this.argumentsHolder.sortOrders = sortOrders;
        this.argumentsHolder.columnIndices = indices;
        RealmResults<DynamicRealmObject> realmResults = this.isDynamicQuery() ? RealmResults.createFromDynamicClass(this.realm, this.query, this.className) : RealmResults.createFromTableQuery(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = this.realm.handlerController.addToAsyncRealmResults(realmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllMultiSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, indices, sortOrders);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage(), e);
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null && !sharedGroup.isClosed()) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public RealmResults<E> findAllSortedAsync(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.findAllSortedAsync(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public RealmResults<E> findAllSorted(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2, String fieldName3, Sort sortOrder3) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2, fieldName3}, new Sort[]{sortOrder1, sortOrder2, sortOrder3});
    }

    public RealmResults<E> findAllSortedAsync(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2, String fieldName3, Sort sortOrder3) {
        return this.findAllSortedAsync(new String[]{fieldName1, fieldName2, fieldName3}, new Sort[]{sortOrder1, sortOrder2, sortOrder3});
    }

    public E findFirst() {
        this.checkQueryIsNotReused();
        long sourceRowIndex = this.getSourceRowIndexForFirstObject();
        if (sourceRowIndex >= 0L) {
            E realmObject = this.realm.get(this.clazz, this.className, sourceRowIndex);
            if (this.realm.handlerController != null) {
                WeakReference<RealmObject> realmObjectWeakReference = new WeakReference<RealmObject>((RealmObject)realmObject, this.realm.handlerController.referenceQueueRealmObject);
                this.realm.handlerController.realmObjects.put(realmObjectWeakReference, this);
            }
            return realmObject;
        }
        return null;
    }

    public E findFirstAsync() {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(3);
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        DynamicRealmObject result = this.isDynamicQuery() ? new DynamicRealmObject(this.className) : this.realm.getConfiguration().getSchemaMediator().newInstance(this.clazz, this.realm.getSchema().getColumnInfo(this.clazz));
        final WeakReference<RealmObject> realmObjectWeakReference = this.realm.handlerController.addToAsyncRealmObject(result, this);
        result.realm = this.realm;
        result.row = Row.EMPTY_ROW;
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverRowPointer = RealmQuery.this.query.findWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer);
                        if (handoverRowPointer == 0L) {
                            ((RealmQuery)RealmQuery.this).realm.handlerController.addToEmptyAsyncRealmObject(realmObjectWeakReference, RealmQuery.this);
                            ((RealmQuery)RealmQuery.this).realm.handlerController.removeFromAsyncRealmObject(realmObjectWeakReference);
                        }
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmObjectResponse();
                        result.updatedRow.put(realmObjectWeakReference, handoverRowPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 63245986, result);
                        Long l = handoverRowPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage(), e);
                        RealmQuery.this.closeSharedGroupAndSendMessageToHandler(sharedGroup, weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null && !sharedGroup.isClosed()) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        result.setPendingQuery(pendingQuery);
        return (E)result;
    }

    private void checkSortParameters(String[] fieldNames, Sort[] sortOrders) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames cannot be 'null'.");
        }
        if (sortOrders == null) {
            throw new IllegalArgumentException("sortOrders cannot be 'null'.");
        }
        if (fieldNames.length == 0) {
            throw new IllegalArgumentException("At least one field name must be specified.");
        }
        if (fieldNames.length != sortOrders.length) {
            throw new IllegalArgumentException(String.format("Number of field names (%d) and sort orders (%d) does not match.", fieldNames.length, sortOrders.length));
        }
    }

    private WeakReference<Handler> getWeakReferenceHandler() {
        if (this.realm.handler == null) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper. Async queries need a Handler to send results of your query");
        }
        return new WeakReference<Handler>(this.realm.handler);
    }

    private void closeSharedGroupAndSendMessageToHandler(SharedGroup sharedGroup, WeakReference<Handler> weakHandler, int what, Object obj) {
        Handler handler;
        if (sharedGroup != null) {
            sharedGroup.close();
        }
        if ((handler = (Handler)weakHandler.get()) != null && handler.getLooper().getThread().isAlive()) {
            handler.obtainMessage(what, obj).sendToTarget();
        }
    }

    private void checkQueryIsNotReused() {
        if (this.argumentsHolder != null) {
            throw new IllegalStateException("This RealmQuery is already used by a find* query, please create a new query");
        }
    }

    private long getSourceRowIndexForFirstObject() {
        long rowIndex = this.query.find();
        if (rowIndex < 0L) {
            return rowIndex;
        }
        if (this.view != null) {
            return this.view.getTargetRowIndex(rowIndex);
        }
        if (this.table instanceof TableView) {
            return ((TableView)this.table).getSourceRowIndex(rowIndex);
        }
        return rowIndex;
    }

    public ArgumentsHolder getArgument() {
        return this.argumentsHolder;
    }

    long handoverQueryPointer() {
        return this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
    }
}

