/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.annotations.RealmClass;
import io.realm.internal.InvalidRow;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.log.RealmLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import rx.Observable;

@RealmClass
public abstract class RealmObject {
    protected Row row;
    protected BaseRealm realm;
    private final List<RealmChangeListener> listeners = new CopyOnWriteArrayList<RealmChangeListener>();
    private Future<Long> pendingQuery;
    private boolean isCompleted = false;
    protected long currentTableVersion = -1L;

    public void removeFromRealm() {
        if (this.row == null) {
            throw new IllegalStateException("Object malformed: missing object in Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        if (this.realm == null) {
            throw new IllegalStateException("Object malformed: missing Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        this.realm.checkIfValid();
        this.row.getTable().moveLastOver(this.row.getIndex());
        this.row = InvalidRow.INSTANCE;
    }

    public final boolean isValid() {
        return this.row != null && this.row.isAttached();
    }

    protected Table getTable() {
        return this.realm.schema.getTable(this.getClass());
    }

    void setPendingQuery(Future<Long> pendingQuery) {
        this.pendingQuery = pendingQuery;
        if (this.isLoaded()) {
            this.onCompleted();
        }
    }

    public final boolean isLoaded() {
        if (this.realm == null) {
            return true;
        }
        this.realm.checkIfValid();
        return this.pendingQuery == null || this.isCompleted;
    }

    public final boolean load() {
        if (this.isLoaded()) {
            return true;
        }
        return this.onCompleted();
    }

    boolean onCompleted() {
        try {
            Long handoverResult = this.pendingQuery.get();
            if (handoverResult != 0L) {
                this.onCompleted(handoverResult);
                this.notifyChangeListeners();
            } else {
                this.isCompleted = true;
            }
        }
        catch (Exception e) {
            RealmLog.d(e.getMessage());
            return false;
        }
        return true;
    }

    void onCompleted(Long handoverRowPointer) {
        if (handoverRowPointer == 0L) {
            this.isCompleted = true;
        } else if (!this.isCompleted || this.row == Row.EMPTY_ROW) {
            this.isCompleted = true;
            long nativeRowPointer = TableQuery.nativeImportHandoverRowIntoSharedGroup(handoverRowPointer, this.realm.sharedGroupManager.getNativePointer());
            Table table = this.getTable();
            this.row = table.getUncheckedRowByPointer(nativeRowPointer);
        }
    }

    public final void addChangeListener(RealmChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot add listener from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        if (this.realm.handler == null) {
            throw new IllegalStateException("You can't register a listener from a non-Looper thread ");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeChangeListener(RealmChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot remove listener from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        this.listeners.remove(listener);
    }

    public final void removeChangeListeners() {
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot remove listeners from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        this.listeners.clear();
    }

    public <E extends RealmObject> Observable<E> asObservable() {
        if (this.realm instanceof Realm) {
            RealmObject obj = this;
            return this.realm.configuration.getRxFactory().from((Realm)this.realm, obj);
        }
        if (this.realm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.realm;
            DynamicRealmObject dynamicObject = (DynamicRealmObject)this;
            Observable<DynamicRealmObject> observable = this.realm.configuration.getRxFactory().from(dynamicRealm, dynamicObject);
            return observable;
        }
        throw new UnsupportedOperationException(this.realm.getClass() + " not supported");
    }

    void notifyChangeListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            if (this.row.getTable() == null) {
                return;
            }
            long version = this.row.getTable().version();
            if (this.currentTableVersion != version) {
                this.currentTableVersion = version;
                for (RealmChangeListener listener : this.listeners) {
                    listener.onChange();
                }
            }
        }
    }

    void setTableVersion() {
        if (this.row.getTable() != null) {
            this.currentTableVersion = this.row.getTable().version();
        }
    }
}

