/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.internal.ColumnIndices;
import io.realm.internal.log.RealmLog;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

class RealmCache {
    private final EnumMap<RealmCacheType, RefAndCount> refAndCountMap;
    private final RealmConfiguration configuration;
    private ColumnIndices typedColumnIndices;
    private static Map<String, RealmCache> cachesMap = new HashMap<String, RealmCache>();
    private static final String DIFFERENT_KEY_MESSAGE = "Wrong key used to decrypt Realm.";
    private static final String WRONG_REALM_CLASS_MESSAGE = "The type of Realm class must be Realm or DynamicRealm.";

    private RealmCache(RealmConfiguration config) {
        this.configuration = config;
        this.refAndCountMap = new EnumMap(RealmCacheType.class);
        for (RealmCacheType type : RealmCacheType.values()) {
            this.refAndCountMap.put(type, new RefAndCount());
        }
    }

    static synchronized <E extends BaseRealm> E createRealmOrGetFromCache(RealmConfiguration configuration, Class<E> realmClass) {
        Integer refCount;
        boolean isCacheInMap = true;
        RealmCache cache = cachesMap.get(configuration.getPath());
        if (cache == null) {
            cache = new RealmCache(configuration);
            isCacheInMap = false;
        } else {
            cache.validateConfiguration(configuration);
        }
        RefAndCount refAndCount = cache.refAndCountMap.get((Object)RealmCacheType.valueOf(realmClass));
        if (refAndCount.localRealm.get() == null) {
            BaseRealm realm;
            if (realmClass == Realm.class) {
                realm = Realm.createInstance(configuration, cache.typedColumnIndices);
            } else if (realmClass == DynamicRealm.class) {
                realm = DynamicRealm.createInstance(configuration);
            } else {
                throw new IllegalArgumentException(WRONG_REALM_CLASS_MESSAGE);
            }
            if (!isCacheInMap) {
                cachesMap.put(configuration.getPath(), cache);
            }
            refAndCount.localRealm.set(realm);
            refAndCount.localCount.set(0);
        }
        if ((refCount = (Integer)refAndCount.localCount.get()) == 0) {
            if (realmClass == Realm.class && refAndCount.globalCount == 0) {
                cache.typedColumnIndices = ((BaseRealm)((RefAndCount)refAndCount).localRealm.get()).schema.columnIndices;
            }
            refAndCount.globalCount++;
        }
        refAndCount.localCount.set(refCount + 1);
        BaseRealm realm = (BaseRealm)refAndCount.localRealm.get();
        return (E)realm;
    }

    static synchronized void release(BaseRealm realm) {
        String canonicalPath = realm.getPath();
        RealmCache cache = cachesMap.get(canonicalPath);
        Integer refCount = null;
        RefAndCount refAndCount = null;
        if (cache != null) {
            refAndCount = cache.refAndCountMap.get((Object)RealmCacheType.valueOf(realm.getClass()));
            refCount = (Integer)refAndCount.localCount.get();
        }
        if (refCount == null) {
            refCount = 0;
        }
        if (refCount <= 0) {
            RealmLog.w("Realm " + canonicalPath + " has been closed already.");
            return;
        }
        if ((refCount = Integer.valueOf(refCount - 1)) == 0) {
            refAndCount.localCount.set(null);
            refAndCount.localRealm.set(null);
            refAndCount.globalCount--;
            if (refAndCount.globalCount < 0) {
                throw new IllegalStateException("Global reference counter of Realm" + canonicalPath + " got corrupted.");
            }
            if (realm instanceof Realm && refAndCount.globalCount == 0) {
                cache.typedColumnIndices = null;
            }
            int totalRefCount = 0;
            for (RealmCacheType type : RealmCacheType.values()) {
                totalRefCount += cache.refAndCountMap.get((Object)type).globalCount;
            }
            if (totalRefCount == 0) {
                cachesMap.remove(canonicalPath);
            }
            realm.doClose();
        } else {
            refAndCount.localCount.set(refCount);
        }
    }

    private void validateConfiguration(RealmConfiguration newConfiguration) {
        if (this.configuration.equals(newConfiguration)) {
            return;
        }
        if (!Arrays.equals(this.configuration.getEncryptionKey(), newConfiguration.getEncryptionKey())) {
            throw new IllegalArgumentException(DIFFERENT_KEY_MESSAGE);
        }
        throw new IllegalArgumentException("Configurations cannot be different if used to open the same file. \nCached configuration: \n" + this.configuration + "\n\nNew configuration: \n" + newConfiguration);
    }

    static synchronized void invokeWithGlobalRefCount(RealmConfiguration configuration, Callback callback) {
        RealmCache cache = cachesMap.get(configuration.getPath());
        if (cache == null) {
            callback.onResult(0);
            return;
        }
        int totalRefCount = 0;
        for (RealmCacheType type : RealmCacheType.values()) {
            totalRefCount += cache.refAndCountMap.get((Object)type).globalCount;
        }
        callback.onResult(totalRefCount);
    }

    private static enum RealmCacheType {
        TYPED_REALM,
        DYNAMIC_REALM;


        static RealmCacheType valueOf(Class<? extends BaseRealm> clazz) {
            if (clazz == Realm.class) {
                return TYPED_REALM;
            }
            if (clazz == DynamicRealm.class) {
                return DYNAMIC_REALM;
            }
            throw new IllegalArgumentException(RealmCache.WRONG_REALM_CLASS_MESSAGE);
        }
    }

    private static class RefAndCount {
        private final ThreadLocal<BaseRealm> localRealm = new ThreadLocal();
        private final ThreadLocal<Integer> localCount = new ThreadLocal();
        private int globalCount = 0;

        private RefAndCount() {
        }
    }

    static interface Callback {
        public void onResult(int var1);
    }
}

