/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Message;
import io.realm.BaseRealm;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.internal.IdentitySet;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.internal.log.RealmLog;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public class HandlerController
implements Handler.Callback {
    protected final CopyOnWriteArrayList<RealmChangeListener> changeListeners = new CopyOnWriteArrayList();
    protected final List<WeakReference<RealmChangeListener>> weakChangeListeners = new CopyOnWriteArrayList<WeakReference<RealmChangeListener>>();
    static final int REALM_CHANGED = 14930352;
    static final int COMPLETED_UPDATE_ASYNC_QUERIES = 24157817;
    static final int COMPLETED_ASYNC_REALM_RESULTS = 39088169;
    static final int COMPLETED_ASYNC_REALM_OBJECT = 63245986;
    static final int REALM_ASYNC_BACKGROUND_EXCEPTION = 102334155;
    final BaseRealm realm;
    private Future updateAsyncQueriesTask;
    final ReferenceQueue<RealmResults<? extends RealmObject>> referenceQueueAsyncRealmResults = new ReferenceQueue();
    final ReferenceQueue<RealmResults<? extends RealmObject>> referenceQueueSyncRealmResults = new ReferenceQueue();
    final ReferenceQueue<RealmObject> referenceQueueRealmObject = new ReferenceQueue();
    final Map<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> asyncRealmResults = new IdentityHashMap<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>();
    final Map<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>> emptyAsyncRealmObject = new IdentityHashMap<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>>();
    final IdentitySet<WeakReference<RealmResults<? extends RealmObject>>> syncRealmResults = new IdentitySet();
    final Map<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>> realmObjects = new IdentityHashMap<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>>();

    public HandlerController(BaseRealm realm) {
        this.realm = realm;
    }

    public boolean handleMessage(Message message) {
        if (this.realm.sharedGroupManager != null) {
            switch (message.what) {
                case 14930352: {
                    this.realmChanged();
                    break;
                }
                case 39088169: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmResults(result);
                    break;
                }
                case 63245986: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncRealmObject(result);
                    break;
                }
                case 24157817: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncQueriesUpdate(result);
                    break;
                }
                case 102334155: {
                    throw (Error)message.obj;
                }
            }
        }
        return true;
    }

    void addChangeListener(RealmChangeListener listener) {
        this.changeListeners.addIfAbsent(listener);
    }

    void addChangeListenerAsWeakReference(RealmChangeListener listener) {
        Iterator<WeakReference<RealmChangeListener>> iterator = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        boolean addListener = true;
        while (iterator.hasNext()) {
            WeakReference<RealmChangeListener> weakRef = iterator.next();
            RealmChangeListener weakListener = (RealmChangeListener)weakRef.get();
            if (weakListener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
            }
            if (weakListener != listener) continue;
            addListener = false;
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
        if (addListener) {
            this.weakChangeListeners.add(new WeakReference<RealmChangeListener>(listener));
        }
    }

    void removeChangeListener(RealmChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    void removeAllChangeListeners() {
        this.changeListeners.clear();
    }

    void notifyGlobalListeners() {
        for (RealmChangeListener listener : this.changeListeners) {
            listener.onChange();
        }
        Iterator<WeakReference<RealmChangeListener>> iteratorWeakListeners = this.weakChangeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        while (iteratorWeakListeners.hasNext()) {
            WeakReference<RealmChangeListener> weakRef = iteratorWeakListeners.next();
            RealmChangeListener listener = (RealmChangeListener)weakRef.get();
            if (listener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.weakChangeListeners.size());
                }
                toRemoveList.add(weakRef);
                continue;
            }
            listener.onChange();
        }
        if (toRemoveList != null) {
            this.weakChangeListeners.removeAll(toRemoveList);
        }
    }

    void notifyTypeBasedListeners() {
        this.notifyAsyncRealmResultsCallbacks();
        this.notifySyncRealmResultsCallbacks();
        this.notifyRealmObjectCallbacks();
    }

    void updateAsyncEmptyRealmObject() {
        Iterator<Map.Entry<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>> next = iterator.next();
            if (next.getKey().get() != null) {
                Realm.asyncQueryExecutor.submit(QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(next.getKey(), next.getValue().handoverQueryPointer(), next.getValue().getArgument()).sendToHandler(this.realm.handler, 63245986).build());
                continue;
            }
            iterator.remove();
        }
    }

    private void notifyAsyncRealmResultsCallbacks() {
        this.notifyRealmResultsCallbacks(this.asyncRealmResults.keySet().iterator());
    }

    private void notifySyncRealmResultsCallbacks() {
        this.notifyRealmResultsCallbacks(this.syncRealmResults.keySet().iterator());
    }

    private void notifyRealmResultsCallbacks(Iterator<WeakReference<RealmResults<? extends RealmObject>>> iterator) {
        ArrayList<RealmResults> resultsToBeNotified = new ArrayList<RealmResults>();
        while (iterator.hasNext()) {
            WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = iterator.next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            resultsToBeNotified.add(realmResults);
        }
        for (RealmResults realmResults : resultsToBeNotified) {
            realmResults.notifyChangeListeners();
        }
    }

    private void notifyRealmObjectCallbacks() {
        ArrayList<RealmObject> objectsToBeNotified = new ArrayList<RealmObject>();
        Iterator<WeakReference<RealmObject>> iterator = this.realmObjects.keySet().iterator();
        while (iterator.hasNext()) {
            WeakReference<RealmObject> weakRealmObject = iterator.next();
            RealmObject realmObject = (RealmObject)weakRealmObject.get();
            if (realmObject == null) {
                iterator.remove();
                continue;
            }
            if (realmObject.row.isAttached()) {
                objectsToBeNotified.add(realmObject);
                continue;
            }
            if (realmObject.row == Row.EMPTY_ROW) continue;
            iterator.remove();
        }
        for (RealmObject realmObject : objectsToBeNotified) {
            realmObject.notifyChangeListeners();
        }
    }

    private void updateAsyncQueries() {
        if (this.updateAsyncQueriesTask != null && !this.updateAsyncQueriesTask.isDone()) {
            this.updateAsyncQueriesTask.cancel(true);
            Realm.asyncQueryExecutor.getQueue().remove(this.updateAsyncQueriesTask);
            RealmLog.d("REALM_CHANGED realm:" + this + " cancelling pending COMPLETED_UPDATE_ASYNC_QUERIES updates");
        }
        RealmLog.d("REALM_CHANGED realm:" + this + " updating async queries, total: " + this.asyncRealmResults.size());
        QueryUpdateTask.Builder.UpdateQueryStep updateQueryStep = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration());
        QueryUpdateTask.Builder.RealmResultsQueryStep realmResultsQueryStep = null;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> entry = iterator.next();
            WeakReference<RealmResults<? extends RealmObject>> weakReference = entry.getKey();
            RealmResults realmResults = (RealmResults)weakReference.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResultsQueryStep = updateQueryStep.add(weakReference, entry.getValue().handoverQueryPointer(), entry.getValue().getArgument());
        }
        if (realmResultsQueryStep != null) {
            QueryUpdateTask queryUpdateTask = realmResultsQueryStep.sendToHandler(this.realm.handler, 24157817).build();
            this.updateAsyncQueriesTask = Realm.asyncQueryExecutor.submit(queryUpdateTask);
        }
    }

    private void realmChanged() {
        this.deleteWeakReferences();
        if (this.threadContainsAsyncQueries()) {
            this.updateAsyncQueries();
        } else {
            RealmLog.d("REALM_CHANGED realm:" + this + " no async queries, advance_read");
            this.realm.sharedGroupManager.advanceRead();
            this.notifyGlobalListeners();
            if (!this.realm.isClosed()) {
                this.notifySyncRealmResultsCallbacks();
            }
            if (!this.realm.isClosed()) {
                this.notifyRealmObjectCallbacks();
            }
            if (!this.realm.isClosed() && this.threadContainsAsyncEmptyRealmObject()) {
                this.updateAsyncEmptyRealmObject();
            }
        }
    }

    private void completedAsyncRealmResults(QueryUpdateTask.Result result) {
        Set<WeakReference<RealmResults<? extends RealmObject>>> updatedTableViewsKeys = result.updatedTableViews.keySet();
        if (updatedTableViewsKeys.size() > 0) {
            WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = updatedTableViewsKeys.iterator().next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                this.asyncRealmResults.remove(weakRealmResults);
                RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] realm:" + this + " RealmResults GC'd ignore results");
            } else {
                SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
                int compare = callerVersionID.compareTo(result.versionID);
                if (compare == 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " same versions, using results (RealmResults is not loaded)");
                        realmResults.swapTableViewPointer(result.updatedTableViews.get(weakRealmResults));
                        realmResults.notifyChangeListeners();
                    } else {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " ignoring result the RealmResults (is already loaded)");
                    }
                } else if (compare > 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is not loaded, rerunning the query against the latest version");
                        RealmQuery<? extends RealmObject> query = this.asyncRealmResults.get(weakRealmResults);
                        QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).add(weakRealmResults, query.handoverQueryPointer(), query.getArgument()).sendToHandler(this.realm.handler, 39088169).build();
                        Realm.asyncQueryExecutor.submit(queryUpdateTask);
                    } else {
                        RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is loaded ignore the outdated result");
                    }
                } else {
                    RealmLog.d("[COMPLETED_ASYNC_REALM_RESULTS " + weakRealmResults + "] , realm:" + this + " caller thread behind worker thread, ignore results (a batch update will update everything including this query)");
                }
            }
        }
    }

    private void completedAsyncQueriesUpdate(QueryUpdateTask.Result result) {
        SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
        int compare = callerVersionID.compareTo(result.versionID);
        if (compare > 0) {
            RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " caller is more advanced, rerun updates");
            this.realm.handler.sendEmptyMessage(14930352);
        } else {
            if (compare != 0) {
                RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " caller is behind  advance_read");
                this.realm.sharedGroupManager.advanceRead(result.versionID);
            }
            ArrayList<RealmResults> callbacksToNotify = new ArrayList<RealmResults>(result.updatedTableViews.size());
            for (Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, Long> entry : result.updatedTableViews.entrySet()) {
                WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = entry.getKey();
                RealmResults realmResults = (RealmResults)weakRealmResults.get();
                if (realmResults == null) {
                    this.asyncRealmResults.remove(weakRealmResults);
                    continue;
                }
                callbacksToNotify.add(realmResults);
                RealmLog.d("COMPLETED_UPDATE_ASYNC_QUERIES realm:" + this + " updating RealmResults " + weakRealmResults);
                realmResults.swapTableViewPointer(entry.getValue());
            }
            for (RealmResults realmResults : callbacksToNotify) {
                realmResults.notifyChangeListeners();
            }
            if (compare != 0) {
                this.notifyGlobalListeners();
                this.notifySyncRealmResultsCallbacks();
                this.notifyRealmObjectCallbacks();
            }
            this.updateAsyncQueriesTask = null;
        }
    }

    private void completedAsyncRealmObject(QueryUpdateTask.Result result) {
        WeakReference<RealmObject> realmObjectWeakReference;
        RealmObject realmObject;
        Set<WeakReference<RealmObject>> updatedRowKey = result.updatedRow.keySet();
        if (updatedRowKey.size() > 0 && (realmObject = (RealmObject)(realmObjectWeakReference = updatedRowKey.iterator().next()).get()) != null) {
            SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
            int compare = callerVersionID.compareTo(result.versionID);
            if (compare == 0) {
                long rowPointer = result.updatedRow.get(realmObjectWeakReference);
                if (rowPointer != 0L && this.emptyAsyncRealmObject.containsKey(realmObjectWeakReference)) {
                    this.emptyAsyncRealmObject.remove(realmObjectWeakReference);
                    this.realmObjects.put(realmObjectWeakReference, null);
                }
                realmObject.onCompleted(rowPointer);
                realmObject.notifyChangeListeners();
            } else if (compare > 0) {
                if (realmObject.isValid()) {
                    realmObject.notifyChangeListeners();
                } else {
                    RealmQuery<? extends RealmObject> realmQuery = this.realmObjects.get(realmObjectWeakReference);
                    if (realmQuery == null) {
                        realmQuery = this.emptyAsyncRealmObject.get(realmObjectWeakReference);
                    }
                    QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(realmObjectWeakReference, realmQuery.handoverQueryPointer(), realmQuery.getArgument()).sendToHandler(this.realm.handler, 63245986).build();
                    Realm.asyncQueryExecutor.submit(queryUpdateTask);
                }
            } else {
                throw new IllegalStateException("Caller thread behind the worker thread");
            }
        }
    }

    private boolean threadContainsAsyncQueries() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    boolean threadContainsAsyncEmptyRealmObject() {
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>>> iterator = this.emptyAsyncRealmObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    private void deleteWeakReferences() {
        Reference<RealmObject> weakReferenceObject;
        Reference<RealmResults<? extends RealmObject>> weakReferenceResults;
        while ((weakReferenceResults = this.referenceQueueAsyncRealmResults.poll()) != null) {
            this.asyncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceResults = this.referenceQueueSyncRealmResults.poll()) != null) {
            this.syncRealmResults.remove(weakReferenceResults);
        }
        while ((weakReferenceObject = this.referenceQueueRealmObject.poll()) != null) {
            this.realmObjects.remove(weakReferenceObject);
        }
    }

    WeakReference<RealmResults<? extends RealmObject>> addToAsyncRealmResults(RealmResults<? extends RealmObject> realmResults, RealmQuery<? extends RealmObject> realmQuery) {
        WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.referenceQueueAsyncRealmResults);
        this.asyncRealmResults.put(weakRealmResults, realmQuery);
        return weakRealmResults;
    }

    void addToRealmResults(RealmResults<? extends RealmObject> realmResults) {
        WeakReference<RealmResults<? extends RealmObject>> realmResultsWeakReference = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.referenceQueueSyncRealmResults);
        this.syncRealmResults.add(realmResultsWeakReference);
    }

    <E extends RealmObject> void addToRealmObjects(E realmobject) {
        this.realmObjects.put(new WeakReference<E>(realmobject), null);
    }

    <E extends RealmObject> WeakReference<RealmObject> addToAsyncRealmObject(E realmObject, RealmQuery<? extends RealmObject> realmQuery) {
        WeakReference<RealmObject> realmObjectWeakReference = new WeakReference<RealmObject>(realmObject, this.referenceQueueRealmObject);
        this.realmObjects.put(realmObjectWeakReference, realmQuery);
        return realmObjectWeakReference;
    }

    void removeFromAsyncRealmObject(WeakReference<RealmObject> realmObjectWeakReference) {
        this.realmObjects.remove(realmObjectWeakReference);
    }

    void addToEmptyAsyncRealmObject(WeakReference<RealmObject> realmObjectWeakReference, RealmQuery<? extends RealmObject> realmQuery) {
        this.emptyAsyncRealmObject.put(realmObjectWeakReference, realmQuery);
    }
}

