/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.internal.CheckedRow;
import io.realm.internal.LinkView;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import java.util.Arrays;
import java.util.Date;

public final class DynamicRealmObject
extends RealmObject {
    private String className;

    public DynamicRealmObject(RealmObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A non-null object must be provided.");
        }
        if (obj instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("The object is already a DynamicRealmObject: " + obj);
        }
        Row row = obj.row;
        if (!obj.isValid()) {
            throw new IllegalArgumentException("An object managed by Realm must be provided. This is a standalone object or it was deleted.");
        }
        this.realm = obj.realm;
        this.row = ((UncheckedRow)row).convertToChecked();
    }

    DynamicRealmObject() {
    }

    DynamicRealmObject(BaseRealm realm, Row row) {
        this.realm = realm;
        this.row = row instanceof CheckedRow ? (CheckedRow)row : ((UncheckedRow)row).convertToChecked();
    }

    DynamicRealmObject(String className) {
        this.className = className;
    }

    public <E> E get(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        RealmFieldType type = this.row.getColumnType(columnIndex);
        switch (type) {
            case BOOLEAN: {
                return (E)Boolean.valueOf(this.row.getBoolean(columnIndex));
            }
            case INTEGER: {
                return (E)Long.valueOf(this.row.getLong(columnIndex));
            }
            case FLOAT: {
                return (E)Float.valueOf(this.row.getFloat(columnIndex));
            }
            case DOUBLE: {
                return (E)Double.valueOf(this.row.getDouble(columnIndex));
            }
            case STRING: {
                return (E)this.row.getString(columnIndex);
            }
            case BINARY: {
                return (E)this.row.getBinaryByteArray(columnIndex);
            }
            case DATE: {
                return (E)this.row.getDate(columnIndex);
            }
            case OBJECT: {
                return (E)this.getObject(fieldName);
            }
            case LIST: {
                return (E)this.getList(fieldName);
            }
        }
        throw new IllegalStateException("Field type not supported: " + (Object)((Object)type));
    }

    public boolean getBoolean(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getBoolean(columnIndex);
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getLong(columnIndex);
    }

    public byte getByte(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return (byte)this.row.getLong(columnIndex);
    }

    public float getFloat(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getFloat(columnIndex);
    }

    public double getDouble(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getDouble(columnIndex);
    }

    public byte[] getBlob(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getBinaryByteArray(columnIndex);
    }

    public String getString(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getString(columnIndex);
    }

    public Date getDate(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (this.row.isNull(columnIndex)) {
            return null;
        }
        return this.row.getDate(columnIndex);
    }

    public DynamicRealmObject getObject(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (this.row.isNullLink(columnIndex)) {
            return null;
        }
        long linkRowIndex = this.row.getLink(columnIndex);
        CheckedRow linkRow = this.row.getTable().getLinkTarget(columnIndex).getCheckedRow(linkRowIndex);
        return new DynamicRealmObject(this.realm, linkRow);
    }

    public RealmList<DynamicRealmObject> getList(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        LinkView linkView = this.row.getLinkList(columnIndex);
        String className = linkView.getTable().getLinkTarget(columnIndex).getName().substring(Table.TABLE_PREFIX.length());
        return new RealmList<DynamicRealmObject>(className, linkView, this.realm);
    }

    public boolean isNull(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        RealmFieldType type = this.row.getColumnType(columnIndex);
        switch (type) {
            case OBJECT: {
                return this.row.isNullLink(columnIndex);
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: {
                return this.row.isNull(columnIndex);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.row.hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        String[] keys = new String[(int)this.row.getColumnCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.row.getColumnName(i);
        }
        return keys;
    }

    public void set(String fieldName, Object value) {
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        long columnIndex = this.row.getColumnIndex(fieldName);
        RealmFieldType type = this.row.getColumnType(columnIndex);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if (value == null) {
            this.setNull(fieldName);
        } else {
            this.setValue(fieldName, value);
        }
    }

    private void setValue(String fieldName, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (valueClass == DynamicRealmObject.class) {
            this.setObject(fieldName, (DynamicRealmObject)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else {
            throw new IllegalArgumentException("Value is of an type not supported: " + value.getClass());
        }
    }

    public void setBoolean(String fieldName, boolean value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setBoolean(columnIndex, value);
    }

    public void setShort(String fieldName, short value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setInt(String fieldName, int value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setLong(String fieldName, long value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setByte(String fieldName, byte value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setFloat(String fieldName, float value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setFloat(columnIndex, value);
    }

    public void setDouble(String fieldName, double value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setDouble(columnIndex, value);
    }

    public void setString(String fieldName, String value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setString(columnIndex, value);
    }

    public void setBlob(String fieldName, byte[] value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setBinaryByteArray(columnIndex, value);
    }

    public void setDate(String fieldName, Date value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (value == null) {
            this.row.setNull(columnIndex);
        } else {
            this.row.setDate(columnIndex, value);
        }
    }

    public void setObject(String fieldName, DynamicRealmObject value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (value == null) {
            this.row.nullifyLink(columnIndex);
        } else {
            Table inputTable;
            if (value.realm == null || value.row == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (!this.realm.getConfiguration().equals(value.realm.getConfiguration())) {
                throw new IllegalArgumentException("Cannot add an object from another Realm");
            }
            Table table = this.row.getTable().getLinkTarget(columnIndex);
            if (!table.hasSameSchema(inputTable = value.row.getTable())) {
                throw new IllegalArgumentException(String.format("Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.row.setLink(columnIndex, value.row.getIndex());
        }
    }

    public void setList(String fieldName, RealmList<? extends RealmObject> list) {
        boolean typeValidated;
        if (list == null) {
            throw new IllegalArgumentException("Null values not allowed for lists");
        }
        String tableName = this.row.getTable().getName();
        if (list.className == null && list.clazz == null) {
            typeValidated = false;
        } else {
            String listType;
            String string = listType = list.className != null ? list.className : this.realm.schema.getTable(list.clazz).getName();
            if (!tableName.equals(listType)) {
                throw new IllegalArgumentException(String.format("The elements in the list is not the proper type. Was %s expected %s.", listType, tableName));
            }
            typeValidated = true;
        }
        long columnIndex = this.row.getColumnIndex(fieldName);
        LinkView links = this.row.getLinkList(columnIndex);
        links.clear();
        for (int i = 0; i < list.size(); ++i) {
            String elementType;
            Object obj = list.get(i);
            if (!typeValidated && !tableName.equals(elementType = ((RealmObject)obj).row.getTable().getName())) {
                throw new IllegalArgumentException(String.format("Element at index %d is not the proper type. Was %s expected %s.", i, elementType, tableName));
            }
            links.add(((RealmObject)obj).row.getIndex());
        }
    }

    public void setNull(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        RealmFieldType type = this.row.getColumnType(columnIndex);
        if (type == RealmFieldType.OBJECT) {
            this.row.nullifyLink(columnIndex);
        } else {
            this.row.setNull(columnIndex);
        }
    }

    public String getType() {
        return this.row.getTable().getName().substring(Table.TABLE_PREFIX.length());
    }

    public RealmFieldType getFieldType(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getColumnType(columnIndex);
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.realm.getPath();
        String otherPath = other.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = other.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == other.row.getIndex();
    }

    public String toString() {
        String[] fields;
        if (this.row == null || !this.row.isAttached()) {
            return "Invalid object";
        }
        StringBuilder sb = new StringBuilder(this.row.getTable().getName() + " = [");
        for (String field : fields = this.getFieldNames()) {
            long columnIndex = this.row.getColumnIndex(field);
            RealmFieldType type = this.row.getColumnType(columnIndex);
            sb.append("{");
            switch (type) {
                case BOOLEAN: {
                    sb.append(field).append(": ").append(this.row.getBoolean(columnIndex));
                    break;
                }
                case INTEGER: {
                    sb.append(field).append(": ").append(this.row.getLong(columnIndex));
                    break;
                }
                case FLOAT: {
                    sb.append(field).append(": ").append(this.row.getFloat(columnIndex));
                    break;
                }
                case DOUBLE: {
                    sb.append(field).append(": ").append(this.row.getDouble(columnIndex));
                    break;
                }
                case STRING: {
                    sb.append(field).append(": ").append(this.row.getString(columnIndex));
                    break;
                }
                case BINARY: {
                    sb.append(field).append(": ").append(Arrays.toString(this.row.getBinaryByteArray(columnIndex)));
                    break;
                }
                case DATE: {
                    sb.append(field).append(": ").append(this.row.getDate(columnIndex));
                    break;
                }
                case OBJECT: {
                    if (this.row.isNullLink(columnIndex)) {
                        sb.append("null");
                        break;
                    }
                    sb.append(field).append(": ").append(this.row.getTable().getLinkTarget(columnIndex).getName());
                    break;
                }
                case LIST: {
                    String targetType = this.row.getTable().getLinkTarget(columnIndex).getName();
                    sb.append(String.format("%s: RealmList<%s>[%s]", field, targetType, this.row.getLinkList(columnIndex).size()));
                    break;
                }
                default: {
                    sb.append(field).append(": ?");
                }
            }
            sb.append("}, ");
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected Table getTable() {
        if (this.className != null) {
            return this.realm.schema.getTable(this.className);
        }
        return super.getTable();
    }
}

