/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Looper;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.HandlerController;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmFieldType;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.RealmSchema;
import io.realm.Sort;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.SharedGroupManager;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.ReleaseAndroidLogger;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.internal.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;

abstract class BaseRealm
implements Closeable {
    protected static final long UNVERSIONED = -1L;
    private static final String INCORRECT_THREAD_CLOSE_MESSAGE = "Realm access from incorrect thread. Realm instance can only be closed on the thread it was created.";
    private static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they were created.";
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String CANNOT_REFRESH_INSIDE_OF_TRANSACTION_MESSAGE = "Cannot refresh inside of a transaction.";
    protected static final Map<Handler, String> handlers = new ConcurrentHashMap<Handler, String>();
    static final RealmThreadPoolExecutor asyncQueryExecutor = RealmThreadPoolExecutor.getInstance();
    protected long threadId = Thread.currentThread().getId();
    protected RealmConfiguration configuration;
    protected SharedGroupManager sharedGroupManager;
    protected boolean autoRefresh;
    RealmSchema schema;
    Handler handler;
    HandlerController handlerController;

    protected BaseRealm(RealmConfiguration configuration, boolean autoRefresh) {
        this.configuration = configuration;
        this.sharedGroupManager = new SharedGroupManager(configuration);
        this.schema = new RealmSchema(this, this.sharedGroupManager.getTransaction());
        this.setAutoRefresh(autoRefresh);
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.checkIfValid();
        if (autoRefresh && Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot set auto-refresh in a Thread without a Looper");
        }
        if (autoRefresh && !this.autoRefresh) {
            this.handlerController = new HandlerController(this);
            this.handler = new Handler((Handler.Callback)this.handlerController);
            handlers.put(this.handler, this.configuration.getPath());
        } else if (!autoRefresh && this.autoRefresh && this.handler != null) {
            this.removeHandler();
        }
        this.autoRefresh = autoRefresh;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public boolean isInTransaction() {
        this.checkIfValid();
        return !this.sharedGroupManager.isImmutable();
    }

    public void addChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        if (this.handlerController == null) {
            throw new IllegalStateException("You can't register a listener from a non-Looper thread ");
        }
        this.handlerController.addChangeListener(listener);
    }

    public void removeChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        if (this.handlerController == null) {
            throw new IllegalStateException("You can't remove a listener from a non-Looper thread ");
        }
        this.handlerController.removeChangeListener(listener);
    }

    public abstract Observable asObservable();

    public void removeAllChangeListeners() {
        this.checkIfValid();
        if (this.handlerController == null) {
            throw new IllegalStateException("You can't remove listeners from a non-Looper thread ");
        }
        this.handlerController.removeAllChangeListeners();
    }

    void setHandler(Handler handler) {
        handlers.remove(this.handler);
        handlers.put(handler, this.configuration.getPath());
        this.handler = handler;
    }

    protected void removeHandler() {
        handlers.remove(this.handler);
        this.handler.removeCallbacksAndMessages(null);
        this.handler = null;
    }

    public void writeCopyTo(File destination) throws IOException {
        this.writeEncryptedCopyTo(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) throws IOException {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.sharedGroupManager.copyToFile(destination, key);
    }

    public void refresh() {
        this.checkIfValid();
        if (this.isInTransaction()) {
            throw new IllegalStateException(CANNOT_REFRESH_INSIDE_OF_TRANSACTION_MESSAGE);
        }
        this.sharedGroupManager.advanceRead();
        if (this.handlerController != null) {
            this.handlerController.notifyGlobalListeners();
            this.handlerController.notifyTypeBasedListeners();
            if (this.handlerController.threadContainsAsyncEmptyRealmObject()) {
                this.handlerController.updateAsyncEmptyRealmObject();
            }
        }
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.promoteToWrite();
    }

    public void commitTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.commitAndContinueAsRead();
        for (Map.Entry<Handler, String> handlerIntegerEntry : handlers.entrySet()) {
            Handler handler = handlerIntegerEntry.getKey();
            String realmPath = handlerIntegerEntry.getValue();
            if (handler.equals(this.handler)) {
                this.handlerController.notifyGlobalListeners();
                this.handlerController.notifyTypeBasedListeners();
                if (!this.handlerController.threadContainsAsyncEmptyRealmObject()) continue;
                this.handlerController.updateAsyncEmptyRealmObject();
                continue;
            }
            if (!realmPath.equals(this.configuration.getPath()) || handler.hasMessages(14930352) || !handler.getLooper().getThread().isAlive() || handler.sendEmptyMessage(14930352)) continue;
            RealmLog.w("Cannot update Looper threads when the Looper has quit. Use realm.setAutoRefresh(false) to prevent this.");
        }
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.rollbackAndContinueAsRead();
    }

    protected void checkIfValid() {
        if (this.sharedGroupManager == null || !this.sharedGroupManager.isOpen()) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    public long getVersion() {
        if (!this.sharedGroupManager.hasTable("metadata")) {
            return -1L;
        }
        Table metadataTable = this.sharedGroupManager.getTable("metadata");
        return metadataTable.getLong(0L, 0L);
    }

    @Override
    public void close() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_CLOSE_MESSAGE);
        }
        RealmCache.release(this);
    }

    void doClose() {
        if (this.sharedGroupManager != null) {
            this.sharedGroupManager.close();
            this.sharedGroupManager = null;
        }
        if (this.handler != null) {
            this.removeHandler();
        }
    }

    public boolean isClosed() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
        return this.sharedGroupManager == null || !this.sharedGroupManager.isOpen();
    }

    public boolean isEmpty() {
        this.checkIfValid();
        return this.sharedGroupManager.getTransaction().isObjectTablesEmpty();
    }

    boolean hasChanged() {
        return this.sharedGroupManager.hasChanged();
    }

    void setVersion(long version) {
        Table metadataTable = this.sharedGroupManager.getTable("metadata");
        if (metadataTable.getColumnCount() == 0L) {
            metadataTable.addColumn(RealmFieldType.INTEGER, "version");
            metadataTable.addEmptyRow();
        }
        metadataTable.setLong(0L, 0L, version);
    }

    protected TableView doMultiFieldSort(String[] fieldNames, Sort[] sortOrders, Table table) {
        long[] columnIndices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            long columnIndex = table.getColumnIndex(fieldName);
            if (columnIndex == -1L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices[i] = columnIndex;
        }
        return table.getSortedView(columnIndices, sortOrders);
    }

    protected void checkAllObjectsSortedParameters(String[] fieldNames, Sort[] sortOrders) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames must be provided.");
        }
        if (sortOrders == null) {
            throw new IllegalArgumentException("sortOrders must be provided.");
        }
    }

    protected void checkNotNullFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must be provided.");
        }
    }

    public RealmSchema getSchema() {
        return this.schema;
    }

    <E extends RealmObject> E get(Class<E> clazz, long rowIndex) {
        Table table = this.schema.getTable(clazz);
        UncheckedRow row = table.getUncheckedRow(rowIndex);
        E result = this.configuration.getSchemaMediator().newInstance(clazz, this.schema.getColumnInfo(clazz));
        ((RealmObject)result).row = row;
        ((RealmObject)result).realm = this;
        ((RealmObject)result).setTableVersion();
        if (this.handlerController != null) {
            this.handlerController.addToRealmObjects(result);
        }
        return result;
    }

    <E extends RealmObject> E get(Class<E> clazz, String dynamicClassName, long rowIndex) {
        DynamicRealmObject result;
        Table table;
        if (dynamicClassName != null) {
            DynamicRealmObject dynamicObj;
            table = this.schema.getTable(dynamicClassName);
            result = dynamicObj = new DynamicRealmObject();
        } else {
            table = this.schema.getTable(clazz);
            result = this.configuration.getSchemaMediator().newInstance(clazz, this.schema.getColumnInfo(clazz));
        }
        result.row = table.getUncheckedRow(rowIndex);
        result.realm = this;
        result.setTableVersion();
        if (this.handlerController != null) {
            this.handlerController.addToRealmObjects(result);
        }
        return (E)result;
    }

    static boolean deleteRealm(final RealmConfiguration configuration) {
        final AtomicBoolean realmDeleted = new AtomicBoolean(true);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count != 0) {
                    throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file.");
                }
                String canonicalPath = configuration.getPath();
                File realmFolder = configuration.getRealmFolder();
                String realmFileName = configuration.getRealmFileName();
                List<File> filesToDelete = Arrays.asList(new File(canonicalPath), new File(realmFolder, realmFileName + ".lock"), new File(realmFolder, realmFileName + ".log_a"), new File(realmFolder, realmFileName + ".log_b"), new File(realmFolder, realmFileName + ".log"));
                for (File fileToDelete : filesToDelete) {
                    boolean deleteResult;
                    if (!fileToDelete.exists() || (deleteResult = fileToDelete.delete())) continue;
                    realmDeleted.set(false);
                    RealmLog.w("Could not delete the file " + fileToDelete);
                }
            }
        });
        return realmDeleted.get();
    }

    static boolean compactRealm(RealmConfiguration configuration) {
        if (configuration.getEncryptionKey() != null) {
            throw new IllegalArgumentException("Cannot currently compact an encrypted Realm.");
        }
        return SharedGroupManager.compact(configuration);
    }

    protected static void migrateRealm(final RealmConfiguration configuration, final RealmMigration migration, final MigrationCallback callback) {
        if (configuration == null) {
            throw new IllegalArgumentException("RealmConfiguration must be provided");
        }
        if (migration == null && configuration.getMigration() == null) {
            throw new RealmMigrationNeededException(configuration.getPath(), "RealmMigration must be provided");
        }
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                if (count != 0) {
                    throw new IllegalStateException("Cannot migrate a Realm file that is already open: " + configuration.getPath());
                }
                RealmMigration realmMigration = migration == null ? configuration.getMigration() : migration;
                DynamicRealm realm = null;
                try {
                    realm = DynamicRealm.getInstance(configuration);
                    realm.beginTransaction();
                    long currentVersion = realm.getVersion();
                    realmMigration.migrate(realm, currentVersion, configuration.getSchemaVersion());
                    realm.setVersion(configuration.getSchemaVersion());
                    realm.commitTransaction();
                }
                catch (RuntimeException e) {
                    if (realm != null) {
                        realm.cancelTransaction();
                    }
                    throw e;
                }
                finally {
                    if (realm != null) {
                        realm.close();
                        callback.migrationComplete();
                    }
                }
            }
        });
    }

    static {
        RealmLog.add(new ReleaseAndroidLogger());
    }

    protected static interface MigrationCallback {
        public void migrationComplete();
    }
}

