/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.Utils;
import io.realm.processor.javawriter.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RealmJsonTypeHelper {
    private static final Map<String, JsonToRealmTypeConverter> JAVA_TO_JSON_TYPES = new HashMap<String, JsonToRealmTypeConverter>();

    public static void emitFillJavaTypeWithJsonValue(String setter, String fieldName, String qualifiedFieldType, JavaWriter writer) throws IOException {
        JsonToRealmTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(qualifiedFieldType);
        if (typeEmitter != null) {
            typeEmitter.emitTypeConversion(setter, fieldName, qualifiedFieldType, writer);
        }
    }

    public static void emitFillRealmObjectWithJsonValue(String setter, String fieldName, String qualifiedFieldType, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", fieldName).beginControlFlow("if (json.isNull(\"%s\"))", fieldName).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createOrUpdateUsingJsonObject(realm, json.getJSONObject(\"%s\"), update)", qualifiedFieldType, fieldName, proxyClass, fieldName).emitStatement("obj.%s(%sObj)", setter, fieldName).endControlFlow().endControlFlow();
    }

    public static void emitFillRealmListWithJsonValue(String getter, String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", fieldName).beginControlFlow("if (json.isNull(\"%s\"))", fieldName).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("obj.%s().clear()", getter).emitStatement("JSONArray array = json.getJSONArray(\"%s\")", fieldName).beginControlFlow("for (int i = 0; i < array.length(); i++)", new Object[0]).emitStatement("%s item = %s.createOrUpdateUsingJsonObject(realm, array.getJSONObject(i), update)", fieldTypeCanonicalName, proxyClass, fieldTypeCanonicalName).emitStatement("obj.%s().add(item)", getter).endControlFlow().endControlFlow().endControlFlow();
    }

    public static void emitFillJavaTypeFromStream(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
        if (JAVA_TO_JSON_TYPES.containsKey(fieldType)) {
            JAVA_TO_JSON_TYPES.get(fieldType).emitStreamTypeConversion(setter, fieldName, fieldType, writer);
        }
    }

    public static void emitFillRealmObjectFromStream(String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createUsingJsonStream(realm, reader)", fieldTypeCanonicalName, fieldName, proxyClass).emitStatement("obj.%s(%sObj)", setter, fieldName).endControlFlow();
    }

    public static void emitFillRealmListFromStream(String getter, String setter, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("reader.beginArray()", new Object[0]).beginControlFlow("while (reader.hasNext())", new Object[0]).emitStatement("%s item = %s.createUsingJsonStream(realm, reader)", fieldTypeCanonicalName, proxyClass).emitStatement("obj.%s().add(item)", getter).endControlFlow().emitStatement("reader.endArray()", new Object[0]).endControlFlow();
    }

    static {
        JAVA_TO_JSON_TYPES.put("byte", new SimpleTypeConverter("byte", "Int"));
        JAVA_TO_JSON_TYPES.put("short", new SimpleTypeConverter("short", "Int"));
        JAVA_TO_JSON_TYPES.put("int", new SimpleTypeConverter("int", "Int"));
        JAVA_TO_JSON_TYPES.put("long", new SimpleTypeConverter("long", "Long"));
        JAVA_TO_JSON_TYPES.put("float", new SimpleTypeConverter("float", "Double"));
        JAVA_TO_JSON_TYPES.put("double", new SimpleTypeConverter("double", "Double"));
        JAVA_TO_JSON_TYPES.put("boolean", new SimpleTypeConverter("boolean", "Boolean"));
        JAVA_TO_JSON_TYPES.put("java.lang.Byte", new SimpleTypeConverter("byte", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Short", new SimpleTypeConverter("short", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Integer", new SimpleTypeConverter("int", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Long", new SimpleTypeConverter("long", "Long"));
        JAVA_TO_JSON_TYPES.put("java.lang.Float", new SimpleTypeConverter("float", "Double"));
        JAVA_TO_JSON_TYPES.put("java.lang.Double", new SimpleTypeConverter("double", "Double"));
        JAVA_TO_JSON_TYPES.put("java.lang.Boolean", new SimpleTypeConverter("boolean", "Boolean"));
        JAVA_TO_JSON_TYPES.put("java.lang.String", new SimpleTypeConverter("String", "String"));
        JAVA_TO_JSON_TYPES.put("java.util.Date", new JsonToRealmTypeConverter(){

            @Override
            public void emitTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (json.has(\"%s\"))", fieldName).beginControlFlow("if (json.isNull(\"%s\"))", fieldName).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("Object timestamp = json.get(\"%s\")", fieldName).beginControlFlow("if (timestamp instanceof String)", new Object[0]).emitStatement("obj.%s(JsonUtils.stringToDate((String) timestamp))", setter).nextControlFlow("else", new Object[0]).emitStatement("obj.%s(new Date(json.getLong(\"%s\")))", setter, fieldName).endControlFlow().endControlFlow().endControlFlow();
            }

            @Override
            public void emitStreamTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("obj.%s(null)", setter).nextControlFlow("else if (reader.peek() == JsonToken.NUMBER)", new Object[0]).emitStatement("long timestamp = reader.nextLong()", fieldName).beginControlFlow("if (timestamp > -1)", new Object[0]).emitStatement("obj.%s(new Date(timestamp))", setter).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("obj.%s(JsonUtils.stringToDate(reader.nextString()))", setter).endControlFlow();
            }
        });
        JAVA_TO_JSON_TYPES.put("byte[]", new JsonToRealmTypeConverter(){

            @Override
            public void emitTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (json.has(\"%s\"))", fieldName).beginControlFlow("if (json.isNull(\"%s\"))", fieldName).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("obj.%s(JsonUtils.stringToBytes(json.getString(\"%s\")))", setter, fieldName).endControlFlow().endControlFlow();
            }

            @Override
            public void emitStreamTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("obj.%s(null)", setter).nextControlFlow("else", new Object[0]).emitStatement("obj.%s(JsonUtils.stringToBytes(reader.nextString()))", setter).endControlFlow();
            }
        });
    }

    private static interface JsonToRealmTypeConverter {
        public void emitTypeConversion(String var1, String var2, String var3, JavaWriter var4) throws IOException;

        public void emitStreamTypeConversion(String var1, String var2, String var3, JavaWriter var4) throws IOException;
    }

    private static class SimpleTypeConverter
    implements JsonToRealmTypeConverter {
        private final String castType;
        private final String jsonType;

        private SimpleTypeConverter(String castType, String jsonType) {
            this.castType = castType;
            this.jsonType = jsonType;
        }

        @Override
        public void emitTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format("throw new IllegalArgumentException(\"Trying to set non-nullable field %s to null.\")", fieldName) : String.format("obj.%s(null)", setter);
            writer.beginControlFlow("if (json.has(\"%s\"))", fieldName).beginControlFlow("if (json.isNull(\"%s\"))", fieldName).emitStatement(statementSetNullOrThrow, new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("obj.%s((%s) json.get%s(\"%s\"))", setter, this.castType, this.jsonType, fieldName).endControlFlow().endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format("throw new IllegalArgumentException(\"Trying to set non-nullable field %s to null.\")", fieldName) : String.format("obj.%s(null)", setter);
            writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement(statementSetNullOrThrow, new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("obj.%s((%s) reader.next%s())", setter, this.castType, this.jsonType).endControlFlow();
        }
    }
}

