/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.async;

import android.os.Handler;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.internal.SharedGroup;
import io.realm.internal.TableQuery;
import io.realm.internal.async.ArgumentsHolder;
import io.realm.internal.log.RealmLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class QueryUpdateTask
implements Runnable {
    private static final int MODE_UPDATE_REALM_RESULTS = 0;
    private static final int MODE_UPDATE_REALM_OBJECT = 1;
    private final int updateMode;
    private RealmConfiguration realmConfiguration;
    private List<Builder.QueryEntry> realmResultsEntries;
    private Builder.QueryEntry realmObjectEntry;
    private WeakReference<Handler> callerHandler;
    private int message;

    private QueryUpdateTask(int mode, RealmConfiguration realmConfiguration, List<Builder.QueryEntry> listOfRealmResults, Builder.QueryEntry realmObject, WeakReference<Handler> handler, int message) {
        this.updateMode = mode;
        this.realmConfiguration = realmConfiguration;
        this.realmResultsEntries = listOfRealmResults;
        this.realmObjectEntry = realmObject;
        this.callerHandler = handler;
        this.message = message;
    }

    public static Builder.RealmConfigurationStep newBuilder() {
        return new Builder.Steps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SharedGroup sharedGroup = null;
        try {
            Result result;
            sharedGroup = new SharedGroup(this.realmConfiguration.getPath(), true, this.realmConfiguration.getDurability(), this.realmConfiguration.getEncryptionKey());
            boolean updateSuccessful = false;
            if (this.updateMode == 0) {
                result = Result.newRealmResultsResponse();
                updateSuccessful = this.updateRealmResultsQueries(sharedGroup, result);
                result.versionID = sharedGroup.getVersion();
            } else {
                result = Result.newRealmObjectResponse();
                updateSuccessful = this.updateRealmObjectQuery(sharedGroup, result);
                result.versionID = sharedGroup.getVersion();
            }
            Handler handler = (Handler)this.callerHandler.get();
            if (updateSuccessful && !this.isTaskCancelled() && this.isAliveHandler(handler)) {
                handler.obtainMessage(this.message, (Object)result).sendToTarget();
            }
        }
        catch (Exception e) {
            RealmLog.e(e.getMessage());
            e.fillInStackTrace();
        }
        finally {
            if (sharedGroup != null) {
                sharedGroup.close();
            }
        }
    }

    private boolean updateRealmResultsQueries(SharedGroup sharedGroup, Result result) {
        for (Builder.QueryEntry queryEntry : this.realmResultsEntries) {
            if (!this.isTaskCancelled()) {
                switch (queryEntry.queryArguments.type) {
                    case 0: {
                        long handoverTableViewPointer = TableQuery.nativeFindAllWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), queryEntry.handoverQueryPointer, 0L, -1L, -1L);
                        result.updatedTableViews.put(queryEntry.element, handoverTableViewPointer);
                        queryEntry.handoverQueryPointer = 0L;
                        break;
                    }
                    case 4: {
                        long handoverTableViewPointer = TableQuery.nativeGetDistinctViewWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), queryEntry.handoverQueryPointer, queryEntry.queryArguments.columnIndex);
                        result.updatedTableViews.put(queryEntry.element, handoverTableViewPointer);
                        queryEntry.handoverQueryPointer = 0L;
                        break;
                    }
                    case 1: {
                        long handoverTableViewPointer = TableQuery.nativeFindAllSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), queryEntry.handoverQueryPointer, 0L, -1L, -1L, queryEntry.queryArguments.columnIndex, queryEntry.queryArguments.ascending);
                        result.updatedTableViews.put(queryEntry.element, handoverTableViewPointer);
                        queryEntry.handoverQueryPointer = 0L;
                        break;
                    }
                    case 2: {
                        long handoverTableViewPointer = TableQuery.nativeFindAllMultiSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), queryEntry.handoverQueryPointer, 0L, -1L, -1L, queryEntry.queryArguments.columnIndices, queryEntry.queryArguments.ascendings);
                        result.updatedTableViews.put(queryEntry.element, handoverTableViewPointer);
                        queryEntry.handoverQueryPointer = 0L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Query mode " + queryEntry.queryArguments.type + " not supported");
                    }
                }
                continue;
            }
            for (Long handoverQueryPointer : result.updatedTableViews.values()) {
                if (handoverQueryPointer == 0L) continue;
                TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
            }
            return false;
        }
        return true;
    }

    private boolean updateRealmObjectQuery(SharedGroup sharedGroup, Result result) {
        block4: {
            block3: {
                if (this.isTaskCancelled()) break block3;
                switch (this.realmObjectEntry.queryArguments.type) {
                    case 3: {
                        long handoverRowPointer = TableQuery.nativeFindWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), this.realmObjectEntry.handoverQueryPointer, 0L);
                        result.updatedRow.put(this.realmObjectEntry.element, handoverRowPointer);
                        break block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Query mode " + this.realmObjectEntry.queryArguments.type + " not supported");
                    }
                }
            }
            TableQuery.nativeCloseQueryHandover(this.realmObjectEntry.handoverQueryPointer);
            return false;
        }
        return true;
    }

    private boolean isTaskCancelled() {
        return Thread.currentThread().isInterrupted();
    }

    private boolean isAliveHandler(Handler handler) {
        return handler != null && handler.getLooper().getThread().isAlive();
    }

    public static class Builder {

        private static class QueryEntry {
            final WeakReference element;
            long handoverQueryPointer;
            final ArgumentsHolder queryArguments;

            private QueryEntry(WeakReference element, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                this.element = element;
                this.handoverQueryPointer = handoverQueryPointer;
                this.queryArguments = queryArguments;
            }
        }

        private static class Steps
        implements RealmConfigurationStep,
        UpdateQueryStep,
        RealmResultsQueryStep,
        HandlerStep,
        BuilderStep {
            private RealmConfiguration realmConfiguration;
            private List<QueryEntry> realmResultsEntries;
            private QueryEntry realmObjectEntry;
            private WeakReference<Handler> callerHandler;
            private int message;

            private Steps() {
            }

            @Override
            public UpdateQueryStep realmConfiguration(RealmConfiguration realmConfiguration) {
                this.realmConfiguration = realmConfiguration;
                return this;
            }

            public RealmResultsQueryStep add(WeakReference<RealmResults<?>> weakReference, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                if (this.realmResultsEntries == null) {
                    this.realmResultsEntries = new ArrayList<QueryEntry>(1);
                }
                this.realmResultsEntries.add(new QueryEntry(weakReference, handoverQueryPointer, queryArguments));
                return this;
            }

            @Override
            public HandlerStep addObject(WeakReference<? extends RealmObject> weakReference, long handoverQueryPointer, ArgumentsHolder queryArguments) {
                this.realmObjectEntry = new QueryEntry(weakReference, handoverQueryPointer, queryArguments);
                return this;
            }

            @Override
            public BuilderStep sendToHandler(Handler handler, int message) {
                this.callerHandler = new WeakReference<Handler>(handler);
                this.message = message;
                return this;
            }

            @Override
            public QueryUpdateTask build() {
                return new QueryUpdateTask(this.realmResultsEntries != null ? 0 : 1, this.realmConfiguration, this.realmResultsEntries, this.realmObjectEntry, this.callerHandler, this.message);
            }
        }

        public static interface BuilderStep {
            public QueryUpdateTask build();
        }

        public static interface HandlerStep {
            public BuilderStep sendToHandler(Handler var1, int var2);
        }

        public static interface RealmResultsQueryStep {
            public RealmResultsQueryStep add(WeakReference<RealmResults<? extends RealmObject>> var1, long var2, ArgumentsHolder var4);

            public BuilderStep sendToHandler(Handler var1, int var2);
        }

        public static interface UpdateQueryStep {
            public RealmResultsQueryStep add(WeakReference<RealmResults<? extends RealmObject>> var1, long var2, ArgumentsHolder var4);

            public HandlerStep addObject(WeakReference<? extends RealmObject> var1, long var2, ArgumentsHolder var4);
        }

        public static interface RealmConfigurationStep {
            public UpdateQueryStep realmConfiguration(RealmConfiguration var1);
        }
    }

    public static class Result {
        public IdentityHashMap<WeakReference<RealmResults<? extends RealmObject>>, Long> updatedTableViews;
        public IdentityHashMap<WeakReference<? extends RealmObject>, Long> updatedRow;
        public SharedGroup.VersionID versionID;

        public static Result newRealmResultsResponse() {
            Result result = new Result();
            result.updatedTableViews = new IdentityHashMap(1);
            return result;
        }

        public static Result newRealmObjectResponse() {
            Result result = new Result();
            result.updatedRow = new IdentityHashMap(1);
            return result;
        }
    }
}

