/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.TableView;
import java.io.Closeable;
import java.util.Date;

public class TableQuery
implements Closeable {
    protected boolean DEBUG = false;
    protected long nativePtr;
    protected final Table table;
    private final TableOrView origin;
    private final Context context;
    private boolean queryValidated = true;
    private static final String DATE_NULL_ERROR_MESSAGE = "Date value in query criteria must not be null.";
    private static final String STRING_NULL_ERROR_MESSAGE = "String value in query criteria must not be null.";

    public TableQuery(Context context, Table table, long nativeQueryPtr) {
        if (this.DEBUG) {
            System.err.println("++++++ new TableQuery, ptr= " + nativeQueryPtr);
        }
        this.context = context;
        this.table = table;
        this.nativePtr = nativeQueryPtr;
        this.origin = null;
    }

    public TableQuery(Context context, Table table, long nativeQueryPtr, TableOrView origin) {
        if (this.DEBUG) {
            System.err.println("++++++ new TableQuery, ptr= " + nativeQueryPtr);
        }
        this.context = context;
        this.table = table;
        this.nativePtr = nativeQueryPtr;
        this.origin = origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                TableQuery.nativeClose(this.nativePtr);
                if (this.DEBUG) {
                    System.err.println("++++ Query CLOSE, ptr= " + this.nativePtr);
                }
                this.nativePtr = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeQuery(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    private void validateQuery() {
        if (!this.queryValidated) {
            String invalidMessage = this.nativeValidateQuery(this.nativePtr);
            if (invalidMessage.equals("")) {
                this.queryValidated = true;
            } else {
                throw new UnsupportedOperationException(invalidMessage);
            }
        }
    }

    public TableQuery tableview(TableView tv) {
        this.nativeTableview(this.nativePtr, tv.nativePtr);
        return this;
    }

    public TableQuery group() {
        this.nativeGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endGroup() {
        this.nativeEndGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery subtable(long columnIndex) {
        this.nativeSubtable(this.nativePtr, columnIndex);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endSubtable() {
        this.nativeParent(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery or() {
        this.nativeOr(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery not() {
        this.nativeNot(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, long value) {
        this.nativeEqual(this.nativePtr, columnIndexes, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, long value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, long value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, long value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, long value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, long value1, long value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, float value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, float value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, float value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, float value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, float value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, float value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, float value1, float value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, double value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, double value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, double value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, double value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, double value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, double value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, double value1, double value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, boolean value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, Date value) {
        if (value == null) {
            this.nativeIsNull(this.nativePtr, columnIndex);
        } else {
            this.nativeEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        }
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, Date value1, Date value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Date values in query criteria must not be null.");
        }
        this.nativeBetweenDateTime(this.nativePtr, columnIndex, value1.getTime() / 1000L, value2.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, String value, boolean caseSensitive) {
        this.nativeEqual(this.nativePtr, columnIndexes, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, String value) {
        this.nativeEqual(this.nativePtr, columnIndexes, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, String value, boolean caseSensitive) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, String value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnIndices, String value, boolean caseSensitive) {
        this.nativeBeginsWith(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnIndices, String value) {
        this.nativeBeginsWith(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnIndices, String value, boolean caseSensitive) {
        this.nativeEndsWith(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnIndices, String value) {
        this.nativeEndsWith(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnIndices, String value, boolean caseSensitive) {
        this.nativeContains(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnIndices, String value) {
        this.nativeContains(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isEmpty(long[] columnIndices) {
        this.nativeIsEmpty(this.nativePtr, columnIndices);
        this.queryValidated = false;
        return this;
    }

    public long find(long fromTableRow) {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, fromTableRow);
    }

    public long find() {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, 0L);
    }

    public long findWithHandover(long bgSharedGroupPtr, long nativeReplicationPtr, long ptrQuery) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        return TableQuery.nativeFindWithHandover(bgSharedGroupPtr, nativeReplicationPtr, ptrQuery, 0L);
    }

    public TableView findAll(long start, long end, long limit) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAll(this.nativePtr, start, end, limit);
        try {
            return new TableView(this.context, this.table, nativeViewPtr, this);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public TableView findAll() {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAll(this.nativePtr, 0L, -1L, -1L);
        try {
            return new TableView(this.context, this.table, nativeViewPtr, this);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public long findAllWithHandover(long bgSharedGroupPtr, long nativeReplicationPtr, long ptrQuery) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        return TableQuery.nativeFindAllWithHandover(bgSharedGroupPtr, nativeReplicationPtr, ptrQuery, 0L, -1L, -1L);
    }

    public long findDistinctWithHandover(long bgSharedGroupPtr, long nativeReplicationPtr, long ptrQuery, long columnIndex) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        return TableQuery.nativeGetDistinctViewWithHandover(bgSharedGroupPtr, nativeReplicationPtr, ptrQuery, columnIndex);
    }

    public long findAllSortedWithHandover(long bgSharedGroupPtr, long nativeReplicationPtr, long ptrQuery, long columnIndex, boolean ascending) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        return TableQuery.nativeFindAllSortedWithHandover(bgSharedGroupPtr, nativeReplicationPtr, ptrQuery, 0L, -1L, -1L, columnIndex, ascending);
    }

    public long findAllMultiSortedWithHandover(long bgSharedGroupPtr, long nativeReplicationPtr, long ptrQuery, long[] columnIndices, boolean[] ascending) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        return TableQuery.nativeFindAllMultiSortedWithHandover(bgSharedGroupPtr, nativeReplicationPtr, ptrQuery, 0L, -1L, -1L, columnIndices, ascending);
    }

    public TableView importHandoverTableView(long handoverPtr, long callerSharedGroupPtr) {
        long nativeTvPtr = 0L;
        try {
            nativeTvPtr = this.nativeImportHandoverTableViewIntoSharedGroup(handoverPtr, callerSharedGroupPtr);
            return new TableView(this.context, this.table, nativeTvPtr);
        }
        catch (RuntimeException e) {
            if (nativeTvPtr != 0L) {
                TableView.nativeClose(nativeTvPtr);
            }
            throw e;
        }
    }

    public long handoverQuery(long callerSharedGroupPtr) {
        return this.nativeHandoverQuery(callerSharedGroupPtr, this.nativePtr);
    }

    public long sumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public long sumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Long maximumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public Long maximumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Long minimumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public Long minimumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageInt(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double sumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Float maximumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public Float maximumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Float minimumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public Float minimumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double sumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Double maximumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public Double maximumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Double minimumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public Double minimumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Date maximumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        Long result = this.nativeMaximumDate(this.nativePtr, columnIndex, start, end, limit);
        if (result != null) {
            return new Date(result * 1000L);
        }
        return null;
    }

    public Date maximumDate(long columnIndex) {
        this.validateQuery();
        Long result = this.nativeMaximumDate(this.nativePtr, columnIndex, 0L, -1L, -1L);
        if (result != null) {
            return new Date(result * 1000L);
        }
        return null;
    }

    public Date minimumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        Long result = this.nativeMinimumDate(this.nativePtr, columnIndex, start, end, limit);
        if (result != null) {
            return new Date(result * 1000L);
        }
        return null;
    }

    public Date minimumDate(long columnIndex) {
        this.validateQuery();
        Long result = this.nativeMinimumDate(this.nativePtr, columnIndex, 0L, -1L, -1L);
        if (result != null) {
            return new Date(result * 1000L);
        }
        return null;
    }

    public TableQuery isNull(long[] columnIndices) {
        this.nativeIsNull(this.nativePtr, columnIndices);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotNull(long[] columnIndices) {
        this.nativeIsNotNull(this.nativePtr, columnIndices);
        this.queryValidated = false;
        return this;
    }

    public long count(long start, long end, long limit) {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, start, end, limit);
    }

    public long count() {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, 0L, -1L, -1L);
    }

    public long remove(long start, long end) {
        this.validateQuery();
        if (this.table.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr, start, end, -1L);
    }

    public long remove() {
        this.validateQuery();
        if (this.table.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr, 0L, -1L, -1L);
    }

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }

    protected static native void nativeClose(long var0);

    private native String nativeValidateQuery(long var1);

    private native void nativeTableview(long var1, long var3);

    private native void nativeGroup(long var1);

    private native void nativeEndGroup(long var1);

    private native void nativeSubtable(long var1, long var3);

    private native void nativeParent(long var1);

    private native void nativeOr(long var1);

    private native void nativeNot(long var1);

    private native void nativeEqual(long var1, long[] var3, long var4);

    private native void nativeNotEqual(long var1, long[] var3, long var4);

    private native void nativeGreater(long var1, long[] var3, long var4);

    private native void nativeGreaterEqual(long var1, long[] var3, long var4);

    private native void nativeLess(long var1, long[] var3, long var4);

    private native void nativeLessEqual(long var1, long[] var3, long var4);

    private native void nativeBetween(long var1, long[] var3, long var4, long var6);

    private native void nativeEqual(long var1, long[] var3, float var4);

    private native void nativeNotEqual(long var1, long[] var3, float var4);

    private native void nativeGreater(long var1, long[] var3, float var4);

    private native void nativeGreaterEqual(long var1, long[] var3, float var4);

    private native void nativeLess(long var1, long[] var3, float var4);

    private native void nativeLessEqual(long var1, long[] var3, float var4);

    private native void nativeBetween(long var1, long[] var3, float var4, float var5);

    private native void nativeEqual(long var1, long[] var3, double var4);

    private native void nativeNotEqual(long var1, long[] var3, double var4);

    private native void nativeGreater(long var1, long[] var3, double var4);

    private native void nativeGreaterEqual(long var1, long[] var3, double var4);

    private native void nativeLess(long var1, long[] var3, double var4);

    private native void nativeLessEqual(long var1, long[] var3, double var4);

    private native void nativeBetween(long var1, long[] var3, double var4, double var6);

    private native void nativeEqual(long var1, long[] var3, boolean var4);

    private native void nativeEqualDateTime(long var1, long[] var3, long var4);

    private native void nativeNotEqualDateTime(long var1, long[] var3, long var4);

    private native void nativeGreaterDateTime(long var1, long[] var3, long var4);

    private native void nativeGreaterEqualDateTime(long var1, long[] var3, long var4);

    private native void nativeLessDateTime(long var1, long[] var3, long var4);

    private native void nativeLessEqualDateTime(long var1, long[] var3, long var4);

    private native void nativeBetweenDateTime(long var1, long[] var3, long var4, long var6);

    private native void nativeEqual(long var1, long[] var3, String var4, boolean var5);

    private native void nativeNotEqual(long var1, long[] var3, String var4, boolean var5);

    private native void nativeBeginsWith(long var1, long[] var3, String var4, boolean var5);

    private native void nativeEndsWith(long var1, long[] var3, String var4, boolean var5);

    private native void nativeContains(long var1, long[] var3, String var4, boolean var5);

    private native void nativeIsEmpty(long var1, long[] var3);

    private native long nativeFind(long var1, long var3);

    private native long nativeFindAll(long var1, long var3, long var5, long var7);

    private native long nativeSumInt(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMaximumInt(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMinimumInt(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageInt(long var1, long var3, long var5, long var7, long var9);

    private native double nativeSumFloat(long var1, long var3, long var5, long var7, long var9);

    private native Float nativeMaximumFloat(long var1, long var3, long var5, long var7, long var9);

    private native Float nativeMinimumFloat(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageFloat(long var1, long var3, long var5, long var7, long var9);

    private native double nativeSumDouble(long var1, long var3, long var5, long var7, long var9);

    private native Double nativeMaximumDouble(long var1, long var3, long var5, long var7, long var9);

    private native Double nativeMinimumDouble(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageDouble(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMaximumDate(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMinimumDate(long var1, long var3, long var5, long var7, long var9);

    private native void nativeIsNull(long var1, long[] var3);

    private native void nativeIsNotNull(long var1, long[] var3);

    private native long nativeCount(long var1, long var3, long var5, long var7);

    private native long nativeRemove(long var1, long var3, long var5, long var7);

    private native long nativeImportHandoverTableViewIntoSharedGroup(long var1, long var3);

    private native long nativeHandoverQuery(long var1, long var3);

    public static native long nativeFindAllSortedWithHandover(long var0, long var2, long var4, long var6, long var8, long var10, long var12, boolean var14);

    public static native long nativeFindAllWithHandover(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native long nativeGetDistinctViewWithHandover(long var0, long var2, long var4, long var6);

    public static native long nativeFindWithHandover(long var0, long var2, long var4, long var6);

    public static native long nativeFindAllMultiSortedWithHandover(long var0, long var2, long var4, long var6, long var8, long var10, long[] var12, boolean[] var13);

    public static native long nativeImportHandoverRowIntoSharedGroup(long var0, long var2);

    public static native void nativeCloseQueryHandover(long var0);
}

