/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmConfiguration;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class SharedGroupManager
implements Closeable {
    private SharedGroup sharedGroup;
    private ImplicitTransaction transaction;

    public SharedGroupManager(RealmConfiguration configuration) {
        this.sharedGroup = new SharedGroup(configuration.getPath(), true, configuration.getDurability(), configuration.getEncryptionKey());
        this.transaction = this.sharedGroup.beginImplicitTransaction();
    }

    @Override
    public void close() {
        this.sharedGroup.close();
        this.sharedGroup = null;
        this.transaction = null;
    }

    public boolean isOpen() {
        return this.sharedGroup != null;
    }

    public void advanceRead() {
        this.transaction.advanceRead();
    }

    public void advanceRead(SharedGroup.VersionID version) {
        this.transaction.advanceRead(version);
    }

    public Table getTable(String tableName) {
        return this.transaction.getTable(tableName);
    }

    public boolean hasChanged() {
        return this.sharedGroup.hasChanged();
    }

    public SharedGroup.VersionID getVersion() {
        return this.sharedGroup.getVersion();
    }

    public void promoteToWrite() {
        this.transaction.promoteToWrite();
    }

    public void commitAndContinueAsRead() {
        this.transaction.commitAndContinueAsRead();
    }

    public void rollbackAndContinueAsRead() {
        this.transaction.rollbackAndContinueAsRead();
    }

    public boolean hasTable(String tableName) {
        return this.transaction.hasTable(tableName);
    }

    public void copyToFile(File destination, byte[] key) throws IOException {
        this.transaction.writeToFile(destination, key);
    }

    public SharedGroup getSharedGroup() {
        return this.sharedGroup;
    }

    public ImplicitTransaction getTransaction() {
        return this.transaction;
    }

    public boolean isImmutable() {
        return this.transaction.immutable;
    }

    public static boolean compact(RealmConfiguration configuration) {
        SharedGroup sharedGroup = null;
        boolean result = false;
        try {
            sharedGroup = new SharedGroup(configuration.getPath(), false, SharedGroup.Durability.FULL, configuration.getEncryptionKey());
            result = sharedGroup.compact();
        }
        finally {
            if (sharedGroup != null) {
                sharedGroup.close();
            }
        }
        return result;
    }

    public long getNativePointer() {
        return this.sharedGroup.getNativePointer();
    }
}

