/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.OutOfMemoryError;
import io.realm.internal.RealmCore;
import io.realm.internal.Table;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Group
implements Closeable {
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    public static final int MODE_READWRITE_NOCREATE = 2;
    protected long nativePtr;
    protected boolean immutable;
    private final Context context;

    private void checkNativePtrNotZero() {
        if (this.nativePtr == 0L) {
            throw new OutOfMemoryError("Out of native memory.");
        }
    }

    public Group() {
        this.immutable = false;
        this.context = new Context();
        this.nativePtr = this.createNative();
        this.checkNativePtrNotZero();
    }

    public Group(String filepath, int mode) {
        this.immutable = mode == 0;
        this.context = new Context();
        this.nativePtr = this.createNative(filepath, mode);
        this.checkNativePtrNotZero();
    }

    public Group(String filepath) {
        this(filepath, 0);
    }

    public Group(File file) {
        this(file.getAbsolutePath(), file.canWrite() ? 1 : 0);
    }

    public Group(byte[] data) {
        this.immutable = false;
        this.context = new Context();
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.nativePtr = this.createNative(data);
        this.checkNativePtrNotZero();
    }

    public Group(ByteBuffer buffer) {
        this.immutable = false;
        this.context = new Context();
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.nativePtr = this.createNative(buffer);
        this.checkNativePtrNotZero();
    }

    Group(Context context, long nativePointer, boolean immutable) {
        this.context = context;
        this.nativePtr = nativePointer;
        this.immutable = immutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                Group.nativeClose(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    boolean isClosed() {
        return this.nativePtr == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeGroup(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    private void verifyGroupIsValid() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Illegal to call methods on a closed Group.");
        }
    }

    public long size() {
        this.verifyGroupIsValid();
        return this.nativeSize(this.nativePtr);
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean hasTable(String name) {
        this.verifyGroupIsValid();
        return name != null && this.nativeHasTable(this.nativePtr, name);
    }

    public String getTableName(int index) {
        this.verifyGroupIsValid();
        long cnt = this.size();
        if (index < 0 || (long)index >= cnt) {
            throw new IndexOutOfBoundsException("Table index argument is out of range. possible range is [0, " + (cnt - 1L) + "]");
        }
        return this.nativeGetTableName(this.nativePtr, index);
    }

    public Table getTable(String name) {
        this.verifyGroupIsValid();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name. Name must be a non-empty String.");
        }
        if (this.immutable && !this.hasTable(name)) {
            throw new IllegalStateException("Requested table is not in this Realm. Creating it requires a transaction: " + name);
        }
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetTableNativePtr(this.nativePtr, name);
        try {
            return new Table(this.context, this, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    public void writeToFile(File file, byte[] key) throws IOException {
        this.verifyGroupIsValid();
        if (file.isFile() && file.exists()) {
            throw new IllegalArgumentException("The destination file must not exist");
        }
        if (key != null && key.length != 64) {
            throw new IllegalArgumentException("Realm AES keys must be 64 bytes long");
        }
        this.nativeWriteToFile(this.nativePtr, file.getAbsolutePath(), key);
    }

    public byte[] writeToMem() {
        this.verifyGroupIsValid();
        return this.nativeWriteToMem(this.nativePtr);
    }

    public void commit() {
        this.verifyGroupIsValid();
        this.nativeCommit(this.nativePtr);
    }

    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    public String toString() {
        return this.nativeToString(this.nativePtr);
    }

    private void throwImmutable() {
        throw new IllegalStateException("Objects cannot be changed outside a transaction; see beginTransaction() for details.");
    }

    protected native long createNative();

    protected native long createNative(String var1, int var2);

    protected native long createNative(byte[] var1);

    protected native long createNative(ByteBuffer var1);

    protected static native void nativeClose(long var0);

    protected native long nativeSize(long var1);

    protected native String nativeGetTableName(long var1, int var3);

    protected native boolean nativeHasTable(long var1, String var3);

    protected native void nativeWriteToFile(long var1, String var3, byte[] var4) throws IOException;

    protected native long nativeGetTableNativePtr(long var1, String var3);

    protected native long nativeLoadFromMem(byte[] var1);

    protected native byte[] nativeWriteToMem(long var1);

    protected native String nativeToJson(long var1);

    protected native void nativeCommit(long var1);

    protected native String nativeToString(long var1);

    static {
        RealmCore.loadLibrary();
    }
}

