/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.internal.ColumnType;
import io.realm.internal.LinkView;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import io.realm.internal.async.ArgumentsHolder;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.internal.log.RealmLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class RealmQuery<E extends RealmObject> {
    private final Realm realm;
    private final Table table;
    private final LinkView view;
    private final TableQuery query;
    private final Map<String, Long> columns;
    private final Class<E> clazz;
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    private static final Long INVALID_NATIVE_POINTER = 0L;
    private ArgumentsHolder argumentsHolder;

    public RealmQuery(Realm realm, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.table = realm.getTable(clazz);
        this.view = null;
        this.query = this.table.where();
        this.columns = realm.columnIndices.getColumnInfo(clazz).getIndicesMap();
    }

    public RealmQuery(RealmResults realmResults, Class<E> clazz) {
        this.realm = realmResults.getRealm();
        this.clazz = clazz;
        this.table = this.realm.getTable(clazz);
        this.view = null;
        this.query = realmResults.getTable().where();
        this.columns = this.realm.columnIndices.getColumnInfo(clazz).getIndicesMap();
    }

    RealmQuery(Realm realm, LinkView view, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.query = view.where();
        this.view = view;
        this.table = realm.getTable(clazz);
        this.columns = realm.columnIndices.getColumnInfo(clazz).getIndicesMap();
    }

    private boolean containsDot(String s) {
        return s.indexOf(46) != -1;
    }

    private String[] splitString(String s) {
        int i;
        int n = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++n;
        }
        String[] arr = new String[n + 1];
        i = 0;
        n = 0;
        int j = s.indexOf(46);
        while (j != -1) {
            arr[n] = s.substring(i, j);
            i = j + 1;
            j = s.indexOf(46, i);
            ++n;
        }
        arr[n] = s.substring(s.lastIndexOf(46) + 1);
        return arr;
    }

    private long[] getColumnIndices(String fieldDescription, ColumnType ... validColumnTypes) {
        boolean checkColumnType;
        if (fieldDescription == null || fieldDescription.equals("")) {
            throw new IllegalArgumentException("Non-empty fieldname must be provided");
        }
        Table table = this.table;
        boolean bl = checkColumnType = validColumnTypes != null && validColumnTypes.length > 0;
        if (this.containsDot(fieldDescription)) {
            long columnIndex;
            String[] names = this.splitString(fieldDescription);
            long[] columnIndices = new long[names.length];
            for (int i = 0; i < names.length - 1; ++i) {
                long index = table.getColumnIndex(names[i]);
                if (index < 0L) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                ColumnType type = table.getColumnType(index);
                if (type != ColumnType.LINK && type != ColumnType.LINK_LIST) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                table = table.getLinkTarget(index);
                columnIndices[i] = index;
            }
            String columnName = names[names.length - 1];
            columnIndices[names.length - 1] = columnIndex = table.getColumnIndex(columnName);
            if (columnIndex < 0L) {
                throw new IllegalArgumentException(columnName + " is not a field name in class " + table.getName());
            }
            if (checkColumnType && !this.isValidType(table.getColumnType(columnIndex), validColumnTypes)) {
                throw new IllegalArgumentException(String.format("Field '%s': type mismatch.", names[names.length - 1]));
            }
            return columnIndices;
        }
        if (this.columns.get(fieldDescription) == null) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist.", fieldDescription));
        }
        ColumnType tableColumnType = table.getColumnType(this.columns.get(fieldDescription));
        if (checkColumnType && !this.isValidType(tableColumnType, validColumnTypes)) {
            throw new IllegalArgumentException(String.format("Field '%s': type mismatch. Was %s, expected %s.", new Object[]{fieldDescription, tableColumnType, Arrays.toString((Object[])validColumnTypes)}));
        }
        return new long[]{this.columns.get(fieldDescription)};
    }

    private boolean isValidType(ColumnType columnType, ColumnType[] validColumnTypes) {
        for (int i = 0; i < validColumnTypes.length; ++i) {
            if (validColumnTypes[i] != columnType) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.realm == null || this.realm.isClosed()) {
            return false;
        }
        if (this.view != null) {
            return this.view.isAttached();
        }
        return this.table != null && this.table.isValid();
    }

    public RealmQuery<E> isNull(String fieldName) {
        long[] columnIndices = this.getColumnIndices(fieldName, new ColumnType[0]);
        this.query.isNull(columnIndices);
        return this;
    }

    public RealmQuery<E> isNotNull(String fieldName) {
        long[] columnIndices = this.getColumnIndices(fieldName, new ColumnType[0]);
        this.query.isNotNull(columnIndices);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, String value) {
        return this.equalTo(fieldName, value, true);
    }

    public RealmQuery<E> equalTo(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.equalTo(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Byte value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Short value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Integer value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.intValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Boolean value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.BOOLEAN);
        if (value == null) {
            this.query.isNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value) {
        return this.notEqualTo(fieldName, value, true);
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        if (columnIndices.length > 1 && !caseSensitive) {
            throw new IllegalArgumentException("Link queries cannot be case insensitive - coming soon.");
        }
        this.query.notEqualTo(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Byte value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Short value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Integer value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.intValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Boolean value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.BOOLEAN);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.equalTo(columnIndices, value == false);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        if (value == null) {
            this.query.isNotNull(columnIndices);
        } else {
            this.query.notEqualTo(columnIndices, value);
        }
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> between(String fieldName, int from, int to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, long from, long to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, double from, double to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, float from, float to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, Date from, Date to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> contains(String fieldName, String value) {
        return this.contains(fieldName, value, true);
    }

    public RealmQuery<E> contains(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.contains(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, String value) {
        return this.beginsWith(fieldName, value, true);
    }

    public RealmQuery<E> beginsWith(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.beginsWith(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, true);
    }

    public RealmQuery<E> endsWith(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.endsWith(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> beginGroup() {
        this.query.group();
        return this;
    }

    public RealmQuery<E> endGroup() {
        this.query.endGroup();
        return this;
    }

    public RealmQuery<E> or() {
        this.query.or();
        return this;
    }

    public RealmQuery<E> not() {
        this.query.not();
        return this;
    }

    public RealmQuery<E> isEmpty(String fieldName) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING, ColumnType.BINARY, ColumnType.LINK_LIST);
        this.query.isEmpty(columnIndices);
        return this;
    }

    public Number sum(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.sumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.sumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.sumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public long sumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumInt(columnIndex);
    }

    public double sumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumDouble(columnIndex);
    }

    public double sumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumFloat(columnIndex);
    }

    public double average(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.averageInt(columnIndex);
            }
            case DOUBLE: {
                return this.query.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.query.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public double averageInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageInt(columnIndex);
    }

    public double averageDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageDouble(columnIndex);
    }

    public double averageFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageFloat(columnIndex);
    }

    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.minimumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.minimumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.minimumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public long minimumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumInt(columnIndex);
    }

    public double minimumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumDouble(columnIndex);
    }

    public float minimumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumFloat(columnIndex).floatValue();
    }

    public Date minimumDate(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumDate(columnIndex);
    }

    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.maximumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.maximumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.maximumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public long maximumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumInt(columnIndex);
    }

    public double maximumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumDouble(columnIndex);
    }

    public float maximumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumFloat(columnIndex).floatValue();
    }

    public Date maximumDate(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumDate(columnIndex);
    }

    public long count() {
        return this.query.count();
    }

    RealmResults<E> distinctAsync(final long columnIndex) {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(4);
        this.argumentsHolder.columnIndex = columnIndex;
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<E> realmResults = new RealmResults<E>(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.realm.getReferenceQueue());
        this.realm.addAsyncRealmResults(weakRealmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findDistinctWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, columnIndex);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.sendMessageToHandler(weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage());
                        RealmQuery.this.sendMessageToHandler(weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (null != sharedGroup) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAll() {
        this.checkQueryIsNotReused();
        return new RealmResults<E>(this.realm, this.query.findAll(), this.clazz);
    }

    public RealmResults<E> findAllAsync() {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(0);
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<E> realmResults = new RealmResults<E>(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.realm.getReferenceQueue());
        this.realm.addAsyncRealmResults(weakRealmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.sendMessageToHandler(weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage());
                        RealmQuery.this.sendMessageToHandler(weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (null != sharedGroup) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName, boolean sortAscending) {
        this.checkQueryIsNotReused();
        TableView tableView = this.query.findAll();
        TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        Long columnIndex = this.columns.get(fieldName);
        if (columnIndex == null || columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        tableView.sort(columnIndex, order);
        return new RealmResults<E>(this.realm, tableView, this.clazz);
    }

    public RealmResults<E> findAllSortedAsync(String fieldName, boolean sortAscending) {
        this.checkQueryIsNotReused();
        final TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        final Long columnIndex = this.columns.get(fieldName);
        if (columnIndex == null || columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        this.argumentsHolder = new ArgumentsHolder(1);
        this.argumentsHolder.ascending = sortAscending;
        this.argumentsHolder.columnIndex = columnIndex;
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        RealmResults<E> realmResults = new RealmResults<E>(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.realm.getReferenceQueue());
        this.realm.addAsyncRealmResults(weakRealmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, columnIndex, order == TableView.Order.ascending);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.sendMessageToHandler(weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage());
                        RealmQuery.this.sendMessageToHandler(weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName) {
        return this.findAllSorted(fieldName, true);
    }

    public RealmResults<E> findAllSortedAsync(String fieldName) {
        return this.findAllSortedAsync(fieldName, true);
    }

    public RealmResults<E> findAllSorted(String[] fieldNames, boolean[] sortAscending) {
        int i;
        this.checkSortParameters(fieldNames, sortAscending);
        if (fieldNames.length == 1 && sortAscending.length == 1) {
            return this.findAllSorted(fieldNames[0], sortAscending[0]);
        }
        TableView tableView = this.query.findAll();
        ArrayList<Long> columnIndices = new ArrayList<Long>();
        ArrayList<TableView.Order> orders = new ArrayList<TableView.Order>();
        for (i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Long columnIndex = this.columns.get(fieldName);
            if (columnIndex == null || columnIndex < 0L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices.add(columnIndex);
        }
        for (i = 0; i < sortAscending.length; ++i) {
            orders.add(sortAscending[i] ? TableView.Order.ascending : TableView.Order.descending);
        }
        tableView.sort(columnIndices, orders);
        return new RealmResults<E>(this.realm, tableView, this.clazz);
    }

    public RealmResults<E> findAllSortedAsync(String[] fieldNames, final boolean[] sortAscending) {
        this.checkQueryIsNotReused();
        this.checkSortParameters(fieldNames, sortAscending);
        if (fieldNames.length == 1 && sortAscending.length == 1) {
            return this.findAllSortedAsync(fieldNames[0], sortAscending[0]);
        }
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        final long[] indices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Long columnIndex = this.columns.get(fieldName);
            if (columnIndex == null || columnIndex < 0L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            indices[i] = columnIndex;
        }
        this.argumentsHolder = new ArgumentsHolder(2);
        this.argumentsHolder.ascendings = sortAscending;
        this.argumentsHolder.columnIndices = indices;
        RealmResults<E> realmResults = new RealmResults<E>(this.realm, this.query, this.clazz);
        final WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = new WeakReference<RealmResults<? extends RealmObject>>(realmResults, this.realm.getReferenceQueue());
        this.realm.addAsyncRealmResults(weakRealmResults, this);
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findAllMultiSortedWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer, indices, sortAscending);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmResultsResponse();
                        result.updatedTableViews.put(weakRealmResults, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.sendMessageToHandler(weakHandler, 39088169, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage());
                        RealmQuery.this.sendMessageToHandler(weakHandler, 102334155, new Error(e));
                    }
                    finally {
                        if (sharedGroup != null) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        realmResults.setPendingQuery(pendingQuery);
        return realmResults;
    }

    public RealmResults<E> findAllSorted(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public RealmResults<E> findAllSortedAsync(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.findAllSortedAsync(new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public RealmResults<E> findAllSorted(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public RealmResults<E> findAllSortedAsync(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.findAllSortedAsync(new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public E findFirst() {
        this.checkQueryIsNotReused();
        long rowIndex = this.query.find();
        if (rowIndex >= 0L) {
            return this.realm.get(this.clazz, this.view != null ? this.view.getTargetRowIndex(rowIndex) : rowIndex);
        }
        return null;
    }

    public E findFirstAsync() {
        this.checkQueryIsNotReused();
        final WeakReference<Handler> weakHandler = this.getWeakReferenceHandler();
        final long handoverQueryPointer = this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
        this.argumentsHolder = new ArgumentsHolder(3);
        final RealmConfiguration realmConfiguration = this.realm.getConfiguration();
        E result = this.realm.getConfiguration().getSchemaMediator().newInstance(this.clazz, this.realm.getColumnInfo(this.clazz));
        final WeakReference<RealmObject> realmObjectWeakReference = new WeakReference<RealmObject>((RealmObject)result);
        this.realm.addAsyncRealmObject(realmObjectWeakReference, this);
        ((RealmObject)result).realm = this.realm;
        ((RealmObject)result).row = Row.EMPTY_ROW;
        Future<Long> pendingQuery = Realm.asyncQueryExecutor.submit(new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                if (!Thread.currentThread().isInterrupted()) {
                    SharedGroup sharedGroup = null;
                    try {
                        sharedGroup = new SharedGroup(realmConfiguration.getPath(), true, realmConfiguration.getDurability(), realmConfiguration.getEncryptionKey());
                        long handoverTableViewPointer = RealmQuery.this.query.findWithHandover(sharedGroup.getNativePointer(), sharedGroup.getNativeReplicationPointer(), handoverQueryPointer);
                        QueryUpdateTask.Result result = QueryUpdateTask.Result.newRealmObjectResponse();
                        result.updatedRow.put(realmObjectWeakReference, handoverTableViewPointer);
                        result.versionID = sharedGroup.getVersion();
                        RealmQuery.this.sendMessageToHandler(weakHandler, 63245986, result);
                        Long l = handoverTableViewPointer;
                        return l;
                    }
                    catch (Exception e) {
                        RealmLog.e(e.getMessage());
                        RealmQuery.this.sendMessageToHandler(weakHandler, 63245986, new Error(e));
                    }
                    finally {
                        if (null != sharedGroup) {
                            sharedGroup.close();
                        }
                    }
                } else {
                    TableQuery.nativeCloseQueryHandover(handoverQueryPointer);
                }
                return INVALID_NATIVE_POINTER;
            }
        });
        ((RealmObject)result).setPendingQuery(pendingQuery);
        return result;
    }

    private void checkSortParameters(String[] fieldNames, boolean[] sortAscendings) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames cannot be 'null'.");
        }
        if (sortAscendings == null) {
            throw new IllegalArgumentException("sortAscending cannot be 'null'.");
        }
        if (fieldNames.length == 0) {
            throw new IllegalArgumentException("At least one field name must be specified.");
        }
        if (fieldNames.length != sortAscendings.length) {
            throw new IllegalArgumentException(String.format("Number of field names (%d) and sort orders (%d) does not match.", fieldNames.length, sortAscendings.length));
        }
    }

    private WeakReference<Handler> getWeakReferenceHandler() {
        if (this.realm.handler == null) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper. Async queries need a Handler to send results of your query");
        }
        return new WeakReference<Handler>(this.realm.handler);
    }

    private void sendMessageToHandler(WeakReference<Handler> weakHandler, int what, Object obj) {
        Handler handler = (Handler)weakHandler.get();
        if (handler != null && handler.getLooper().getThread().isAlive()) {
            handler.obtainMessage(what, obj).sendToTarget();
        }
    }

    private void checkQueryIsNotReused() {
        if (this.argumentsHolder != null) {
            throw new IllegalStateException("This RealmQuery is already used by a find* query, please create a new query");
        }
    }

    public ArgumentsHolder getArgument() {
        return this.argumentsHolder;
    }

    long handoverQueryPointer() {
        return this.query.handoverQuery(this.realm.sharedGroupManager.getNativePointer());
    }
}

