/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.annotations.RealmClass;
import io.realm.internal.InvalidRow;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.log.RealmLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

@RealmClass
public abstract class RealmObject {
    protected Row row;
    protected Realm realm;
    private final List<RealmChangeListener> listeners = new CopyOnWriteArrayList<RealmChangeListener>();
    private Future<Long> pendingQuery;
    private boolean isCompleted = false;

    public void removeFromRealm() {
        if (this.row == null) {
            throw new IllegalStateException("Object malformed: missing object in Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        if (this.realm == null) {
            throw new IllegalStateException("Object malformed: missing Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        this.realm.checkIfValid();
        this.row.getTable().moveLastOver(this.row.getIndex());
        this.row = InvalidRow.INSTANCE;
    }

    public final boolean isValid() {
        return this.row != null && this.row.isAttached();
    }

    protected static Realm getRealm(RealmObject obj) {
        return obj.realm;
    }

    protected static Row getRow(RealmObject obj) {
        return obj.row;
    }

    void setPendingQuery(Future<Long> pendingQuery) {
        this.pendingQuery = pendingQuery;
        if (this.isLoaded()) {
            this.onCompleted();
        }
    }

    public final boolean isLoaded() {
        if (this.realm == null) {
            return true;
        }
        this.realm.checkIfValid();
        return this.pendingQuery == null || this.isCompleted;
    }

    public final boolean load() {
        if (this.isLoaded()) {
            return true;
        }
        return this.onCompleted();
    }

    boolean onCompleted() {
        try {
            Long handoverResult = this.pendingQuery.get();
            this.onCompleted(handoverResult);
        }
        catch (Exception e) {
            RealmLog.d(e.getMessage());
            return false;
        }
        return true;
    }

    void onCompleted(Long handoverRowPointer) {
        if (!this.isCompleted) {
            this.isCompleted = true;
            long nativeRowPointer = TableQuery.nativeImportHandoverRowIntoSharedGroup(handoverRowPointer, this.realm.sharedGroupManager.getNativePointer());
            Table table = this.realm.getTable(this.getClass());
            this.row = table.getUncheckedRowByPointer(nativeRowPointer);
            this.notifyChangeListeners();
        }
    }

    public final void addChangeListener(RealmChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot add listener from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeChangeListener(RealmChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot remove listener from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        this.listeners.remove(listener);
    }

    public final void removeChangeListeners() {
        if (this.realm == null) {
            throw new IllegalArgumentException("Cannot remove listeners from this unmanaged RealmObject (created outside of Realm)");
        }
        this.realm.checkIfValid();
        this.listeners.clear();
    }

    void notifyChangeListeners() {
        this.realm.checkIfValid();
        for (RealmChangeListener listener : this.listeners) {
            listener.onChange();
        }
    }
}

