/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.JsonReader;
import io.realm.BaseRealm;
import io.realm.RealmAsyncTask;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import io.realm.internal.log.RealmLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Realm
extends BaseRealm {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    protected static final ThreadLocal<Map<RealmConfiguration, Realm>> realmsCache = new ThreadLocal<Map<RealmConfiguration, Realm>>(){

        @Override
        protected Map<RealmConfiguration, Realm> initialValue() {
            return new HashMap<RealmConfiguration, Realm>();
        }
    };
    private static final ThreadLocal<Map<RealmConfiguration, Integer>> referenceCount = new ThreadLocal<Map<RealmConfiguration, Integer>>(){

        @Override
        protected Map<RealmConfiguration, Integer> initialValue() {
            return new HashMap<RealmConfiguration, Integer>();
        }
    };
    static final Map<String, ColumnIndices> validatedRealmFiles = new HashMap<String, ColumnIndices>();
    private final Map<Class<? extends RealmObject>, Table> classToTable = new HashMap<Class<? extends RealmObject>, Table>();
    private static RealmConfiguration defaultConfiguration;
    protected ColumnIndices columnIndices;

    private Realm(RealmConfiguration configuration, boolean autoRefresh) {
        super(configuration, autoRefresh);
    }

    protected void finalize() throws Throwable {
        if (this.sharedGroupManager != null && this.sharedGroupManager.isOpen()) {
            RealmLog.w("Remember to call close() on all Realm instances. Realm " + this.configuration.getPath() + " is being finalized without being closed, " + "this can lead to running out of native memory.");
        }
        super.finalize();
    }

    public static Realm getInstance(Context context) {
        return Realm.getInstance(new RealmConfiguration.Builder(context).name(DEFAULT_REALM_NAME).build());
    }

    public static Realm getDefaultInstance() {
        if (defaultConfiguration == null) {
            throw new NullPointerException("No default RealmConfiguration was found. Call setDefaultConfiguration() first");
        }
        return Realm.create(defaultConfiguration);
    }

    public static Realm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return Realm.create(configuration);
    }

    public static void setDefaultConfiguration(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        defaultConfiguration = configuration;
    }

    public static void removeDefaultConfiguration() {
        defaultConfiguration = null;
    }

    private static synchronized Realm create(RealmConfiguration configuration) {
        boolean autoRefresh = Looper.myLooper() != null;
        try {
            boolean validateSchema = !validatedRealmFiles.containsKey(configuration.getPath());
            return Realm.createAndValidate(configuration, validateSchema, autoRefresh);
        }
        catch (RealmMigrationNeededException e) {
            if (configuration.shouldDeleteRealmIfMigrationNeeded()) {
                Realm.deleteRealm(configuration);
            } else {
                Realm.migrateRealm(configuration);
            }
            return Realm.createAndValidate(configuration, true, autoRefresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Realm createAndValidate(RealmConfiguration configuration, boolean validateSchema, boolean autoRefresh) {
        Class<BaseRealm> clazz = BaseRealm.class;
        synchronized (BaseRealm.class) {
            Map<RealmConfiguration, Realm> realms;
            Realm realm;
            String canonicalPath = configuration.getPath();
            Map<RealmConfiguration, Integer> localRefCount = referenceCount.get();
            Integer references = localRefCount.get(configuration);
            if (references == null) {
                references = 0;
            }
            if ((realm = (realms = realmsCache.get()).get(configuration)) != null) {
                localRefCount.put(configuration, references + 1);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return realm;
            }
            Realm.validateAgainstExistingConfigurations(configuration);
            realm = new Realm(configuration, autoRefresh);
            CopyOnWriteArrayList<RealmConfiguration> pathConfigurationCache = (CopyOnWriteArrayList<RealmConfiguration>)globalPathConfigurationCache.get(canonicalPath);
            if (pathConfigurationCache == null) {
                pathConfigurationCache = new CopyOnWriteArrayList<RealmConfiguration>();
                globalPathConfigurationCache.put(canonicalPath, pathConfigurationCache);
            }
            pathConfigurationCache.add(configuration);
            realms.put(configuration, realm);
            localRefCount.put(configuration, references + 1);
            Realm.acquireFileReference(configuration);
            long currentVersion = realm.getVersion();
            long requiredVersion = configuration.getSchemaVersion();
            if (currentVersion != -1L && currentVersion < requiredVersion && validateSchema) {
                realm.close();
                throw new RealmMigrationNeededException(configuration.getPath(), String.format("Realm on disk need to migrate from v%s to v%s", currentVersion, requiredVersion));
            }
            if (currentVersion != -1L && requiredVersion < currentVersion && validateSchema) {
                realm.close();
                throw new IllegalArgumentException(String.format("Realm on disk is newer than the one specified: v%s vs. v%s", currentVersion, requiredVersion));
            }
            if (validateSchema) {
                try {
                    Realm.initializeRealm(realm);
                }
                catch (RuntimeException e) {
                    realm.close();
                    throw e;
                }
            }
            realm.columnIndices = validatedRealmFiles.get(configuration.getPath());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return realm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRealm(Realm realm) {
        long version = realm.getVersion();
        boolean commitNeeded = false;
        try {
            realm.beginTransaction();
            if (version == -1L) {
                commitNeeded = true;
                realm.setVersion(realm.configuration.getSchemaVersion());
            }
            RealmProxyMediator mediator = realm.configuration.getSchemaMediator();
            Set<Class<? extends RealmObject>> modelClasses = mediator.getModelClasses();
            HashMap<Class<? extends RealmObject>, ColumnInfo> columnInfoMap = new HashMap<Class<? extends RealmObject>, ColumnInfo>(modelClasses.size());
            for (Class<? extends RealmObject> modelClass : modelClasses) {
                if (version == -1L) {
                    mediator.createTable(modelClass, realm.sharedGroupManager.getTransaction());
                }
                columnInfoMap.put(modelClass, mediator.validateTable(modelClass, realm.sharedGroupManager.getTransaction()));
            }
            validatedRealmFiles.put(realm.getPath(), new ColumnIndices(columnInfoMap));
        }
        finally {
            if (commitNeeded) {
                realm.commitTransaction();
            } else {
                realm.cancelTransaction();
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (Exception e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return null;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            E e = this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            return e;
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
            return e;
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public <E extends RealmObject> E createObject(Class<E> clazz) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRow();
        return this.get(clazz, rowIndex);
    }

    <E extends RealmObject> E createObject(Class<E> clazz, Object primaryKeyValue) {
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return this.get(clazz, rowIndex);
    }

    void remove(Class<? extends RealmObject> clazz, long objectIndex) {
        this.getTable(clazz).moveLastOver(objectIndex);
    }

    <E extends RealmObject> E get(Class<E> clazz, long rowIndex) {
        Table table = this.getTable(clazz);
        UncheckedRow row = table.getUncheckedRow(rowIndex);
        E result = this.configuration.getSchemaMediator().newInstance(clazz, this.getColumnInfo(clazz));
        ((RealmObject)result).row = row;
        ((RealmObject)result).realm = this;
        return result;
    }

    ColumnInfo getColumnInfo(Class<? extends RealmObject> clazz) {
        ColumnInfo columnInfo = this.columnIndices.getColumnInfo(clazz);
        if (columnInfo == null) {
            throw new IllegalStateException("No validated schema information found for " + this.configuration.getSchemaMediator().getTableName(clazz));
        }
        return columnInfo;
    }

    public <E extends RealmObject> E copyToRealm(E object) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false);
    }

    public <E extends RealmObject> E copyToRealmOrUpdate(E object) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object.getClass());
        return this.copyOrUpdate(object, true);
    }

    public <E extends RealmObject> List<E> copyToRealm(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealm(object));
        }
        return realmObjects;
    }

    public <E extends RealmObject> List<E> copyToRealmOrUpdate(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealmOrUpdate(object));
        }
        return realmObjects;
    }

    boolean contains(Class<? extends RealmObject> clazz) {
        return this.configuration.getSchemaMediator().getModelClasses().contains(clazz);
    }

    public <E extends RealmObject> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return new RealmQuery<E>(this, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjects(Class<E> clazz) {
        return this.where(clazz).findAll();
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName, boolean sortAscending) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        long columnIndex = this.columnIndices.getColumnIndex(clazz, fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getSortedView(columnIndex, order);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String[] fieldNames, boolean[] sortAscending) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames must be provided.");
        }
        if (sortAscending == null) {
            throw new IllegalArgumentException("sortAscending must be provided.");
        }
        Table table = this.getTable(clazz);
        long[] columnIndices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            long columnIndex = table.getColumnIndex(fieldName);
            if (columnIndex == -1L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices[i] = columnIndex;
        }
        TableView tableView = table.getSortedView(columnIndices, sortAscending);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public <E extends RealmObject> RealmResults<E> distinct(Class<E> clazz, String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must be provided.");
        }
        this.checkIfValid();
        Table table = this.getTable(clazz);
        long columnIndex = table.getColumnIndex(fieldName);
        if (columnIndex == -1L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getDistinctView(columnIndex);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public <E extends RealmObject> RealmResults<E> distinctAsync(Class<E> clazz, String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must be provided.");
        }
        Table table = this.getTable(clazz);
        long columnIndex = table.getColumnIndex(fieldName);
        if (columnIndex == -1L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        if (!table.hasSearchIndex(columnIndex)) {
            throw new IllegalArgumentException(String.format("Field name '%s' must be indexed in order to use it for distinct queries.", fieldName));
        }
        return this.where(clazz).distinctAsync(columnIndex);
    }

    protected List<WeakReference<RealmChangeListener>> getChangeListeners() {
        return this.changeListeners;
    }

    boolean hasChanged() {
        return this.sharedGroupManager.hasChanged();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            this.cancelTransaction();
            throw new RealmException("Error during transaction.", e);
        }
        catch (Error e) {
            this.cancelTransaction();
            throw e;
        }
    }

    public RealmAsyncTask executeTransaction(final Transaction transaction, final Transaction.Callback callback) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if (callback != null && this.handler == null) {
            throw new IllegalStateException("Your Realm is opened from a thread without a Looper and you provided a callback, we need a Handler to invoke your callback");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        Future<?> pendingQuery = asyncQueryExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (!Thread.currentThread().isInterrupted()) {
                    Realm bgRealm = Realm.getInstance(realmConfiguration);
                    bgRealm.beginTransaction();
                    try {
                        transaction.execute(bgRealm);
                        if (!Thread.currentThread().isInterrupted()) {
                            bgRealm.commitTransaction();
                            if (callback != null && Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                                Realm.this.handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        callback.onSuccess();
                                    }
                                });
                            }
                        } else {
                            bgRealm.cancelTransaction();
                        }
                    }
                    catch (Exception e) {
                        bgRealm.cancelTransaction();
                        if (callback != null && Realm.this.handler != null && !Thread.currentThread().isInterrupted() && Realm.this.handler.getLooper().getThread().isAlive()) {
                            Realm.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onError(e);
                                }
                            });
                        }
                    }
                    finally {
                        bgRealm.close();
                    }
                }
            }
        });
        return new RealmAsyncTask(pendingQuery);
    }

    public void clear(Class<? extends RealmObject> clazz) {
        this.checkIfValid();
        this.getTable(clazz).clear();
    }

    private <E extends RealmObject> E copyOrUpdate(E object, boolean update) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().copyOrUpdate(this, object, update, new HashMap<RealmObject, RealmObjectProxy>());
    }

    private <E extends RealmObject> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private void checkHasPrimaryKey(Class<? extends RealmObject> clazz) {
        if (!this.getTable(clazz).hasPrimaryKey()) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    @Override
    protected Map<RealmConfiguration, Integer> getLocalReferenceCount() {
        return referenceCount.get();
    }

    @Override
    protected void lastLocalInstanceClosed() {
        validatedRealmFiles.remove(this.configuration.getPath());
        realmsCache.get().remove(this.configuration);
    }

    public static void migrateRealm(RealmConfiguration configuration) {
        Realm.migrateRealm(configuration, null);
    }

    public static void migrateRealm(RealmConfiguration configuration, RealmMigration migration) {
        BaseRealm.migrateRealm(configuration, migration, new BaseRealm.MigrationCallback(){

            @Override
            public BaseRealm getRealm(RealmConfiguration configuration) {
                return Realm.createAndValidate(configuration, false, Looper.myLooper() != null);
            }

            @Override
            public void migrationComplete() {
                realmsCache.remove();
            }
        });
    }

    public static boolean deleteRealm(RealmConfiguration configuration) {
        return BaseRealm.deleteRealm(configuration);
    }

    public static boolean compactRealm(RealmConfiguration configuration) {
        return BaseRealm.compactRealm(configuration);
    }

    static String getCanonicalPath(File realmFile) {
        try {
            return realmFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RealmException("Could not resolve the canonical path to the Realm file: " + realmFile.getAbsolutePath());
        }
    }

    static Map<Handler, String> getHandlers() {
        return handlers;
    }

    public Table getTable(Class<? extends RealmObject> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table == null) {
            clazz = Util.getOriginalModelClass(clazz);
            table = this.sharedGroupManager.getTable(this.configuration.getSchemaMediator().getTableName(clazz));
            this.classToTable.put(clazz, table);
        }
        return table;
    }

    public static Object getDefaultModule() {
        String moduleName = "io.realm.DefaultRealmModule";
        try {
            Class<?> clazz = Class.forName(moduleName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
    }

    public static interface Transaction {
        public void execute(Realm var1);

        public static class Callback {
            public void onSuccess() {
            }

            public void onError(Exception e) {
            }
        }
    }
}

