/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Message;
import io.realm.BaseRealm;
import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.internal.SharedGroup;
import io.realm.internal.async.QueryUpdateTask;
import io.realm.internal.log.RealmLog;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class HandlerController
implements Handler.Callback {
    static final int REALM_CHANGED = 14930352;
    static final int REALM_UPDATE_ASYNC_QUERIES = 24157817;
    static final int REALM_COMPLETED_ASYNC_QUERY = 39088169;
    static final int REALM_COMPLETED_ASYNC_FIND_FIRST = 63245986;
    static final int REALM_ASYNC_BACKGROUND_EXCEPTION = 102334155;
    final BaseRealm realm;
    private Future updateAsyncQueriesTask;
    final ReferenceQueue<RealmResults<? extends RealmObject>> referenceQueue = new ReferenceQueue();
    final Map<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> asyncRealmResults = new IdentityHashMap<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>();
    final Map<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>> asyncRealmObjects = new IdentityHashMap<WeakReference<RealmObject>, RealmQuery<? extends RealmObject>>();

    public HandlerController(BaseRealm realm) {
        this.realm = realm;
    }

    private void updateAsyncQueries() {
        if (this.updateAsyncQueriesTask != null && !this.updateAsyncQueriesTask.isDone()) {
            this.updateAsyncQueriesTask.cancel(true);
            Realm.asyncQueryExecutor.getQueue().remove(this.updateAsyncQueriesTask);
            RealmLog.d("REALM_CHANGED realm:" + this + " cancelling pending REALM_UPDATE_ASYNC_QUERIES updates");
        }
        RealmLog.d("REALM_CHANGED realm:" + this + " updating async queries, total: " + this.asyncRealmResults.size());
        QueryUpdateTask.Builder.UpdateQueryStep updateQueryStep = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration());
        QueryUpdateTask.Builder.RealmResultsQueryStep realmResultsQueryStep = null;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> entry = iterator.next();
            WeakReference<RealmResults<? extends RealmObject>> weakReference = entry.getKey();
            RealmResults realmResults = (RealmResults)weakReference.get();
            if (realmResults == null) {
                iterator.remove();
                continue;
            }
            realmResultsQueryStep = updateQueryStep.add(weakReference, entry.getValue().handoverQueryPointer(), entry.getValue().getArgument());
        }
        if (realmResultsQueryStep != null) {
            QueryUpdateTask queryUpdateTask = realmResultsQueryStep.sendToHandler(this.realm.handler, 24157817).build();
            this.updateAsyncQueriesTask = Realm.asyncQueryExecutor.submit(queryUpdateTask);
        }
    }

    private void completedAsyncQueryUpdate(QueryUpdateTask.Result result) {
        Set<WeakReference<RealmResults<? extends RealmObject>>> updatedTableViewsKeys = result.updatedTableViews.keySet();
        if (updatedTableViewsKeys.size() > 0) {
            WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = updatedTableViewsKeys.iterator().next();
            RealmResults realmResults = (RealmResults)weakRealmResults.get();
            if (realmResults == null) {
                this.asyncRealmResults.remove(weakRealmResults);
                RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] realm:" + this + " RealmResults GC'd ignore results");
            } else {
                SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
                int compare = callerVersionID.compareTo(result.versionID);
                if (compare == 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] , realm:" + this + " same versions, using results (RealmResults is not loaded)");
                        realmResults.swapTableViewPointer(result.updatedTableViews.get(weakRealmResults));
                        realmResults.notifyChangeListeners();
                    } else {
                        RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] , realm:" + this + " ignoring result the RealmResults (is already loaded)");
                    }
                } else if (compare > 0) {
                    if (!realmResults.isLoaded()) {
                        RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is not loaded, rerunning the query against the latest version");
                        RealmQuery<? extends RealmObject> query = this.asyncRealmResults.get(weakRealmResults);
                        QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).add(weakRealmResults, query.handoverQueryPointer(), query.getArgument()).sendToHandler(this.realm.handler, 39088169).build();
                        Realm.asyncQueryExecutor.submit(queryUpdateTask);
                    } else {
                        RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] , realm:" + this + " caller is more advanced & RealmResults is loaded ignore the outdated result");
                    }
                } else {
                    RealmLog.d("[REALM_COMPLETED_ASYNC_QUERY " + weakRealmResults + "] , realm:" + this + " caller thread behind worker thread, ignore results (a batch update will update everything including this query)");
                }
            }
        }
    }

    private void completedAsyncQueriesUpdate(QueryUpdateTask.Result result) {
        SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
        int compare = callerVersionID.compareTo(result.versionID);
        if (compare > 0) {
            RealmLog.d("REALM_UPDATE_ASYNC_QUERIES realm:" + this + " caller is more advanced, rerun updates");
            this.realm.handler.sendEmptyMessage(14930352);
        } else {
            if (compare != 0) {
                RealmLog.d("REALM_UPDATE_ASYNC_QUERIES realm:" + this + " caller is behind  advance_read");
                this.realm.sharedGroupManager.advanceRead(result.versionID);
            }
            ArrayList<RealmResults> callbacksToNotify = new ArrayList<RealmResults>(result.updatedTableViews.size());
            for (Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, Long> entry : result.updatedTableViews.entrySet()) {
                WeakReference<RealmResults<? extends RealmObject>> weakRealmResults = entry.getKey();
                RealmResults realmResults = (RealmResults)weakRealmResults.get();
                if (realmResults == null) {
                    this.asyncRealmResults.remove(weakRealmResults);
                    continue;
                }
                callbacksToNotify.add(realmResults);
                RealmLog.d("REALM_UPDATE_ASYNC_QUERIES realm:" + this + " updating RealmResults " + weakRealmResults);
                realmResults.swapTableViewPointer(entry.getValue());
            }
            for (RealmResults realmResults : callbacksToNotify) {
                realmResults.notifyChangeListeners();
            }
            if (compare != 0) {
                this.realm.sendNotifications();
            }
            this.updateAsyncQueriesTask = null;
        }
    }

    private void completedAsyncFindFirst(QueryUpdateTask.Result result) {
        WeakReference<? extends RealmObject> realmObjectWeakReference;
        RealmObject realmObject;
        Set<WeakReference<? extends RealmObject>> updatedRowKey = result.updatedRow.keySet();
        if (updatedRowKey.size() > 0 && (realmObject = (RealmObject)(realmObjectWeakReference = updatedRowKey.iterator().next()).get()) != null) {
            SharedGroup.VersionID callerVersionID = this.realm.sharedGroupManager.getVersion();
            int compare = callerVersionID.compareTo(result.versionID);
            if (compare == 0) {
                realmObject.onCompleted(result.updatedRow.get(realmObjectWeakReference));
                this.asyncRealmObjects.remove(realmObjectWeakReference);
            } else if (compare > 0) {
                RealmQuery<? extends RealmObject> realmQuery = this.asyncRealmObjects.get(realmObjectWeakReference);
                QueryUpdateTask queryUpdateTask = QueryUpdateTask.newBuilder().realmConfiguration(this.realm.getConfiguration()).addObject(realmObjectWeakReference, realmQuery.handoverQueryPointer(), realmQuery.getArgument()).sendToHandler(this.realm.handler, 63245986).build();
                Realm.asyncQueryExecutor.submit(queryUpdateTask);
            } else {
                throw new IllegalStateException("Caller thread behind the worker thread");
            }
        }
    }

    public boolean handleMessage(Message message) {
        if (this.realm.sharedGroupManager != null) {
            switch (message.what) {
                case 14930352: {
                    if (this.threadContainsAsyncQueries()) {
                        this.updateAsyncQueries();
                        break;
                    }
                    RealmLog.d("REALM_CHANGED realm:" + this + " no async queries, advance_read");
                    this.realm.sharedGroupManager.advanceRead();
                    this.realm.sendNotifications();
                    break;
                }
                case 39088169: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncQueryUpdate(result);
                    break;
                }
                case 24157817: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncQueriesUpdate(result);
                    break;
                }
                case 63245986: {
                    QueryUpdateTask.Result result = (QueryUpdateTask.Result)message.obj;
                    this.completedAsyncFindFirst(result);
                    break;
                }
                case 102334155: {
                    throw (Error)message.obj;
                }
            }
        }
        return true;
    }

    private boolean threadContainsAsyncQueries() {
        this.deleteWeakReferences();
        boolean isEmpty = true;
        Iterator<Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>>> iterator = this.asyncRealmResults.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WeakReference<RealmResults<? extends RealmObject>>, RealmQuery<? extends RealmObject>> next = iterator.next();
            if (next.getKey().get() == null) {
                iterator.remove();
                continue;
            }
            isEmpty = false;
        }
        return !isEmpty;
    }

    private void deleteWeakReferences() {
        Reference<RealmResults<? extends RealmObject>> weakReference;
        Runtime.getRuntime().gc();
        while ((weakReference = this.referenceQueue.poll()) != null) {
            this.asyncRealmResults.remove(weakReference);
        }
    }
}

