/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.os.Handler;
import android.os.Looper;
import io.realm.HandlerController;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnType;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.SharedGroup;
import io.realm.internal.SharedGroupManager;
import io.realm.internal.Table;
import io.realm.internal.android.ReleaseAndroidLogger;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.internal.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class BaseRealm
implements Closeable {
    protected static final long UNVERSIONED = -1L;
    private static final String INCORRECT_THREAD_CLOSE_MESSAGE = "Realm access from incorrect thread. Realm instance can only be closed on the thread it was created.";
    private static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they were created.";
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String DIFFERENT_KEY_MESSAGE = "Wrong key used to decrypt Realm.";
    protected static final Map<String, List<RealmConfiguration>> globalPathConfigurationCache = new HashMap<String, List<RealmConfiguration>>();
    protected static final Map<String, Integer> globalRealmFileReferenceCounter = new HashMap<String, Integer>();
    protected static final Map<Handler, String> handlers = new ConcurrentHashMap<Handler, String>();
    static final RealmThreadPoolExecutor asyncQueryExecutor = RealmThreadPoolExecutor.getInstance();
    protected final List<WeakReference<RealmChangeListener>> changeListeners = new CopyOnWriteArrayList<WeakReference<RealmChangeListener>>();
    protected long threadId = Thread.currentThread().getId();
    protected RealmConfiguration configuration;
    protected SharedGroupManager sharedGroupManager;
    protected boolean autoRefresh;
    Handler handler;
    HandlerController handlerController;

    protected BaseRealm(RealmConfiguration configuration, boolean autoRefresh) {
        this.configuration = configuration;
        this.sharedGroupManager = new SharedGroupManager(configuration);
        this.setAutoRefresh(autoRefresh);
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.checkIfValid();
        if (autoRefresh && Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot set auto-refresh in a Thread without a Looper");
        }
        if (autoRefresh && !this.autoRefresh) {
            this.handlerController = new HandlerController(this);
            this.handler = new Handler((Handler.Callback)this.handlerController);
            handlers.put(this.handler, this.configuration.getPath());
        } else if (!autoRefresh && this.autoRefresh && this.handler != null) {
            this.removeHandler();
        }
        this.autoRefresh = autoRefresh;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public boolean isInTransaction() {
        this.checkIfValid();
        return !this.sharedGroupManager.isImmutable();
    }

    public void addChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        for (WeakReference<RealmChangeListener> ref : this.changeListeners) {
            if (ref.get() != listener) continue;
            return;
        }
        this.changeListeners.add(new WeakReference<RealmChangeListener>(listener));
    }

    public void removeChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        WeakReference<RealmChangeListener> weakRefToRemove = null;
        for (WeakReference<RealmChangeListener> weakRef : this.changeListeners) {
            if (listener != weakRef.get()) continue;
            weakRefToRemove = weakRef;
            break;
        }
        if (weakRefToRemove != null) {
            this.changeListeners.remove(weakRefToRemove);
        }
    }

    void setHandler(Handler handler) {
        handlers.remove(this.handler);
        handlers.put(handler, this.configuration.getPath());
        this.handler = handler;
    }

    public void removeAllChangeListeners() {
        this.checkIfValid();
        this.changeListeners.clear();
    }

    protected void removeHandler() {
        handlers.remove(this.handler);
        this.handler.removeCallbacksAndMessages(null);
        this.handler = null;
    }

    protected void sendNotifications() {
        Iterator<WeakReference<RealmChangeListener>> iterator = this.changeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        while (iterator.hasNext()) {
            WeakReference<RealmChangeListener> weakRef = iterator.next();
            RealmChangeListener listener = (RealmChangeListener)weakRef.get();
            if (listener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.changeListeners.size());
                }
                toRemoveList.add(weakRef);
                continue;
            }
            listener.onChange();
        }
        if (toRemoveList != null) {
            this.changeListeners.removeAll(toRemoveList);
        }
    }

    protected static boolean isFileOpen(RealmConfiguration configuration) {
        Integer refCount = globalRealmFileReferenceCounter.get(configuration.getPath());
        return refCount != null && refCount > 0;
    }

    public void writeCopyTo(File destination) throws IOException {
        this.writeEncryptedCopyTo(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) throws IOException {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.sharedGroupManager.copyToFile(destination, key);
    }

    public void refresh() {
        this.checkIfValid();
        this.sharedGroupManager.advanceRead();
        this.sendNotifications();
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.promoteToWrite();
    }

    public void commitTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.commitAndContinueAsRead();
        for (Map.Entry<Handler, String> handlerIntegerEntry : handlers.entrySet()) {
            Handler handler = handlerIntegerEntry.getKey();
            String realmPath = handlerIntegerEntry.getValue();
            if (handler.equals(this.handler)) {
                this.sendNotifications();
                continue;
            }
            if (!realmPath.equals(this.configuration.getPath()) || handler.hasMessages(14930352) || !handler.getLooper().getThread().isAlive() || handler.sendEmptyMessage(14930352)) continue;
            RealmLog.w("Cannot update Looper threads when the Looper has quit. Use realm.setAutoRefresh(false) to prevent this.");
        }
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.sharedGroupManager.rollbackAndContinueAsRead();
    }

    protected void checkIfValid() {
        if (this.sharedGroupManager == null || !this.sharedGroupManager.isOpen()) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    public long getVersion() {
        if (!this.sharedGroupManager.hasTable("metadata")) {
            return -1L;
        }
        Table metadataTable = this.sharedGroupManager.getTable("metadata");
        return metadataTable.getLong(0L, 0L);
    }

    @Override
    public void close() {
        int refCount;
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_CLOSE_MESSAGE);
        }
        Map<RealmConfiguration, Integer> localRefCount = this.getLocalReferenceCount();
        String canonicalPath = this.configuration.getPath();
        Integer references = localRefCount.get(this.configuration);
        if (references == null) {
            references = 0;
        }
        if (this.sharedGroupManager != null && references == 1) {
            this.lastLocalInstanceClosed();
            this.sharedGroupManager.close();
            this.sharedGroupManager = null;
            BaseRealm.releaseFileReference(this.configuration);
        }
        if ((refCount = references - 1) < 0) {
            RealmLog.w("Calling close() on a Realm that is already closed: " + canonicalPath);
        }
        localRefCount.put(this.configuration, Math.max(0, refCount));
        if (this.handler != null && refCount <= 0) {
            this.removeHandler();
        }
    }

    public boolean isClosed() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
        return this.sharedGroupManager == null || !this.sharedGroupManager.isOpen();
    }

    protected abstract Map<RealmConfiguration, Integer> getLocalReferenceCount();

    protected abstract void lastLocalInstanceClosed();

    static synchronized void acquireFileReference(RealmConfiguration configuration) {
        String path = configuration.getPath();
        Integer refCount = globalRealmFileReferenceCounter.get(path);
        if (refCount == null) {
            refCount = 0;
        }
        globalRealmFileReferenceCounter.put(path, refCount + 1);
    }

    static synchronized void releaseFileReference(RealmConfiguration configuration) {
        Integer refCount;
        String canonicalPath = configuration.getPath();
        List<RealmConfiguration> pathConfigurationCache = globalPathConfigurationCache.get(canonicalPath);
        pathConfigurationCache.remove(configuration);
        if (pathConfigurationCache.isEmpty()) {
            globalPathConfigurationCache.remove(canonicalPath);
        }
        if ((refCount = globalRealmFileReferenceCounter.get(canonicalPath)) == null || refCount == 0) {
            throw new IllegalStateException("Trying to release a Realm file that is already closed");
        }
        globalRealmFileReferenceCounter.put(canonicalPath, refCount - 1);
    }

    protected void setVersion(long version) {
        Table metadataTable = this.sharedGroupManager.getTable("metadata");
        if (metadataTable.getColumnCount() == 0L) {
            metadataTable.addColumn(ColumnType.INTEGER, "version");
            metadataTable.addEmptyRow();
        }
        metadataTable.setLong(0L, 0L, version);
    }

    protected static synchronized void validateAgainstExistingConfigurations(RealmConfiguration newConfiguration) {
        String realmPath = newConfiguration.getPath();
        List<RealmConfiguration> pathConfigurationCache = globalPathConfigurationCache.get(realmPath);
        if (pathConfigurationCache != null && pathConfigurationCache.size() > 0) {
            SharedGroup.Durability newDurability;
            RealmProxyMediator schema;
            RealmConfiguration cachedConfiguration = pathConfigurationCache.get(0);
            if (!Arrays.equals(cachedConfiguration.getEncryptionKey(), newConfiguration.getEncryptionKey())) {
                throw new IllegalArgumentException(DIFFERENT_KEY_MESSAGE);
            }
            if (cachedConfiguration.getSchemaVersion() != newConfiguration.getSchemaVersion()) {
                throw new IllegalArgumentException(String.format("Configurations cannot have different schema versions if used to open the same file. %d vs. %d", cachedConfiguration.getSchemaVersion(), newConfiguration.getSchemaVersion()));
            }
            RealmProxyMediator cachedSchema = cachedConfiguration.getSchemaMediator();
            if (!cachedSchema.equals(schema = newConfiguration.getSchemaMediator())) {
                throw new IllegalArgumentException("Two configurations with different schemas are trying to open the same Realm file. Their schema must be the same: " + newConfiguration.getPath());
            }
            SharedGroup.Durability cachedDurability = cachedConfiguration.getDurability();
            if (!cachedDurability.equals((Object)(newDurability = newConfiguration.getDurability()))) {
                throw new IllegalArgumentException("A Realm cannot be both in-memory and persisted. Two conflicting configurations pointing to " + newConfiguration.getPath() + " are being used.");
            }
        }
    }

    protected static synchronized boolean deleteRealm(RealmConfiguration configuration) {
        if (BaseRealm.isFileOpen(configuration)) {
            throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file.");
        }
        boolean realmDeleted = true;
        String canonicalPath = configuration.getPath();
        File realmFolder = configuration.getRealmFolder();
        String realmFileName = configuration.getRealmFileName();
        List<File> filesToDelete = Arrays.asList(new File(canonicalPath), new File(realmFolder, realmFileName + ".lock"), new File(realmFolder, realmFileName + ".lock_a"), new File(realmFolder, realmFileName + ".lock_b"), new File(realmFolder, realmFileName + ".log"));
        for (File fileToDelete : filesToDelete) {
            boolean deleteResult;
            if (!fileToDelete.exists() || (deleteResult = fileToDelete.delete())) continue;
            realmDeleted = false;
            RealmLog.w("Could not delete the file " + fileToDelete);
        }
        return realmDeleted;
    }

    public static synchronized boolean compactRealm(RealmConfiguration configuration) {
        if (configuration.getEncryptionKey() != null) {
            throw new IllegalArgumentException("Cannot currently compact an encrypted Realm.");
        }
        if (BaseRealm.isFileOpen(configuration)) {
            throw new IllegalStateException("Cannot compact an open Realm");
        }
        return SharedGroupManager.compact(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void migrateRealm(RealmConfiguration configuration, RealmMigration migration, MigrationCallback callback) {
        if (configuration == null) {
            throw new IllegalArgumentException("RealmConfiguration must be provided");
        }
        if (migration == null && configuration.getMigration() == null) {
            throw new RealmMigrationNeededException(configuration.getPath(), "RealmMigration must be provided");
        }
        if (BaseRealm.isFileOpen(configuration)) {
            throw new IllegalStateException("Cannot migrate a Realm file that is already open: " + configuration.getPath());
        }
        RealmMigration realmMigration = migration == null ? configuration.getMigration() : migration;
        BaseRealm realm = null;
        try {
            realm = callback.getRealm(configuration);
            realm.beginTransaction();
            realm.setVersion(realmMigration.execute((Realm)realm, realm.getVersion()));
            realm.commitTransaction();
        }
        finally {
            if (realm != null) {
                realm.close();
                callback.migrationComplete();
            }
        }
    }

    protected void addAsyncRealmResults(WeakReference<RealmResults<? extends RealmObject>> weakRealmResults, RealmQuery<? extends RealmObject> realmQuery) {
        this.handlerController.asyncRealmResults.put(weakRealmResults, realmQuery);
    }

    protected void addAsyncRealmObject(WeakReference<RealmObject> realmObjectWeakReference, RealmQuery<? extends RealmObject> realmQuery) {
        this.handlerController.asyncRealmObjects.put(realmObjectWeakReference, realmQuery);
    }

    protected ReferenceQueue<RealmResults<? extends RealmObject>> getReferenceQueue() {
        return this.handlerController.referenceQueue;
    }

    static {
        RealmLog.add(new ReleaseAndroidLogger());
    }

    protected static interface MigrationCallback {
        public BaseRealm getRealm(RealmConfiguration var1);

        public void migrationComplete();
    }
}

