/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.ClassMetaData;
import io.realm.processor.Constants;
import io.realm.processor.RealmJsonTypeHelper;
import io.realm.processor.Utils;
import io.realm.processor.javawriter.JavaWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class RealmProxyClassGenerator {
    private ProcessingEnvironment processingEnvironment;
    private ClassMetaData metadata;
    private final String className;
    private Elements elementUtils;
    private Types typeUtils;
    private TypeMirror realmObject;
    private DeclaredType realmList;

    public RealmProxyClassGenerator(ProcessingEnvironment processingEnvironment, ClassMetaData metadata) {
        this.processingEnvironment = processingEnvironment;
        this.metadata = metadata;
        this.className = metadata.getSimpleClassName();
    }

    public void generate() throws IOException, UnsupportedOperationException {
        this.elementUtils = this.processingEnvironment.getElementUtils();
        this.typeUtils = this.processingEnvironment.getTypeUtils();
        this.realmObject = this.elementUtils.getTypeElement("io.realm.RealmObject").asType();
        this.realmList = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("io.realm.RealmList"), this.typeUtils.getWildcardType(null, null));
        String qualifiedGeneratedClassName = String.format("%s.%s", "io.realm", Utils.getProxyClassName(this.className));
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter(new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm").emitEmptyLine();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("android.util.JsonReader");
        imports.add("android.util.JsonToken");
        imports.add("io.realm.RealmObject");
        imports.add("io.realm.exceptions.RealmException");
        imports.add("io.realm.exceptions.RealmMigrationNeededException");
        imports.add("io.realm.internal.ColumnType");
        imports.add("io.realm.internal.RealmObjectProxy");
        imports.add("io.realm.internal.Table");
        imports.add("io.realm.internal.TableOrView");
        imports.add("io.realm.internal.ImplicitTransaction");
        imports.add("io.realm.internal.LinkView");
        imports.add("io.realm.internal.android.JsonUtils");
        imports.add("java.io.IOException");
        imports.add("java.util.ArrayList");
        imports.add("java.util.Collections");
        imports.add("java.util.List");
        imports.add("java.util.Arrays");
        imports.add("java.util.Date");
        imports.add("java.util.Map");
        imports.add("java.util.HashMap");
        imports.add("org.json.JSONObject");
        imports.add("org.json.JSONException");
        imports.add("org.json.JSONArray");
        imports.add(this.metadata.getFullyQualifiedClassName());
        for (VariableElement field : this.metadata.getFields()) {
            String fieldTypeName = "";
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                fieldTypeName = field.asType().toString();
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                fieldTypeName = ((DeclaredType)field.asType()).getTypeArguments().get(0).toString();
            }
            if (fieldTypeName.isEmpty() || imports.contains(fieldTypeName)) continue;
            imports.add(fieldTypeName);
        }
        Collections.sort(imports);
        writer.emitImports(imports);
        writer.emitEmptyLine();
        writer.beginType(qualifiedGeneratedClassName, "class", EnumSet.of(Modifier.PUBLIC), this.className, "RealmObjectProxy").emitEmptyLine();
        this.emitClassFields(writer);
        this.emitAccessors(writer);
        this.emitInitTableMethod(writer);
        this.emitValidateTableMethod(writer);
        this.emitGetTableNameMethod(writer);
        this.emitGetFieldNamesMethod(writer);
        this.emitGetColumnIndicesMethod(writer);
        this.emitCreateOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        this.emitCopyOrUpdateMethod(writer);
        this.emitCopyMethod(writer);
        this.emitUpdateMethod(writer);
        this.emitToStringMethod(writer);
        this.emitHashcodeMethod(writer);
        this.emitEqualsMethod(writer);
        writer.endType();
        writer.close();
    }

    private void emitClassFields(JavaWriter writer) throws IOException {
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitField("long", this.staticFieldIndexVarName(variableElement), EnumSet.of(Modifier.PRIVATE, Modifier.STATIC));
        }
        writer.emitField("Map<String, Long>", "columnIndices", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC));
        writer.emitField("List<String>", "FIELD_NAMES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL));
        writer.beginInitializer(true);
        writer.emitStatement("List<String> fieldNames = new ArrayList<String>()", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("fieldNames.add(\"%s\")", field.getSimpleName().toString());
        }
        writer.emitStatement("FIELD_NAMES = Collections.unmodifiableList(fieldNames)", new Object[0]);
        writer.endInitializer();
        writer.emitEmptyLine();
    }

    private void emitAccessors(JavaWriter writer) throws IOException {
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String realmType = Constants.JAVA_TO_REALM_TYPES.get(fieldTypeCanonicalName);
                String castingType = Constants.CASTING_TYPES.get(fieldTypeCanonicalName);
                writer.emitAnnotation("Override");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.emitStatement("return (%s) row.get%s(%s)", fieldTypeCanonicalName, realmType, this.staticFieldIndexVarName(field));
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.emitStatement("realm.checkIfValid()", new Object[0]);
                writer.emitStatement("row.set%s(%s, (%s) value)", realmType, this.staticFieldIndexVarName(field), castingType);
                writer.endMethod();
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                writer.emitAnnotation("Override");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.beginControlFlow("if (row.isNullLink(%s))", this.staticFieldIndexVarName(field));
                writer.emitStatement("return null", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("return realm.get(%s.class, row.getLink(%s))", fieldTypeCanonicalName, this.staticFieldIndexVarName(field));
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("row.nullifyLink(%s)", this.staticFieldIndexVarName(field));
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("row.setLink(%s, value.row.getIndex())", this.staticFieldIndexVarName(field));
                writer.endMethod();
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                String genericType = Utils.getGenericType(field);
                writer.emitAnnotation("Override");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                writer.emitStatement("return new RealmList<%s>(%s.class, row.getLinkList(%s), realm)", genericType, genericType, this.staticFieldIndexVarName(field));
                writer.endMethod();
                writer.emitEmptyLine();
                writer.emitAnnotation("Override");
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), fieldTypeCanonicalName, "value");
                writer.emitStatement("LinkView links = row.getLinkList(%s)", this.staticFieldIndexVarName(field));
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("links.clear()", new Object[0]);
                writer.beginControlFlow("for (RealmObject linkedObject : (RealmList<? extends RealmObject>) value)", new Object[0]);
                writer.emitStatement("links.add(linkedObject.row.getIndex())", new Object[0]);
                writer.endControlFlow();
                writer.endMethod();
            } else {
                throw new UnsupportedOperationException(String.format("Type %s of field %s is not supported", fieldTypeCanonicalName, fieldName));
            }
            writer.emitEmptyLine();
        }
    }

    private void emitInitTableMethod(JavaWriter writer) throws IOException {
        String fieldName;
        writer.beginMethod("Table", "initTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "ImplicitTransaction", "transaction");
        writer.beginControlFlow("if (!transaction.hasTable(\"class_" + this.className + "\"))", new Object[0]);
        writer.emitStatement("Table table = transaction.getTable(\"%s%s\")", "class_", this.className);
        for (VariableElement field : this.metadata.getFields()) {
            fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                writer.emitStatement("table.addColumn(%s, \"%s\")", Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName), fieldName);
                continue;
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", fieldTypeSimpleName);
                writer.emitStatement("%s%s.initTable(transaction)", fieldTypeSimpleName, "RealmProxy");
                writer.endControlFlow();
                writer.emitStatement("table.addColumnLink(ColumnType.LINK, \"%s\", transaction.getTable(\"%s%s\"))", fieldName, "class_", fieldTypeSimpleName);
                continue;
            }
            if (!this.typeUtils.isAssignable(field.asType(), this.realmList)) continue;
            String genericType = Utils.getGenericType(field);
            writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", genericType);
            writer.emitStatement("%s%s.initTable(transaction)", genericType, "RealmProxy");
            writer.endControlFlow();
            writer.emitStatement("table.addColumnLink(ColumnType.LINK_LIST, \"%s\", transaction.getTable(\"%s%s\"))", fieldName, "class_", genericType);
        }
        for (VariableElement field : this.metadata.getIndexedFields()) {
            fieldName = field.getSimpleName().toString();
            writer.emitStatement("table.addSearchIndex(table.getColumnIndex(\"%s\"))", fieldName);
        }
        if (this.metadata.hasPrimaryKey()) {
            String fieldName2 = this.metadata.getPrimaryKey().getSimpleName().toString();
            writer.emitStatement("table.setPrimaryKey(\"%s\")", fieldName2);
        } else {
            writer.emitStatement("table.setPrimaryKey(\"\")", new Object[0]);
        }
        writer.emitStatement("return table", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("return transaction.getTable(\"%s%s\")", "class_", this.className);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitValidateTableMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "validateTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "ImplicitTransaction", "transaction");
        writer.beginControlFlow("if (transaction.hasTable(\"class_" + this.className + "\"))", new Object[0]);
        writer.emitStatement("Table table = transaction.getTable(\"%s%s\")", "class_", this.className);
        writer.beginControlFlow("if (table.getColumnCount() != " + this.metadata.getFields().size() + ")", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field count does not match - expected %d but was \" + table.getColumnCount())", this.metadata.getFields().size());
        writer.endControlFlow();
        writer.emitStatement("Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>()", new Object[0]);
        writer.beginControlFlow("for (long i = 0; i < " + this.metadata.getFields().size() + "; i++)", new Object[0]);
        writer.emitStatement("columnTypes.put(table.getColumnName(i), table.getColumnType(i))", new Object[0]);
        writer.endControlFlow();
        writer.emitEmptyLine();
        writer.emitStatement("columnIndices = new HashMap<String, Long>()", new Object[0]);
        writer.beginControlFlow("for (String fieldName : getFieldNames())", new Object[0]).emitStatement("long index = table.getColumnIndex(fieldName)", new Object[0]).beginControlFlow("if (index == -1)", new Object[0]).emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Field '\" + fieldName + \"' not found for type %s\")", this.metadata.getSimpleClassName()).endControlFlow().emitStatement("columnIndices.put(fieldName, index)", new Object[0]).endControlFlow();
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("%s = table.getColumnIndex(\"%s\")", this.staticFieldIndexVarName(field), field.getSimpleName().toString());
        }
        writer.emitEmptyLine();
        long fieldIndex = 0L;
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s'\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != %s)", fieldName, Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName));
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s'\")", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                if (field.equals(this.metadata.getPrimaryKey())) {
                    writer.beginControlFlow("if (table.getPrimaryKey() != table.getColumnIndex(\"%s\"))", fieldName);
                    writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Primary key not defined for field '%s'\")", fieldName);
                    writer.endControlFlow();
                }
                if (this.metadata.getIndexedFields().contains(field)) {
                    writer.beginControlFlow("if (!table.hasSearchIndex(table.getColumnIndex(\"%s\")))", fieldName);
                    writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Index not defined for field '%s'\")", fieldName);
                    writer.endControlFlow();
                }
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s'\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != ColumnType.LINK)", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s'\")", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", fieldTypeSimpleName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing class '%s%s' for field '%s'\")", "class_", fieldTypeSimpleName, fieldName);
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = transaction.getTable(\"%s%s\")", fieldIndex, "class_", fieldTypeSimpleName);
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", this.staticFieldIndexVarName(field), fieldIndex);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid RealmObject for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", fieldName, this.staticFieldIndexVarName(field), fieldIndex);
                writer.endControlFlow();
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                String genericType = Utils.getGenericType(field);
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing field '%s'\")", fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != ColumnType.LINK_LIST)", fieldName);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid type '%s' for field '%s'\")", genericType, fieldName);
                writer.endControlFlow();
                writer.beginControlFlow("if (!transaction.hasTable(\"%s%s\"))", "class_", genericType);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Missing class '%s%s' for field '%s'\")", "class_", genericType, fieldName);
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = transaction.getTable(\"%s%s\")", fieldIndex, "class_", genericType);
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", this.staticFieldIndexVarName(field), fieldIndex);
                writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"Invalid RealmList type for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", fieldName, this.staticFieldIndexVarName(field), fieldIndex);
                writer.endControlFlow();
            }
            ++fieldIndex;
        }
        writer.nextControlFlow("else", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(transaction.getPath(), \"The %s class is missing from the schema for this Realm.\")", this.metadata.getSimpleClassName());
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetTableNameMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("String", "getTableName", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return \"%s%s\"", "class_", this.className);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetFieldNamesMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("List<String>", "getFieldNames", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return FIELD_NAMES", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetColumnIndicesMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("Map<String,Long>", "getColumnIndices", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return columnIndices", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "copyOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "Realm", "realm", this.className, "object", "boolean", "update", "Map<RealmObject,RealmObjectProxy>", "cache");
        writer.beginControlFlow("if (object.realm != null && object.realm.getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return object", new Object[0]).endControlFlow();
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("return copy(realm, object, update, cache)", new Object[0]);
        } else {
            writer.emitStatement("%s realmObject = null", this.className).emitStatement("boolean canUpdate = update", new Object[0]).beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", this.className).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
            if (Utils.isString(this.metadata.getPrimaryKey())) {
                writer.beginControlFlow("if (object.%s() == null)", this.metadata.getPrimaryKeyGetter()).emitStatement("throw new IllegalArgumentException(\"Primary key value must not be null.\")", new Object[0]).endControlFlow().emitStatement("long rowIndex = table.findFirstString(pkColumnIndex, object.%s())", this.metadata.getPrimaryKeyGetter());
            } else {
                writer.emitStatement("long rowIndex = table.findFirstLong(pkColumnIndex, object.%s())", this.metadata.getPrimaryKeyGetter());
            }
            writer.beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).emitStatement("realmObject = new %s()", Utils.getProxyClassName(this.className)).emitStatement("realmObject.realm = realm", new Object[0]).emitStatement("realmObject.row = table.getUncheckedRow(rowIndex)", new Object[0]).emitStatement("cache.put(object, (RealmObjectProxy) realmObject)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("canUpdate = false", new Object[0]).endControlFlow();
            writer.endControlFlow();
            writer.emitEmptyLine().beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("return update(realm, realmObject, object, cache)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("return copy(realm, object, update, cache)", new Object[0]).endControlFlow();
        }
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "copy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), "Realm", "realm", this.className, "newObject", "boolean", "update", "Map<RealmObject,RealmObjectProxy>", "cache");
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s realmObject = realm.createObject(%s.class, newObject.%s())", this.className, this.className, this.metadata.getPrimaryKeyGetter());
        } else {
            writer.emitStatement("%s realmObject = realm.createObject(%s.class)", this.className, this.className);
        }
        writer.emitStatement("cache.put(newObject, (RealmObjectProxy) realmObject)", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = newObject.%s()", fieldType, fieldName, this.metadata.getGetter(fieldName)).beginControlFlow("if (%sObj != null)", fieldName).emitStatement("%s cache%s = (%s) cache.get(%sObj)", fieldType, fieldName, fieldType, fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("realmObject.%s(cache%s)", this.metadata.getSetter(fieldName), fieldName).nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(%s.copyOrUpdate(realm, %sObj, update, cache))", this.metadata.getSetter(fieldName), Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().endControlFlow();
                continue;
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = newObject.%s()", Utils.getGenericType(field), fieldName, this.metadata.getGetter(fieldName)).beginControlFlow("if (%sList != null)", fieldName).emitStatement("RealmList<%s> %sRealmList = realmObject.%s()", Utils.getGenericType(field), fieldName, this.metadata.getGetter(fieldName)).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", fieldName).emitStatement("%s %sItem = %sList.get(i)", Utils.getGenericType(field), fieldName, fieldName).emitStatement("%s cache%s = (%s) cache.get(%sItem)", Utils.getGenericType(field), fieldName, Utils.getGenericType(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("%sRealmList.add(cache%s)", fieldName, fieldName).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), update, cache))", fieldName, Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (Constants.NULLABLE_JAVA_TYPES.containsKey(fieldType)) {
                writer.emitStatement("realmObject.%s(newObject.%s() != null ? newObject.%s() : %s)", this.metadata.getSetter(fieldName), this.metadata.getGetter(fieldName), this.metadata.getGetter(fieldName), Constants.NULLABLE_JAVA_TYPES.get(fieldType));
                continue;
            }
            writer.emitStatement("realmObject.%s(newObject.%s())", this.metadata.getSetter(fieldName), this.metadata.getGetter(fieldName));
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "update", EnumSet.of(Modifier.STATIC), "Realm", "realm", this.className, "realmObject", this.className, "newObject", "Map<RealmObject, RealmObjectProxy>", "cache");
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                writer.emitStatement("%s %sObj = newObject.%s()", Utils.getFieldTypeSimpleName(field), fieldName, this.metadata.getGetter(fieldName)).beginControlFlow("if (%sObj != null)", fieldName).emitStatement("%s cache%s = (%s) cache.get(%sObj)", Utils.getFieldTypeSimpleName(field), fieldName, Utils.getFieldTypeSimpleName(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("realmObject.%s(cache%s)", this.metadata.getSetter(fieldName), fieldName).nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(%s.copyOrUpdate(realm, %sObj, true, cache))", this.metadata.getSetter(fieldName), Utils.getProxyClassSimpleName(field), fieldName, Utils.getFieldTypeSimpleName(field)).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("realmObject.%s(null)", this.metadata.getSetter(fieldName)).endControlFlow();
                continue;
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                writer.emitStatement("RealmList<%s> %sList = newObject.%s()", Utils.getGenericType(field), fieldName, this.metadata.getGetter(fieldName)).emitStatement("RealmList<%s> %sRealmList = realmObject.%s()", Utils.getGenericType(field), fieldName, this.metadata.getGetter(fieldName)).emitStatement("%sRealmList.clear()", fieldName).beginControlFlow("if (%sList != null)", fieldName).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", fieldName).emitStatement("%s %sItem = %sList.get(i)", Utils.getGenericType(field), fieldName, fieldName).emitStatement("%s cache%s = (%s) cache.get(%sItem)", Utils.getGenericType(field), fieldName, Utils.getGenericType(field), fieldName).beginControlFlow("if (cache%s != null)", fieldName).emitStatement("%sRealmList.add(cache%s)", fieldName, fieldName).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), true, cache))", fieldName, Utils.getProxyClassSimpleName(field), fieldName).endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (field == this.metadata.getPrimaryKey()) continue;
            String fieldType = field.asType().toString();
            if (Constants.NULLABLE_JAVA_TYPES.containsKey(fieldType)) {
                writer.emitStatement("realmObject.%s(newObject.%s() != null ? newObject.%s() : %s)", this.metadata.getSetter(fieldName), this.metadata.getGetter(fieldName), this.metadata.getGetter(fieldName), Constants.NULLABLE_JAVA_TYPES.get(fieldType));
                continue;
            }
            writer.emitStatement("realmObject.%s(newObject.%s())", this.metadata.getSetter(fieldName), this.metadata.getGetter(fieldName));
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitToStringMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("String", "toString", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.beginControlFlow("if (!isValid())", new Object[0]);
        writer.emitStatement("return \"Invalid object\"", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("StringBuilder stringBuilder = new StringBuilder(\"%s = [\")", this.className);
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            writer.emitStatement("stringBuilder.append(\"{%s:\")", fieldName);
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(%s() != null ? \"%s\" : \"null\")", this.metadata.getGetter(fieldName), fieldTypeSimpleName);
            } else if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                String genericType = Utils.getGenericType(field);
                writer.emitStatement("stringBuilder.append(\"RealmList<%s>[\").append(%s().size()).append(\"]\")", genericType, this.metadata.getGetter(fieldName));
            } else {
                writer.emitStatement("stringBuilder.append(%s())", this.metadata.getGetter(fieldName));
            }
            writer.emitStatement("stringBuilder.append(\"}\")", new Object[0]);
            if (i >= fields.size() - 1) continue;
            writer.emitStatement("stringBuilder.append(\",\")", new Object[0]);
        }
        writer.emitStatement("stringBuilder.append(\"]\")", new Object[0]);
        writer.emitStatement("return stringBuilder.toString()", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitHashcodeMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("String realmName = realm.getPath()", new Object[0]);
        writer.emitStatement("String tableName = row.getTable().getName()", new Object[0]);
        writer.emitStatement("long rowIndex = row.getIndex()", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("int result = 17", new Object[0]);
        writer.emitStatement("result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32))", new Object[0]);
        writer.emitStatement("return result", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitEqualsMethod(JavaWriter writer) throws IOException {
        String proxyClassName = this.className + "RealmProxy";
        writer.emitAnnotation("Override");
        writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), "Object", "o");
        writer.emitStatement("if (this == o) return true", new Object[0]);
        writer.emitStatement("if (o == null || getClass() != o.getClass()) return false", new Object[0]);
        writer.emitStatement("%s a%s = (%s)o", proxyClassName, this.className, proxyClassName);
        writer.emitEmptyLine();
        writer.emitStatement("String path = realm.getPath()", new Object[0]);
        writer.emitStatement("String otherPath = a%s.realm.getPath()", this.className);
        writer.emitStatement("if (path != null ? !path.equals(otherPath) : otherPath != null) return false;", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("String tableName = row.getTable().getName()", new Object[0]);
        writer.emitStatement("String otherTableName = a%s.row.getTable().getName()", this.className);
        writer.emitStatement("if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("if (row.getIndex() != a%s.row.getIndex()) return false", this.className);
        writer.emitEmptyLine();
        writer.emitStatement("return true", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JSONObject", "json", "boolean", "update"), Arrays.asList("JSONException"));
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s obj = realm.createObject(%s.class)", this.className, this.className);
        } else {
            String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
            writer.emitStatement("%s obj = null", this.className).beginControlFlow("if (update)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", this.className).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]).beginControlFlow("if (!json.isNull(\"%s\"))", this.metadata.getPrimaryKey().getSimpleName()).emitStatement("long rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()).beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).emitStatement("obj = new %s()", Utils.getProxyClassName(this.className)).emitStatement("obj.realm = realm", new Object[0]).emitStatement("obj.row = table.getUncheckedRow(rowIndex)", new Object[0]).endControlFlow().endControlFlow().endControlFlow().beginControlFlow("if (obj == null)", new Object[0]).emitStatement("obj = realm.createObject(%s.class)", this.className).endControlFlow();
        }
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                RealmJsonTypeHelper.emitFillRealmObjectWithJsonValue(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                RealmJsonTypeHelper.emitFillRealmListWithJsonValue(this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), fieldName, ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeWithJsonValue(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.beginMethod(this.className, "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JsonReader", "reader"), Arrays.asList("IOException"));
        writer.emitStatement("%s obj = realm.createObject(%s.class)", this.className, this.className);
        writer.emitStatement("reader.beginObject()", new Object[0]);
        writer.beginControlFlow("while (reader.hasNext())", new Object[0]);
        writer.emitStatement("String name = reader.nextName()", new Object[0]);
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (Utils.isString(qualifiedFieldType)) {
                if (i == 0) {
                    writer.beginControlFlow("if (name.equals(\"%s\"))", fieldName);
                } else {
                    writer.nextControlFlow("else if (name.equals(\"%s\"))", fieldName);
                }
            } else if (i == 0) {
                writer.beginControlFlow("if (name.equals(\"%s\") && reader.peek() != JsonToken.NULL)", fieldName);
            } else {
                writer.nextControlFlow("else if (name.equals(\"%s\")  && reader.peek() != JsonToken.NULL)", fieldName);
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmObject)) {
                RealmJsonTypeHelper.emitFillRealmObjectFromStream(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (this.typeUtils.isAssignable(field.asType(), this.realmList)) {
                RealmJsonTypeHelper.emitFillRealmListFromStream(this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeFromStream(this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        if (fields.size() > 0) {
            writer.nextControlFlow("else", new Object[0]);
            writer.emitStatement("reader.skipValue()", new Object[0]);
            writer.endControlFlow();
        }
        writer.endControlFlow();
        writer.emitStatement("reader.endObject()", new Object[0]);
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private String staticFieldIndexVarName(VariableElement variableElement) {
        return "INDEX_" + variableElement.getSimpleName().toString().toUpperCase();
    }
}

