/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.Ignore;
import io.realm.annotations.Index;
import io.realm.annotations.PrimaryKey;
import io.realm.processor.Constants;
import io.realm.processor.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ClassMetaData {
    private final TypeElement classType;
    private String className;
    private String packageName;
    private boolean hasDefaultConstructor;
    private VariableElement primaryKey;
    private List<VariableElement> fields = new ArrayList<VariableElement>();
    private List<String> fieldNames = new ArrayList<String>();
    private List<String> ignoreFieldNames = new ArrayList<String>();
    private List<VariableElement> indexedFields = new ArrayList<VariableElement>();
    private Set<String> expectedGetters = new HashSet<String>();
    private Set<String> expectedSetters = new HashSet<String>();
    private Set<ExecutableElement> methods = new HashSet<ExecutableElement>();
    private Map<String, String> getters = new HashMap<String, String>();
    private Map<String, String> setters = new HashMap<String, String>();
    private final List<TypeMirror> validPrimaryKeyTypes;
    private final Types typeUtils;
    private DeclaredType realmList;

    public ClassMetaData(ProcessingEnvironment env, TypeElement clazz) {
        this.classType = clazz;
        this.className = clazz.getSimpleName().toString();
        this.typeUtils = env.getTypeUtils();
        TypeMirror stringType = env.getElementUtils().getTypeElement("java.lang.String").asType();
        this.realmList = this.typeUtils.getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmList"), this.typeUtils.getWildcardType(null, null));
        this.validPrimaryKeyTypes = Arrays.asList(stringType, this.typeUtils.getPrimitiveType(TypeKind.SHORT), this.typeUtils.getPrimitiveType(TypeKind.INT), this.typeUtils.getPrimitiveType(TypeKind.LONG));
    }

    public boolean generate() {
        Element enclosingElement = this.classType.getEnclosingElement();
        if (!enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
            Utils.error("The RealmClass annotation does not support nested classes", this.classType);
            return false;
        }
        TypeElement parentElement = (TypeElement)Utils.getSuperClass(this.classType);
        if (!parentElement.toString().endsWith(".RealmObject")) {
            Utils.error("A RealmClass annotated object must be derived from RealmObject", this.classType);
            return false;
        }
        PackageElement packageElement = (PackageElement)enclosingElement;
        this.packageName = packageElement.getQualifiedName().toString();
        if (!this.categorizeClassElements()) {
            return false;
        }
        if (!this.checkListTypes()) {
            return false;
        }
        if (!this.checkMethods()) {
            return false;
        }
        if (!this.checkDefaultConstructor()) {
            return false;
        }
        if (!this.checkRequiredGetters()) {
            return false;
        }
        return this.checkRequireSetters();
    }

    private boolean checkMethods() {
        for (ExecutableElement executableElement : this.methods) {
            String methodName = executableElement.getSimpleName().toString();
            Set<Modifier> modifiers = executableElement.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC)) continue;
            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                Utils.error("The methods of the model must be public", executableElement);
                return false;
            }
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                if (this.checkGetterMethod(methodName)) continue;
                Utils.error(String.format("Getter %s is not associated to any field", methodName), executableElement);
                return false;
            }
            if (methodName.startsWith("set")) {
                if (this.checkSetterMethod(methodName)) continue;
                Utils.error(String.format("Setter %s is not associated to any field", methodName), executableElement);
                return false;
            }
            Utils.error("Only getters and setters should be defined in model classes", executableElement);
            return false;
        }
        return true;
    }

    private boolean checkListTypes() {
        for (VariableElement field : this.fields) {
            if (!this.typeUtils.isAssignable(field.asType(), this.realmList) || Utils.getGenericType(field) != null) continue;
            Utils.error("No generic type supplied for field", field);
            return false;
        }
        return true;
    }

    private boolean checkSetterMethod(String methodName) {
        boolean found = false;
        String methodMinusSet = methodName.substring(3);
        String methodMinusSetCapitalised = Utils.lowerFirstChar(methodMinusSet);
        String methodMenusSetPlusIs = "is" + methodMinusSet;
        if (this.fieldNames.contains(methodMinusSet)) {
            this.expectedSetters.remove(methodMinusSet);
            if (!this.ignoreFieldNames.contains(methodMinusSet)) {
                this.setters.put(methodMinusSet, methodName);
            }
            found = true;
        } else if (this.fieldNames.contains(methodMinusSetCapitalised)) {
            this.expectedSetters.remove(methodMinusSetCapitalised);
            if (!this.ignoreFieldNames.contains(methodMinusSetCapitalised)) {
                this.setters.put(methodMinusSetCapitalised, methodName);
            }
            found = true;
        } else if (this.fieldNames.contains(methodMenusSetPlusIs)) {
            this.expectedSetters.remove(methodMenusSetPlusIs);
            if (!this.ignoreFieldNames.contains(methodMenusSetPlusIs)) {
                this.setters.put(methodMenusSetPlusIs, methodName);
            }
            found = true;
        }
        return found;
    }

    private boolean checkGetterMethod(String methodName) {
        boolean found = false;
        if (methodName.startsWith("is")) {
            String methodMinusIs = methodName.substring(2);
            String methodMinusIsCapitalised = Utils.lowerFirstChar(methodMinusIs);
            if (this.fieldNames.contains(methodName)) {
                this.expectedGetters.remove(methodName);
                if (!this.ignoreFieldNames.contains(methodName)) {
                    this.getters.put(methodName, methodName);
                }
                found = true;
            } else if (this.fieldNames.contains(methodMinusIs)) {
                this.expectedGetters.remove(methodMinusIs);
                if (!this.ignoreFieldNames.contains(methodMinusIs)) {
                    this.getters.put(methodMinusIs, methodName);
                }
                found = true;
            } else if (this.fieldNames.contains(methodMinusIsCapitalised)) {
                this.expectedGetters.remove(methodMinusIsCapitalised);
                if (!this.ignoreFieldNames.contains(methodMinusIsCapitalised)) {
                    this.getters.put(methodMinusIsCapitalised, methodName);
                }
                found = true;
            }
        }
        if (!found && methodName.startsWith("get")) {
            String methodMinusGet = methodName.substring(3);
            String methodMinusGetCapitalised = Utils.lowerFirstChar(methodMinusGet);
            if (this.fieldNames.contains(methodMinusGet)) {
                this.expectedGetters.remove(methodMinusGet);
                if (!this.ignoreFieldNames.contains(methodMinusGet)) {
                    this.getters.put(methodMinusGet, methodName);
                }
                found = true;
            } else if (this.fieldNames.contains(methodMinusGetCapitalised)) {
                this.expectedGetters.remove(methodMinusGetCapitalised);
                if (!this.ignoreFieldNames.contains(methodMinusGetCapitalised)) {
                    this.getters.put(methodMinusGetCapitalised, methodName);
                }
                found = true;
            }
        }
        return found;
    }

    private boolean checkRequireSetters() {
        for (String expectedSetter : this.expectedSetters) {
            Utils.error("No setter found for field " + expectedSetter);
        }
        return this.expectedSetters.size() == 0;
    }

    private boolean checkRequiredGetters() {
        for (String expectedGetter : this.expectedGetters) {
            Utils.error("No getter found for field " + expectedGetter);
        }
        return this.expectedGetters.size() == 0;
    }

    private boolean checkDefaultConstructor() {
        if (!this.hasDefaultConstructor) {
            Utils.error("A default public constructor with no argument must be declared if a custom constructor is declared.");
            return false;
        }
        return true;
    }

    private boolean categorizeClassElements() {
        for (Element element : this.classType.getEnclosedElements()) {
            ElementKind elementKind = element.getKind();
            if (elementKind.equals((Object)ElementKind.FIELD)) {
                VariableElement variableElement = (VariableElement)element;
                String fieldName = variableElement.getSimpleName().toString();
                Set<Modifier> modifiers = variableElement.getModifiers();
                if (modifiers.contains((Object)Modifier.STATIC)) continue;
                if (variableElement.getAnnotation(Ignore.class) != null) {
                    String ignoredFieldName = variableElement.getSimpleName().toString();
                    this.fieldNames.add(ignoredFieldName);
                    this.ignoreFieldNames.add(ignoredFieldName);
                    continue;
                }
                if (variableElement.getAnnotation(Index.class) != null) {
                    String elementTypeCanonicalName = variableElement.asType().toString();
                    String columnType = Constants.JAVA_TO_COLUMN_TYPES.get(elementTypeCanonicalName);
                    if (columnType != null && (columnType.equals("ColumnType.STRING") || columnType.equals("ColumnType.DATE") || columnType.equals("ColumnType.INTEGER") || columnType.equals("ColumnType.BOOLEAN"))) {
                        this.indexedFields.add(variableElement);
                    } else {
                        Utils.error("@Index is not applicable to this field " + element + ".");
                        return false;
                    }
                }
                if (variableElement.getAnnotation(PrimaryKey.class) != null) {
                    if (this.primaryKey != null) {
                        Utils.error(String.format("@PrimaryKey cannot be defined more than once. It was found here \"%s\" and here \"%s\"", this.primaryKey.getSimpleName().toString(), variableElement.getSimpleName().toString()));
                        return false;
                    }
                    TypeMirror fieldType = variableElement.asType();
                    if (!this.isValidPrimaryKeyType(fieldType)) {
                        Utils.error("\"" + variableElement.getSimpleName().toString() + "\" is not allowed as primary key. See @PrimaryKey for allowed types.");
                        return false;
                    }
                    this.primaryKey = variableElement;
                    if (!this.indexedFields.contains(variableElement)) {
                        this.indexedFields.add(variableElement);
                    }
                }
                if (!variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    Utils.error("The fields of the model must be private", variableElement);
                    return false;
                }
                this.fields.add(variableElement);
                this.expectedGetters.add(fieldName);
                this.expectedSetters.add(fieldName);
                continue;
            }
            if (elementKind.equals((Object)ElementKind.CONSTRUCTOR)) {
                this.hasDefaultConstructor = this.hasDefaultConstructor || Utils.isDefaultConstructor(element);
                continue;
            }
            if (!elementKind.equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            this.methods.add(executableElement);
        }
        for (VariableElement variableElement : this.fields) {
            this.fieldNames.add(variableElement.getSimpleName().toString());
        }
        if (this.fields.size() == 0) {
            Utils.error(this.className + " must contain at least 1 persistable field");
        }
        return true;
    }

    public String getSimpleClassName() {
        return this.className;
    }

    public boolean isModelClass() {
        String type = this.classType.toString();
        if (type.equals("io.realm.dynamic.DynamicRealmObject")) {
            return false;
        }
        return !type.endsWith(".RealmObject") && !type.endsWith("RealmProxy");
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public List<VariableElement> getFields() {
        return this.fields;
    }

    public String getGetter(String fieldName) {
        return this.getters.get(fieldName);
    }

    public String getSetter(String fieldName) {
        return this.setters.get(fieldName);
    }

    public List<VariableElement> getIndexedFields() {
        return this.indexedFields;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public VariableElement getPrimaryKey() {
        return this.primaryKey;
    }

    public String getPrimaryKeyGetter() {
        return this.getters.get(this.primaryKey.getSimpleName().toString());
    }

    private boolean isValidPrimaryKeyType(TypeMirror type) {
        for (TypeMirror validType : this.validPrimaryKeyTypes) {
            if (!this.typeUtils.isAssignable(type, validType)) continue;
            return true;
        }
        return false;
    }
}

