/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Mixed;
import java.nio.ByteBuffer;
import java.util.Date;

public enum ColumnType {
    BOOLEAN(1),
    INTEGER(0),
    FLOAT(9),
    DOUBLE(10),
    STRING(2),
    BINARY(4),
    DATE(7),
    TABLE(5),
    MIXED(6),
    LINK(12),
    LINK_LIST(13);

    private final int nativeValue;
    private static ColumnType[] byNativeValue;

    private ColumnType(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getValue() {
        return this.nativeValue;
    }

    public boolean matchObject(Object obj) {
        switch (this.nativeValue) {
            case 0: {
                return obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte;
            }
            case 1: {
                return obj instanceof Boolean;
            }
            case 2: {
                return obj instanceof String;
            }
            case 4: {
                return obj instanceof byte[] || obj instanceof ByteBuffer;
            }
            case 5: {
                return obj == null || obj instanceof Object[][];
            }
            case 6: {
                return obj instanceof Mixed || obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof Boolean || obj instanceof Float || obj instanceof Double || obj instanceof String || obj instanceof byte[] || obj instanceof ByteBuffer || obj == null || obj instanceof Object[][] || obj instanceof Date;
            }
            case 7: {
                return obj instanceof Date;
            }
            case 9: {
                return obj instanceof Float;
            }
            case 10: {
                return obj instanceof Double;
            }
        }
        throw new RuntimeException(String.format("Invalid index (%d) in ColumnType.", this.nativeValue));
    }

    static ColumnType fromNativeValue(int value) {
        ColumnType e;
        if (0 <= value && value < byNativeValue.length && (e = byNativeValue[value]) != null) {
            return e;
        }
        throw new IllegalArgumentException("Invalid native column type");
    }

    static {
        byNativeValue = new ColumnType[14];
        ColumnType[] columnTypes = ColumnType.values();
        for (int i = 0; i < columnTypes.length; ++i) {
            int v = columnTypes[i].nativeValue;
            ColumnType.byNativeValue[v] = columnTypes[i];
        }
    }
}

