/*
 * Decompiled with CFR 0.152.
 */
package io.realm.dynamic;

import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.dynamic.DynamicRealmList;
import io.realm.internal.CheckedRow;
import io.realm.internal.ColumnType;
import io.realm.internal.InvalidRow;
import io.realm.internal.LinkView;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import java.util.Date;

public class DynamicRealmObject
extends RealmObject {
    Realm realm;
    Row row;

    public DynamicRealmObject(RealmObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Non-null object must be provided.");
        }
        Row row = RealmObject.getRow(obj);
        if (row == null) {
            throw new IllegalArgumentException("A object managed by Realm must be provided. This is a standalone object.");
        }
        this.realm = RealmObject.getRealm(obj);
        this.row = row instanceof CheckedRow ? (CheckedRow)row : ((UncheckedRow)row).convertToChecked();
    }

    DynamicRealmObject(Realm realm, CheckedRow row) {
        this.realm = realm;
        this.row = row;
    }

    public boolean getBoolean(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getBoolean(columnIndex);
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getLong(columnIndex);
    }

    public byte getByte(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return (byte)this.row.getLong(columnIndex);
    }

    public float getFloat(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getFloat(columnIndex);
    }

    public double getDouble(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getDouble(columnIndex);
    }

    public byte[] getBlob(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getBinaryByteArray(columnIndex);
    }

    public String getString(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getString(columnIndex);
    }

    public Date getDate(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return this.row.getDate(columnIndex);
    }

    public DynamicRealmObject getObject(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (this.row.isNullLink(columnIndex)) {
            return null;
        }
        long linkRowIndex = this.row.getLink(columnIndex);
        CheckedRow linkRow = this.row.getTable().getCheckedRow(linkRowIndex);
        return new DynamicRealmObject(this.realm, linkRow);
    }

    public DynamicRealmList getList(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        return new DynamicRealmList(this.row.getLinkList(columnIndex), this.realm);
    }

    public boolean isNull(String fieldName) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        ColumnType type = this.row.getColumnType(columnIndex);
        switch (type) {
            case LINK: 
            case LINK_LIST: {
                return this.row.isNullLink(columnIndex);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.row.hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        String[] keys = new String[(int)this.row.getColumnCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.row.getColumnName(i);
        }
        return keys;
    }

    public void setBoolean(String fieldName, boolean value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setBoolean(columnIndex, value);
    }

    public void setShort(String fieldName, short value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setInt(String fieldName, int value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setLong(String fieldName, long value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setByte(String fieldName, byte value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setLong(columnIndex, value);
    }

    public void setFloat(String fieldName, float value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setFloat(columnIndex, value);
    }

    public void setDouble(String fieldName, double value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setDouble(columnIndex, value);
    }

    public void setString(String fieldName, String value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setString(columnIndex, value);
    }

    public void setBlob(String fieldName, byte[] value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setBinaryByteArray(columnIndex, value);
    }

    public void setDate(String fieldName, Date value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        this.row.setDate(columnIndex, value);
    }

    public void setObject(String fieldName, DynamicRealmObject value) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        if (value == null) {
            this.row.nullifyLink(columnIndex);
        } else {
            Table inputTable;
            if (value.realm == null || value.row == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (!this.realm.getConfiguration().equals(value.realm.getConfiguration())) {
                throw new IllegalArgumentException("Cannot add an object from another Realm");
            }
            Table table = this.row.getTable();
            if (!table.hasSameSchema(inputTable = value.row.getTable())) {
                throw new IllegalArgumentException(String.format("Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.row.setLink(columnIndex, value.row.getIndex());
        }
    }

    public void setList(String fieldName, DynamicRealmList list) {
        long columnIndex = this.row.getColumnIndex(fieldName);
        LinkView links = this.row.getLinkList(columnIndex);
        links.clear();
        for (DynamicRealmObject obj : list) {
            links.add(obj.row.getIndex());
        }
    }

    @Override
    public void removeFromRealm() {
        this.row.getTable().moveLastOver(this.row.getIndex());
        this.row = InvalidRow.INSTANCE;
    }

    public String getType() {
        return this.row.getTable().getName().substring("class_".length());
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.realm.getPath();
        String otherPath = other.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = other.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == other.row.getIndex();
    }

    public String toString() {
        String[] fields;
        if (this.row == null || !this.row.isAttached()) {
            return "Invalid object";
        }
        StringBuilder sb = new StringBuilder(this.row.getTable().getName() + " = [");
        for (String field : fields = this.getFieldNames()) {
            long columnIndex = this.row.getColumnIndex(field);
            ColumnType type = this.row.getColumnType(columnIndex);
            sb.append("{");
            switch (type) {
                case BOOLEAN: {
                    sb.append(field + ": " + this.row.getBoolean(columnIndex));
                    break;
                }
                case INTEGER: {
                    sb.append(field + ": " + this.row.getLong(columnIndex));
                    break;
                }
                case FLOAT: {
                    sb.append(field + ": " + this.row.getFloat(columnIndex));
                    break;
                }
                case DOUBLE: {
                    sb.append(field + ": " + this.row.getDouble(columnIndex));
                    break;
                }
                case STRING: {
                    sb.append(field + ": " + this.row.getString(columnIndex));
                    break;
                }
                case BINARY: {
                    sb.append(field + ": " + this.row.getBinaryByteArray(columnIndex));
                    break;
                }
                case DATE: {
                    sb.append(field + ": " + this.row.getDate(columnIndex));
                    break;
                }
                case LINK: {
                    if (this.row.isNullLink(columnIndex)) {
                        sb.append("null");
                        break;
                    }
                    sb.append(field + ": " + this.row.getTable().getLinkTarget(columnIndex).getName());
                    break;
                }
                case LINK_LIST: {
                    String targetType = this.row.getTable().getLinkTarget(columnIndex).getName();
                    sb.append(String.format("%s: RealmList<%s>[%s]", field, targetType, this.row.getLinkList(columnIndex).size()));
                    break;
                }
                default: {
                    sb.append(field + ": ?");
                }
            }
            sb.append("}, ");
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }
}

