/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Utils {
    public static Types typeUtils;
    private static Messager messager;
    private static DeclaredType realmList;

    public static void initialize(ProcessingEnvironment env) {
        typeUtils = env.getTypeUtils();
        messager = env.getMessager();
        realmList = typeUtils.getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmList"), typeUtils.getWildcardType(null, null));
    }

    public static boolean isDefaultConstructor(Element constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return ((ExecutableElement)constructor).getParameters().isEmpty();
        }
        return false;
    }

    public static String lowerFirstChar(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String getProxyClassSimpleName(VariableElement field) {
        if (typeUtils.isAssignable(field.asType(), realmList)) {
            return Utils.getProxyClassName(Utils.getGenericType(field));
        }
        return Utils.getProxyClassName(Utils.getFieldTypeSimpleName(field));
    }

    public static String getProxyClassName(String clazz) {
        return clazz + "RealmProxy";
    }

    public static boolean isString(VariableElement field) {
        if (field == null) {
            return false;
        }
        return Utils.getFieldTypeSimpleName(field).equals("String");
    }

    public static String getFieldTypeSimpleName(VariableElement field) {
        String fieldTypeCanonicalName = field.asType().toString();
        String fieldTypeName = fieldTypeCanonicalName.contains(".") ? fieldTypeCanonicalName.substring(fieldTypeCanonicalName.lastIndexOf(46) + 1) : fieldTypeCanonicalName;
        return fieldTypeName;
    }

    public static String getGenericType(VariableElement field) {
        TypeMirror fieldType = field.asType();
        List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
        if (typeArguments.size() == 0) {
            return null;
        }
        String genericCanonicalType = typeArguments.get(0).toString();
        String genericType = genericCanonicalType.contains(".") ? genericCanonicalType.substring(genericCanonicalType.lastIndexOf(46) + 1) : genericCanonicalType;
        return genericType;
    }

    public static String stripPackage(String fullyQualifiedClassName) {
        String[] parts = fullyQualifiedClassName.split("\\.");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return fullyQualifiedClassName;
    }

    public static void error(String message, Element element) {
        messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static void error(String message) {
        messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    public static void note(String message) {
        messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public static Element getSuperClass(TypeElement classType) {
        return typeUtils.asElement(classType.getSuperclass());
    }
}

