/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.modules;

import android.util.JsonReader;
import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterableMediator
extends RealmProxyMediator {
    private RealmProxyMediator originalMediator;
    private Set<Class<? extends RealmObject>> allowedClasses = new HashSet<Class<? extends RealmObject>>();

    public FilterableMediator(RealmProxyMediator originalMediator, Collection<Class<? extends RealmObject>> allowedClasses) {
        this.originalMediator = originalMediator;
        if (originalMediator != null) {
            List<Class<? extends RealmObject>> originalClasses = originalMediator.getModelClasses();
            for (Class<? extends RealmObject> clazz : allowedClasses) {
                if (!originalClasses.contains(clazz)) continue;
                this.allowedClasses.add(clazz);
            }
        }
    }

    public RealmProxyMediator getOriginalMediator() {
        return this.originalMediator;
    }

    @Override
    public Table createTable(Class<? extends RealmObject> clazz, ImplicitTransaction transaction) {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.createTable(clazz, transaction);
    }

    @Override
    public void validateTable(Class<? extends RealmObject> clazz, ImplicitTransaction transaction) {
        this.checkSchemaHasClass(clazz);
        this.originalMediator.validateTable(clazz, transaction);
    }

    @Override
    public List<String> getFieldNames(Class<? extends RealmObject> clazz) {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.getFieldNames(clazz);
    }

    @Override
    public String getTableName(Class<? extends RealmObject> clazz) {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.getTableName(clazz);
    }

    @Override
    public <E extends RealmObject> E newInstance(Class<E> clazz) {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.newInstance(clazz);
    }

    @Override
    public List<Class<? extends RealmObject>> getModelClasses() {
        return new ArrayList<Class<? extends RealmObject>>(this.allowedClasses);
    }

    @Override
    public Map<String, Long> getColumnIndices(Class<? extends RealmObject> clazz) {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.getColumnIndices(clazz);
    }

    @Override
    public <E extends RealmObject> E copyOrUpdate(Realm realm, E object, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        this.checkSchemaHasClass(Util.getOriginalModelClass(object.getClass()));
        return this.originalMediator.copyOrUpdate(realm, object, update, cache);
    }

    @Override
    public <E extends RealmObject> E createOrUpdateUsingJsonObject(Class<E> clazz, Realm realm, JSONObject json, boolean update) throws JSONException {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.createOrUpdateUsingJsonObject(clazz, realm, json, update);
    }

    @Override
    public <E extends RealmObject> E createUsingJsonStream(Class<E> clazz, Realm realm, JsonReader reader) throws IOException {
        this.checkSchemaHasClass(clazz);
        return this.originalMediator.createUsingJsonStream(clazz, realm, reader);
    }

    private void checkSchemaHasClass(Class<? extends RealmObject> clazz) {
        if (!this.allowedClasses.contains(clazz)) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " is not part of the schema for this Realm");
        }
    }
}

