/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.CheckedRow;
import io.realm.internal.Context;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;

public class LinkView {
    private final Context context;
    final long nativeLinkViewPtr;
    final Table parent;
    final long columnIndexInParent;

    public LinkView(Context context, Table parent, long columnIndexInParent, long nativeLinkViewPtr) {
        this.context = context;
        this.parent = parent;
        this.columnIndexInParent = columnIndexInParent;
        this.nativeLinkViewPtr = nativeLinkViewPtr;
    }

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.get(this.context, this, index);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    public long getTargetRowIndex(long pos) {
        return this.nativeGetTargetRowIndex(this.nativeLinkViewPtr, pos);
    }

    public void add(long rowIndex) {
        this.checkImmutable();
        this.nativeAdd(this.nativeLinkViewPtr, rowIndex);
    }

    public void insert(long pos, long rowIndex) {
        this.checkImmutable();
        this.nativeInsert(this.nativeLinkViewPtr, pos, rowIndex);
    }

    public void set(long pos, long rowIndex) {
        this.checkImmutable();
        this.nativeSet(this.nativeLinkViewPtr, pos, rowIndex);
    }

    public void move(long oldPos, long newPos) {
        this.checkImmutable();
        this.nativeMove(this.nativeLinkViewPtr, oldPos, newPos);
    }

    public void remove(long pos) {
        this.checkImmutable();
        this.nativeRemove(this.nativeLinkViewPtr, pos);
    }

    public void clear() {
        this.checkImmutable();
        this.nativeClear(this.nativeLinkViewPtr);
    }

    public long size() {
        return this.nativeSize(this.nativeLinkViewPtr);
    }

    public boolean isEmpty() {
        return this.nativeIsEmpty(this.nativeLinkViewPtr);
    }

    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativeLinkViewPtr);
        try {
            return new TableQuery(this.context, this.parent, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    public Table getTable() {
        return this.parent;
    }

    private void checkImmutable() {
        if (this.parent.isImmutable()) {
            throw new IllegalStateException("Changing Realm data can only be done from inside a transaction.");
        }
    }

    protected static native void nativeClose(long var0);

    native long nativeGetRow(long var1, long var3);

    private native long nativeGetTargetRowIndex(long var1, long var3);

    private native void nativeAdd(long var1, long var3);

    private native void nativeInsert(long var1, long var3, long var5);

    private native void nativeSet(long var1, long var3, long var5);

    private native void nativeMove(long var1, long var3, long var5);

    private native void nativeRemove(long var1, long var3);

    private native void nativeClear(long var1);

    private native long nativeSize(long var1);

    private native boolean nativeIsEmpty(long var1);

    protected native long nativeWhere(long var1);
}

