/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.OutOfMemoryError;
import io.realm.internal.RealmCore;
import io.realm.internal.Table;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Group
implements Closeable {
    protected long nativePtr;
    protected boolean immutable;
    private final Context context;

    private void checkNativePtrNotZero() {
        if (this.nativePtr == 0L) {
            throw new OutOfMemoryError("Out of native memory.");
        }
    }

    public Group() {
        this.immutable = false;
        this.context = new Context();
        this.nativePtr = this.createNative();
        this.checkNativePtrNotZero();
    }

    protected native long createNative();

    public Group(String filepath, OpenMode mode) {
        this.immutable = mode.equals((Object)OpenMode.READ_ONLY);
        this.context = new Context();
        this.nativePtr = this.createNative(filepath, mode.value);
        this.checkNativePtrNotZero();
    }

    protected native long createNative(String var1, int var2);

    public Group(String filepath) {
        this(filepath, OpenMode.READ_ONLY);
    }

    public Group(File file) {
        this(file.getAbsolutePath(), file.canWrite() ? OpenMode.READ_WRITE : OpenMode.READ_ONLY);
    }

    public Group(byte[] data) {
        this.immutable = false;
        this.context = new Context();
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.nativePtr = this.createNative(data);
        this.checkNativePtrNotZero();
    }

    protected native long createNative(byte[] var1);

    public Group(ByteBuffer buffer) {
        this.immutable = false;
        this.context = new Context();
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.nativePtr = this.createNative(buffer);
        this.checkNativePtrNotZero();
    }

    protected native long createNative(ByteBuffer var1);

    Group(Context context, long nativePointer, boolean immutable) {
        this.context = context;
        this.nativePtr = nativePointer;
        this.immutable = immutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                Group.nativeClose(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    protected static native void nativeClose(long var0);

    boolean isClosed() {
        return this.nativePtr == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeGroup(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    private void verifyGroupIsValid() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Illegal to call methods on a closed Group.");
        }
    }

    public long size() {
        this.verifyGroupIsValid();
        return this.nativeSize(this.nativePtr);
    }

    protected native long nativeSize(long var1);

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean hasTable(String name) {
        this.verifyGroupIsValid();
        return name != null && this.nativeHasTable(this.nativePtr, name);
    }

    protected native boolean nativeHasTable(long var1, String var3);

    public String getTableName(int index) {
        this.verifyGroupIsValid();
        long cnt = this.size();
        if (index < 0 || (long)index >= cnt) {
            throw new IndexOutOfBoundsException("Table index argument is out of range. possible range is [0, " + (cnt - 1L) + "]");
        }
        return this.nativeGetTableName(this.nativePtr, index);
    }

    protected native String nativeGetTableName(long var1, int var3);

    public Table getTable(String name) {
        this.verifyGroupIsValid();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name. Name must be a non-empty String.");
        }
        if (this.immutable && !this.hasTable(name)) {
            throw new IllegalStateException("Requested table is not in this Realm. Creating it requires a transaction: " + name);
        }
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetTableNativePtr(this.nativePtr, name);
        try {
            return new Table(this.context, this, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    protected native long nativeGetTableNativePtr(long var1, String var3);

    protected native void nativeWriteToFile(long var1, String var3, byte[] var4) throws IOException;

    public void writeToFile(File file, byte[] key) throws IOException {
        this.verifyGroupIsValid();
        if (file.isFile() && file.exists()) {
            throw new IllegalArgumentException("The destination file must not exist");
        }
        if (key != null && key.length != 64) {
            throw new IllegalArgumentException("Realm AES keys must be 64 bytes long");
        }
        this.nativeWriteToFile(this.nativePtr, file.getAbsolutePath(), key);
    }

    protected static native long nativeLoadFromMem(byte[] var0);

    public byte[] writeToMem() {
        this.verifyGroupIsValid();
        return this.nativeWriteToMem(this.nativePtr);
    }

    protected native byte[] nativeWriteToMem(long var1);

    public void commit() {
        this.verifyGroupIsValid();
        this.nativeCommit(this.nativePtr);
    }

    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    protected native String nativeToJson(long var1);

    public String toString() {
        return this.nativeToString(this.nativePtr);
    }

    protected native void nativeCommit(long var1);

    protected native String nativeToString(long var1);

    private void throwImmutable() {
        throw new IllegalStateException("Objects cannot be changed outside a transaction; see beginTransaction() for details.");
    }

    static {
        RealmCore.loadLibrary();
    }

    public static enum OpenMode {
        READ_ONLY(0),
        READ_WRITE(1),
        READ_WRITE_NO_CREATE(2);

        private int value;

        private OpenMode(int value) {
            this.value = value;
        }
    }
}

