/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.TableOrView;
import io.realm.internal.TableView;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;

public class RealmResults<E extends RealmObject>
extends AbstractList<E> {
    private Class<E> classSpec;
    private Realm realm;
    private TableOrView table = null;
    public static final boolean SORT_ORDER_ASCENDING = true;
    public static final boolean SORT_ORDER_DESCENDING = false;
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    private long currentTableViewVersion = -1L;

    RealmResults(Realm realm, Class<E> classSpec) {
        this.realm = realm;
        this.classSpec = classSpec;
    }

    RealmResults(Realm realm, TableOrView table, Class<E> classSpec) {
        this(realm, classSpec);
        this.table = table;
    }

    Realm getRealm() {
        return this.realm;
    }

    TableOrView getTable() {
        if (this.table == null) {
            return this.realm.getTable(this.classSpec);
        }
        return this.table;
    }

    public RealmQuery<E> where() {
        this.realm.checkIfValid();
        return new RealmQuery<E>(this, this.classSpec);
    }

    @Override
    public E get(int rowIndex) {
        this.realm.checkIfValid();
        TableOrView table = this.getTable();
        E obj = table instanceof TableView ? this.realm.get(this.classSpec, ((TableView)table).getSourceRowIndex(rowIndex)) : this.realm.get(this.classSpec, rowIndex);
        return obj;
    }

    @Override
    public int indexOf(Object o) {
        throw new NoSuchMethodError("indexOf is not supported on RealmResults");
    }

    public E first() {
        return (E)this.get(0);
    }

    public E last() {
        return (E)this.get(this.size() - 1);
    }

    @Override
    public Iterator<E> iterator() {
        return new RealmResultsIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new RealmResultsListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new RealmResultsListIterator(location);
    }

    private long getColumnIndex(String fieldName) {
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Sorting using child object properties is not supported: " + fieldName);
        }
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist.", fieldName));
        }
        return columnIndex;
    }

    public void sort(String fieldName) {
        this.sort(fieldName, true);
    }

    public void sort(String fieldName, boolean sortAscending) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must be provided");
        }
        this.realm.checkIfValid();
        TableOrView table = this.getTable();
        if (!(table instanceof TableView)) {
            throw new IllegalArgumentException("Only RealmResults can be sorted - please use allObject() to create a RealmResults.");
        }
        long columnIndex = this.getColumnIndex(fieldName);
        TableView.Order TVOrder = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        ((TableView)table).sort(columnIndex, TVOrder);
    }

    public void sort(String[] fieldNames, boolean[] sortAscending) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames must be provided.");
        }
        if (sortAscending == null) {
            throw new IllegalArgumentException("sortAscending must be provided.");
        }
        if (fieldNames.length == 1 && sortAscending.length == 1) {
            this.sort(fieldNames[0], sortAscending[0]);
        } else {
            this.realm.checkIfValid();
            TableOrView table = this.getTable();
            if (table instanceof TableView) {
                int i;
                ArrayList<TableView.Order> TVOrder = new ArrayList<TableView.Order>();
                ArrayList<Long> columnIndices = new ArrayList<Long>();
                for (i = 0; i < fieldNames.length; ++i) {
                    String fieldName = fieldNames[i];
                    long columnIndex = this.getColumnIndex(fieldName);
                    columnIndices.add(columnIndex);
                }
                for (i = 0; i < sortAscending.length; ++i) {
                    TVOrder.add(sortAscending[i] ? TableView.Order.ascending : TableView.Order.descending);
                }
                ((TableView)table).sort(columnIndices, TVOrder);
            }
        }
    }

    public void sort(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        this.sort(new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public void sort(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        this.sort(new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    @Override
    public int size() {
        return Long.valueOf(this.getTable().size()).intValue();
    }

    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.minimumLong(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.table.minimumFloat(columnIndex));
            }
            case DOUBLE: {
                return this.table.minimumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public Date minDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (this.table.getColumnType(columnIndex) == ColumnType.DATE) {
            return this.table.minimumDate(columnIndex);
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "Date"));
    }

    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.maximumLong(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.table.maximumFloat(columnIndex));
            }
            case DOUBLE: {
                return this.table.maximumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public Date maxDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (this.table.getColumnType(columnIndex) == ColumnType.DATE) {
            return this.table.maximumDate(columnIndex);
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "Date"));
    }

    public Number sum(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.sumLong(columnIndex);
            }
            case FLOAT: {
                return this.table.sumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.table.sumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public double average(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.table.getColumnIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.table.averageLong(columnIndex);
            }
            case DOUBLE: {
                return this.table.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.table.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Override
    public E remove(int index) {
        TableOrView table = this.getTable();
        table.remove(index);
        return null;
    }

    @Override
    public void removeLast() {
        TableOrView table = this.getTable();
        table.removeLast();
    }

    @Override
    public void clear() {
        TableOrView table = this.getTable();
        table.clear();
    }

    @Override
    @Deprecated
    public boolean add(E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    private void assertRealmIsStable() {
        long version = this.table.sync();
        if (this.currentTableViewVersion > -1L && version != this.currentTableViewVersion) {
            throw new ConcurrentModificationException("No outside changes to a Realm is allowed while iterating a RealmResults. Use iterators methods instead.");
        }
        this.currentTableViewVersion = version;
    }

    private class RealmResultsListIterator
    extends RealmResultsIterator
    implements ListIterator<E> {
        RealmResultsListIterator(int start) {
            if (start < 0 || start > RealmResults.this.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (RealmResults.this.size() - 1) + "]. Yours was " + start);
            }
            this.pos = start - 1;
        }

        @Override
        public void add(E object) {
            throw new RealmException("Adding elements not supported. Use Realm.createObject() instead.");
        }

        @Override
        public boolean hasPrevious() {
            RealmResults.this.assertRealmIsStable();
            return this.pos > 0;
        }

        @Override
        public int nextIndex() {
            RealmResults.this.assertRealmIsStable();
            return this.pos + 1;
        }

        @Override
        public E previous() {
            RealmResults.this.assertRealmIsStable();
            --this.pos;
            if (this.pos < 0) {
                throw new IndexOutOfBoundsException("Cannot access index less than zero. This was " + this.pos + ". Remember to check hasPrevious() before using previous().");
            }
            return RealmResults.this.get(this.pos);
        }

        @Override
        public int previousIndex() {
            RealmResults.this.assertRealmIsStable();
            return this.pos;
        }

        @Override
        public void set(E object) {
            throw new RealmException("Replacing elements not supported.");
        }

        @Override
        public void remove() {
            throw new RealmException("Removing elements not supported.");
        }
    }

    private class RealmResultsIterator
    implements Iterator<E> {
        int pos = -1;

        RealmResultsIterator() {
            RealmResults.this.currentTableViewVersion = RealmResults.this.table.sync();
        }

        @Override
        public boolean hasNext() {
            RealmResults.this.assertRealmIsStable();
            return this.pos + 1 < RealmResults.this.size();
        }

        @Override
        public E next() {
            RealmResults.this.assertRealmIsStable();
            ++this.pos;
            if (this.pos >= RealmResults.this.size()) {
                throw new IndexOutOfBoundsException("Cannot access index " + this.pos + " when size is " + RealmResults.this.size() + ". Remember to check hasNext() before using next().");
            }
            return RealmResults.this.get(this.pos);
        }

        @Override
        public void remove() {
            throw new RealmException("Removing is not supported.");
        }
    }
}

