/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.ClassMetaData;
import io.realm.processor.javawriter.JavaWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class RealmValidationListGenerator {
    private ProcessingEnvironment processingEnvironment;
    private Set<ClassMetaData> classesToValidate = new HashSet<ClassMetaData>();
    private static final String CLASS_NAME = "ValidationList";

    public RealmValidationListGenerator(ProcessingEnvironment processingEnvironment, Set<ClassMetaData> classesToValidate) {
        this.processingEnvironment = processingEnvironment;
        this.classesToValidate = classesToValidate;
    }

    public void generate() throws IOException {
        String qualifiedGeneratedClassName = String.format("%s.%s", "io.realm", CLASS_NAME);
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter(new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm");
        writer.emitEmptyLine();
        writer.emitImports("java.util.Arrays", "java.util.List");
        writer.emitEmptyLine();
        writer.beginType(qualifiedGeneratedClassName, "class", EnumSet.of(Modifier.PUBLIC), null, new String[0]);
        writer.emitEmptyLine();
        writer.beginMethod("List<String>", "getProxyClasses", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        ArrayList<String> entries = new ArrayList<String>();
        for (ClassMetaData classToValidate : this.classesToValidate) {
            entries.add(String.format("\"%s\"", classToValidate.getSimpleClassName()));
        }
        String statementSection = RealmValidationListGenerator.joinStringList(entries, ", ");
        writer.emitStatement("return Arrays.asList(%s)", statementSection);
        writer.endMethod();
        writer.emitEmptyLine();
        writer.endType();
        writer.close();
    }

    public static String joinStringList(List<String> strings, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<String> iterator = strings.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            String item = iterator.next();
            if (index > 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(item);
        }
        return stringBuilder.toString();
    }
}

