/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.RealmClass;
import io.realm.processor.ClassMetaData;
import io.realm.processor.RealmJSonImplGenerator;
import io.realm.processor.RealmProxyClassGenerator;
import io.realm.processor.RealmValidationListGenerator;
import io.realm.processor.RealmVersionChecker;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"io.realm.annotations.RealmClass", "io.realm.annotations.Ignore", "io.realm.annotations.Index", "io.realm.annotations.PrimaryKey"})
public class RealmProcessor
extends AbstractProcessor {
    Set<ClassMetaData> classesToValidate = new HashSet<ClassMetaData>();
    boolean done = false;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        RealmVersionChecker updateChecker = RealmVersionChecker.getInstance(this.processingEnv);
        updateChecker.executeRealmVersionUpdate();
        Utils.initialize(this.processingEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(RealmClass.class)) {
            ClassMetaData metadata;
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                Utils.error("The RealmClass annotation can only be applied to classes", element);
            }
            if (!(metadata = new ClassMetaData(this.processingEnv, (TypeElement)element)).isModelClass()) continue;
            Utils.note("Processing class " + metadata.getSimpleClassName());
            boolean success = metadata.generateMetaData(this.processingEnv.getMessager());
            if (!success) {
                this.done = true;
                return true;
            }
            this.classesToValidate.add(metadata);
            RealmProxyClassGenerator sourceCodeGenerator = new RealmProxyClassGenerator(this.processingEnv, metadata);
            try {
                sourceCodeGenerator.generate();
            }
            catch (IOException e) {
                Utils.error(e.getMessage(), element);
            }
            catch (UnsupportedOperationException e) {
                Utils.error(e.getMessage(), element);
            }
        }
        if (!this.done) {
            RealmValidationListGenerator validationGenerator = new RealmValidationListGenerator(this.processingEnv, this.classesToValidate);
            RealmJSonImplGenerator realmJSonImplGenerator = new RealmJSonImplGenerator(this.processingEnv, this.classesToValidate);
            try {
                validationGenerator.generate();
                realmJSonImplGenerator.generate();
                this.done = true;
            }
            catch (IOException e) {
                Utils.error(e.getMessage());
            }
        }
        return true;
    }
}

