/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import java.io.Closeable;
import java.util.Date;

public class TableQuery
implements Closeable {
    protected boolean DEBUG = false;
    protected long nativePtr;
    protected final Table parent;
    private final Context context;
    private boolean queryValidated = true;
    private static final String DATE_NULL_ERROR_MESSAGE = "Date value in query criteria must not be null.";
    private static final String STRING_NULL_ERROR_MESSAGE = "String value in query criteria must not be null.";

    public TableQuery(Context context, Table parent, long nativeQueryPtr) {
        if (this.DEBUG) {
            System.err.println("++++++ new TableQuery, ptr= " + nativeQueryPtr);
        }
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativeQueryPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                TableQuery.nativeClose(this.nativePtr);
                if (this.DEBUG) {
                    System.err.println("++++ Query CLOSE, ptr= " + this.nativePtr);
                }
                this.nativePtr = 0L;
            }
        }
    }

    protected static native void nativeClose(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeQuery(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
    }

    private void validateQuery() {
        if (!this.queryValidated) {
            String invalidMessage = this.nativeValidateQuery(this.nativePtr);
            if (invalidMessage.equals("")) {
                this.queryValidated = true;
            } else {
                throw new UnsupportedOperationException(invalidMessage);
            }
        }
    }

    protected native String nativeValidateQuery(long var1);

    public TableQuery tableview(TableView tv) {
        this.nativeTableview(this.nativePtr, tv.nativePtr);
        return this;
    }

    protected native void nativeTableview(long var1, long var3);

    public TableQuery group() {
        this.nativeGroup(this.nativePtr);
        return this;
    }

    protected native void nativeGroup(long var1);

    public TableQuery endGroup() {
        this.nativeEndGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEndGroup(long var1);

    public TableQuery subtable(long columnIndex) {
        this.nativeSubtable(this.nativePtr, columnIndex);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeSubtable(long var1, long var3);

    public TableQuery endSubtable() {
        this.nativeParent(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeParent(long var1);

    public TableQuery or() {
        this.nativeOr(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeOr(long var1);

    public TableQuery not() {
        this.nativeNot(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNot(long var1);

    public TableQuery equalTo(long[] columnIndexes, long value) {
        this.nativeEqual(this.nativePtr, columnIndexes, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqual(long var1, long[] var3, long var4);

    public TableQuery notEqualTo(long[] columnIndex, long value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNotEqual(long var1, long[] var3, long var4);

    public TableQuery greaterThan(long[] columnIndex, long value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreater(long var1, long[] var3, long var4);

    public TableQuery greaterThanOrEqual(long[] columnIndex, long value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreaterEqual(long var1, long[] var3, long var4);

    public TableQuery lessThan(long[] columnIndex, long value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLess(long var1, long[] var3, long var4);

    public TableQuery lessThanOrEqual(long[] columnIndex, long value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLessEqual(long var1, long[] var3, long var4);

    public TableQuery between(long[] columnIndex, long value1, long value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeBetween(long var1, long[] var3, long var4, long var6);

    public TableQuery equalTo(long[] columnIndex, float value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqual(long var1, long[] var3, float var4);

    public TableQuery notEqualTo(long[] columnIndex, float value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNotEqual(long var1, long[] var3, float var4);

    public TableQuery greaterThan(long[] columnIndex, float value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreater(long var1, long[] var3, float var4);

    public TableQuery greaterThanOrEqual(long[] columnIndex, float value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreaterEqual(long var1, long[] var3, float var4);

    public TableQuery lessThan(long[] columnIndex, float value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLess(long var1, long[] var3, float var4);

    public TableQuery lessThanOrEqual(long[] columnIndex, float value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLessEqual(long var1, long[] var3, float var4);

    public TableQuery between(long[] columnIndex, float value1, float value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeBetween(long var1, long[] var3, float var4, float var5);

    public TableQuery equalTo(long[] columnIndex, double value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqual(long var1, long[] var3, double var4);

    public TableQuery notEqualTo(long[] columnIndex, double value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNotEqual(long var1, long[] var3, double var4);

    public TableQuery greaterThan(long[] columnIndex, double value) {
        this.nativeGreater(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreater(long var1, long[] var3, double var4);

    public TableQuery greaterThanOrEqual(long[] columnIndex, double value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreaterEqual(long var1, long[] var3, double var4);

    public TableQuery lessThan(long[] columnIndex, double value) {
        this.nativeLess(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLess(long var1, long[] var3, double var4);

    public TableQuery lessThanOrEqual(long[] columnIndex, double value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLessEqual(long var1, long[] var3, double var4);

    public TableQuery between(long[] columnIndex, double value1, double value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeBetween(long var1, long[] var3, double var4, double var6);

    public TableQuery equalTo(long[] columnIndex, boolean value) {
        this.nativeEqual(this.nativePtr, columnIndex, value);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqual(long var1, long[] var3, boolean var4);

    public TableQuery equalTo(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqualDateTime(long var1, long[] var3, long var4);

    public TableQuery notEqualTo(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNotEqualDateTime(long var1, long[] var3, long var4);

    public TableQuery greaterThan(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreaterDateTime(long var1, long[] var3, long var4);

    public TableQuery greaterThanOrEqual(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeGreaterEqualDateTime(long var1, long[] var3, long var4);

    public TableQuery lessThan(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLessDateTime(long var1, long[] var3, long var4);

    public TableQuery lessThanOrEqual(long[] columnIndex, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessEqualDateTime(this.nativePtr, columnIndex, value.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeLessEqualDateTime(long var1, long[] var3, long var4);

    public TableQuery between(long[] columnIndex, Date value1, Date value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Date values in query criteria must not be null.");
        }
        this.nativeBetweenDateTime(this.nativePtr, columnIndex, value1.getTime() / 1000L, value2.getTime() / 1000L);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeBetweenDateTime(long var1, long[] var3, long var4, long var6);

    public TableQuery equalTo(long[] columnIndexes, String value, boolean caseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeEqual(this.nativePtr, columnIndexes, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, String value) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeEqual(this.nativePtr, columnIndexes, value, true);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEqual(long var1, long[] var3, String var4, boolean var5);

    public TableQuery notEqualTo(long[] columnIndex, String value, boolean caseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqual(this.nativePtr, columnIndex, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, String value) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqual(this.nativePtr, columnIndex, value, true);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeNotEqual(long var1, long[] var3, String var4, boolean var5);

    public TableQuery beginsWith(long[] columnIndices, String value, boolean caseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeBeginsWith(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnIndices, String value) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeBeginsWith(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeBeginsWith(long var1, long[] var3, String var4, boolean var5);

    public TableQuery endsWith(long[] columnIndices, String value, boolean caseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeEndsWith(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnIndices, String value) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeEndsWith(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeEndsWith(long var1, long[] var3, String var4, boolean var5);

    public TableQuery contains(long[] columnIndices, String value, boolean caseSensitive) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeContains(this.nativePtr, columnIndices, value, caseSensitive);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnIndices, String value) {
        if (value == null) {
            throw new IllegalArgumentException(STRING_NULL_ERROR_MESSAGE);
        }
        this.nativeContains(this.nativePtr, columnIndices, value, true);
        this.queryValidated = false;
        return this;
    }

    protected native void nativeContains(long var1, long[] var3, String var4, boolean var5);

    public long find(long fromTableRow) {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, fromTableRow);
    }

    public long find() {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, 0L);
    }

    protected native long nativeFind(long var1, long var3);

    public TableView findAll(long start, long end, long limit) {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAll(this.nativePtr, start, end, limit);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public TableView findAll() {
        this.validateQuery();
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAll(this.nativePtr, 0L, -1L, -1L);
        try {
            return new TableView(this.context, this.parent, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAll(long var1, long var3, long var5, long var7);

    public long sumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public long sumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native long nativeSumInt(long var1, long var3, long var5, long var7, long var9);

    public long maximumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public long maximumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native long nativeMaximumInt(long var1, long var3, long var5, long var7, long var9);

    public long minimumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public long minimumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native long nativeMinimumInt(long var1, long var3, long var5, long var7, long var9);

    public double averageInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageInt(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeAverageInt(long var1, long var3, long var5, long var7, long var9);

    public double sumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeSumFloat(long var1, long var3, long var5, long var7, long var9);

    public float maximumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public float maximumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native float nativeMaximumFloat(long var1, long var3, long var5, long var7, long var9);

    public float minimumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public float minimumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native float nativeMinimumFloat(long var1, long var3, long var5, long var7, long var9);

    public double averageFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeAverageFloat(long var1, long var3, long var5, long var7, long var9);

    public double sumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeSumDouble(long var1, long var3, long var5, long var7, long var9);

    public double maximumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double maximumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeMaximumDouble(long var1, long var3, long var5, long var7, long var9);

    public double minimumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double minimumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeMinimumDouble(long var1, long var3, long var5, long var7, long var9);

    public double averageDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    protected native double nativeAverageDouble(long var1, long var3, long var5, long var7, long var9);

    public Date maximumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return new Date(this.nativeMaximumDate(this.nativePtr, columnIndex, start, end, limit) * 1000L);
    }

    public Date maximumDate(long columnIndex) {
        this.validateQuery();
        return new Date(this.nativeMaximumDate(this.nativePtr, columnIndex, 0L, -1L, -1L) * 1000L);
    }

    protected native long nativeMaximumDate(long var1, long var3, long var5, long var7, long var9);

    public Date minimumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return new Date(this.nativeMinimumDate(this.nativePtr, columnIndex, start, end, limit) * 1000L);
    }

    public Date minimumDate(long columnIndex) {
        this.validateQuery();
        return new Date(this.nativeMinimumDate(this.nativePtr, columnIndex, 0L, -1L, -1L) * 1000L);
    }

    protected native long nativeMinimumDate(long var1, long var3, long var5, long var7, long var9);

    public TableQuery isNull(long columnIndex) {
        this.nativeIsNull(this.nativePtr, columnIndex);
        return this;
    }

    protected native void nativeIsNull(long var1, long var3);

    public long count(long start, long end, long limit) {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, start, end, limit);
    }

    public long count() {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, 0L, -1L, -1L);
    }

    protected native long nativeCount(long var1, long var3, long var5, long var7);

    public long remove(long start, long end) {
        this.validateQuery();
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr, start, end, -1L);
    }

    public long remove() {
        this.validateQuery();
        if (this.parent.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr, 0L, -1L, -1L);
    }

    protected native long nativeRemove(long var1, long var3, long var5, long var7);

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }
}

