/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.ColumnType;
import io.realm.internal.Context;
import io.realm.internal.LinkView;
import io.realm.internal.Mixed;
import io.realm.internal.Table;
import java.util.Date;

public class Row {
    private final Context context;
    private final Table parent;
    protected long nativePtr;

    Row(Context context, Table parent, long nativePtr) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePtr;
    }

    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    protected native long nativeGetColumnCount(long var1);

    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    protected native String nativeGetColumnName(long var1, long var3);

    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    protected native long nativeGetColumnIndex(long var1, String var3);

    public ColumnType getColumnType(long columnIndex) {
        return ColumnType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    protected native int nativeGetColumnType(long var1, long var3);

    public Table getTable() {
        return this.parent;
    }

    public long getIndex() {
        return this.nativeGetIndex(this.nativePtr);
    }

    protected native long nativeGetIndex(long var1);

    public long getLong(long columnIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex);
    }

    protected native long nativeGetLong(long var1, long var3);

    public boolean getBoolean(long columnIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex);
    }

    protected native boolean nativeGetBoolean(long var1, long var3);

    public float getFloat(long columnIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex);
    }

    protected native float nativeGetFloat(long var1, long var3);

    public double getDouble(long columnIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex);
    }

    protected native double nativeGetDouble(long var1, long var3);

    public Date getDate(long columnIndex) {
        return new Date(this.nativeGetDateTime(this.nativePtr, columnIndex) * 1000L);
    }

    protected native long nativeGetDateTime(long var1, long var3);

    public String getString(long columnIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex);
    }

    protected native String nativeGetString(long var1, long var3);

    public byte[] getBinaryByteArray(long columnIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex);
    }

    protected native byte[] nativeGetByteArray(long var1, long var3);

    public Mixed getMixed(long columnIndex) {
        return this.nativeGetMixed(this.nativePtr, columnIndex);
    }

    public ColumnType getMixedType(long columnIndex) {
        return ColumnType.fromNativeValue(this.nativeGetMixedType(this.nativePtr, columnIndex));
    }

    protected native int nativeGetMixedType(long var1, long var3);

    protected native Mixed nativeGetMixed(long var1, long var3);

    public long getLink(long columnIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex);
    }

    protected native long nativeGetLink(long var1, long var3);

    public boolean isNullLink(long columnIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex);
    }

    protected native boolean nativeIsNullLink(long var1, long var3);

    public LinkView getLinkList(long columnIndex) {
        long nativeLinkViewPtr = this.nativeGetLinkView(this.nativePtr, columnIndex);
        return new LinkView(this.context, this.parent, columnIndex, nativeLinkViewPtr);
    }

    private native long nativeGetLinkView(long var1, long var3);

    public void setLong(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.getTable().checkIntValueIsLegal(columnIndex, this.getIndex(), value);
        this.nativeSetLong(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetLong(long var1, long var3, long var5);

    public void setBoolean(long columnIndex, boolean value) {
        this.parent.checkImmutable();
        this.nativeSetBoolean(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    public void setFloat(long columnIndex, float value) {
        this.parent.checkImmutable();
        this.nativeSetFloat(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetFloat(long var1, long var3, float var5);

    public void setDouble(long columnIndex, double value) {
        this.parent.checkImmutable();
        this.nativeSetDouble(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetDouble(long var1, long var3, double var5);

    public void setDate(long columnIndex, Date date) {
        this.parent.checkImmutable();
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        long timestamp = date.getTime() / 1000L;
        if (timestamp >= Integer.MAX_VALUE || timestamp <= Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Date/timestamp is outside valid range");
        }
        this.nativeSetDate(this.nativePtr, columnIndex, timestamp);
    }

    protected native void nativeSetDate(long var1, long var3, long var5);

    public void setString(long columnIndex, String value) {
        this.parent.checkImmutable();
        this.getTable().checkStringValueIsLegal(columnIndex, this.getIndex(), value);
        this.nativeSetString(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetString(long var1, long var3, String var5);

    public void setBinaryByteArray(long columnIndex, byte[] data) {
        this.parent.checkImmutable();
        if (data == null) {
            throw new IllegalArgumentException("Null array is not allowed");
        }
        this.nativeSetByteArray(this.nativePtr, columnIndex, data);
    }

    protected native void nativeSetByteArray(long var1, long var3, byte[] var5);

    public void setMixed(long columnIndex, Mixed data) {
        this.parent.checkImmutable();
        if (data == null) {
            throw new IllegalArgumentException("Null data is not allowed");
        }
        this.nativeSetMixed(this.nativePtr, columnIndex, data);
    }

    protected native void nativeSetMixed(long var1, long var3, Mixed var5);

    public void setLink(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.nativeSetLink(this.nativePtr, columnIndex, value);
    }

    protected native void nativeSetLink(long var1, long var3, long var5);

    public void nullifyLink(long columnIndex) {
        this.parent.checkImmutable();
        this.nativeNullifyLink(this.nativePtr, columnIndex);
    }

    protected native void nativeNullifyLink(long var1, long var3);

    protected static native void nativeClose(long var0);

    public boolean isAttached() {
        return this.nativePtr != 0L && this.nativeIsAttached(this.nativePtr);
    }

    protected native boolean nativeIsAttached(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                this.context.asyncDisposeRow(this.nativePtr);
                this.nativePtr = 0L;
            }
        }
        Row.nativeClose(this.nativePtr);
        this.nativePtr = 0L;
    }
}

