/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Context;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;

public class LinkView {
    private final Context context;
    private final long nativeLinkViewPtr;
    private final Table parent;
    private final long columnIndexInParent;

    public LinkView(Context context, Table parent, long columnIndexInParent, long nativeLinkViewPtr) {
        this.context = context;
        this.parent = parent;
        this.columnIndexInParent = columnIndexInParent;
        this.nativeLinkViewPtr = nativeLinkViewPtr;
    }

    protected static native void nativeClose(long var0);

    public Row get(long pos) {
        long nativeRowPtr = this.nativeGetRow(this.nativeLinkViewPtr, pos);
        return new Row(this.context, this.parent.getLinkTarget(this.columnIndexInParent), nativeRowPtr);
    }

    private native long nativeGetRow(long var1, long var3);

    public long getTargetRowIndex(long pos) {
        return this.nativeGetTargetRowIndex(this.nativeLinkViewPtr, pos);
    }

    private native long nativeGetTargetRowIndex(long var1, long var3);

    public void add(long rowIndex) {
        this.nativeAdd(this.nativeLinkViewPtr, rowIndex);
    }

    private native void nativeAdd(long var1, long var3);

    public void insert(long pos, long rowIndex) {
        this.nativeInsert(this.nativeLinkViewPtr, pos, rowIndex);
    }

    private native void nativeInsert(long var1, long var3, long var5);

    public void set(long pos, long rowIndex) {
        this.nativeSet(this.nativeLinkViewPtr, pos, rowIndex);
    }

    private native void nativeSet(long var1, long var3, long var5);

    public void move(long oldPos, long newPos) {
        this.nativeMove(this.nativeLinkViewPtr, oldPos, newPos);
    }

    private native void nativeMove(long var1, long var3, long var5);

    public void remove(long pos) {
        this.nativeRemove(this.nativeLinkViewPtr, pos);
    }

    private native void nativeRemove(long var1, long var3);

    public void clear() {
        this.nativeClear(this.nativeLinkViewPtr);
    }

    private native void nativeClear(long var1);

    public long size() {
        return this.nativeSize(this.nativeLinkViewPtr);
    }

    private native long nativeSize(long var1);

    public boolean isEmpty() {
        return this.nativeIsEmpty(this.nativeLinkViewPtr);
    }

    private native boolean nativeIsEmpty(long var1);

    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativeLinkViewPtr);
        try {
            return new TableQuery(this.context, this.parent, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    protected native long nativeWhere(long var1);
}

