/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.exceptions.RealmException;
import io.realm.internal.LinkView;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RealmList<E extends RealmObject>
extends AbstractList<E> {
    private static final String ONLY_IN_MANAGED_MODE_MESSAGE = "This method is only available in managed mode";
    private static final String NULL_OBJECTS_NOT_ALLOWED_MESSAGE = "RealmList does not accept null values";
    public static final String MANAGED_OBJECTS_NOT_ALLOWED_MESSAGE = "RealmObjects already managed by Realm cannot be added to RealmList in non-managed mode.";
    private final boolean managedMode;
    private Class<E> clazz;
    private LinkView view;
    private Realm realm;
    private List<E> nonManagedList;

    public RealmList() {
        this.managedMode = false;
        this.nonManagedList = new ArrayList();
    }

    public RealmList(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The objects argument cannot be null");
        }
        this.managedMode = false;
        this.nonManagedList = new ArrayList(objects.length);
        Collections.addAll(this.nonManagedList, objects);
    }

    RealmList(Class<E> clazz, LinkView view, Realm realm) {
        this.managedMode = true;
        this.clazz = clazz;
        this.view = view;
        this.realm = realm;
    }

    @Override
    public void add(int location, E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            this.view.insert(location, ((RealmObject)object).row.getIndex());
        } else {
            this.nonManagedList.add(location, object);
        }
    }

    @Override
    public boolean add(E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            this.view.add(((RealmObject)object).row.getIndex());
        } else {
            this.nonManagedList.add(object);
        }
        return true;
    }

    @Override
    public E set(int location, E object) {
        this.checkValidObject(object);
        if (this.managedMode) {
            if (((RealmObject)object).row == null) {
                throw new RealmException(ONLY_IN_MANAGED_MODE_MESSAGE);
            }
            this.view.set(location, ((RealmObject)object).row.getIndex());
        } else {
            this.nonManagedList.set(location, object);
        }
        return object;
    }

    public void move(int oldPos, int newPos) {
        if (this.managedMode) {
            this.view.move(oldPos, newPos);
        } else {
            this.checkIndex(oldPos);
            this.checkIndex(newPos);
            RealmObject object = (RealmObject)this.nonManagedList.remove(oldPos);
            if (newPos > oldPos) {
                this.nonManagedList.add(newPos - 1, object);
            } else {
                this.nonManagedList.add(newPos, object);
            }
        }
    }

    @Override
    public void clear() {
        if (this.managedMode) {
            this.view.clear();
        } else {
            this.nonManagedList.clear();
        }
    }

    @Override
    public E remove(int location) {
        if (this.managedMode) {
            Object removedItem = this.get(location);
            this.view.remove(location);
            return (E)removedItem;
        }
        return (E)((RealmObject)this.nonManagedList.remove(location));
    }

    @Override
    public E get(int location) {
        if (this.managedMode) {
            return this.realm.get(this.clazz, this.view.getTargetRowIndex(location));
        }
        return (E)((RealmObject)this.nonManagedList.get(location));
    }

    public E first() {
        if (this.managedMode && !this.view.isEmpty()) {
            return (E)this.get(0);
        }
        if (this.nonManagedList != null && this.nonManagedList.size() > 0) {
            return (E)((RealmObject)this.nonManagedList.get(0));
        }
        return null;
    }

    public E last() {
        if (this.managedMode && !this.view.isEmpty()) {
            return (E)this.get((int)this.view.size() - 1);
        }
        if (this.nonManagedList != null && this.nonManagedList.size() > 0) {
            return (E)((RealmObject)this.nonManagedList.get(this.nonManagedList.size() - 1));
        }
        return null;
    }

    @Override
    public int size() {
        if (this.managedMode) {
            return Long.valueOf(this.view.size()).intValue();
        }
        return this.nonManagedList.size();
    }

    public RealmQuery<E> where() {
        if (this.managedMode) {
            return new RealmQuery<E>(this.realm, this.view, this.clazz);
        }
        throw new RealmException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    private void checkValidObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException(NULL_OBJECTS_NOT_ALLOWED_MESSAGE);
        }
    }

    private void checkIndex(int location) {
        int size = this.size();
        if (location < 0 || location >= size) {
            throw new IndexOutOfBoundsException("Invalid index " + location + ", size is " + size);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.managedMode ? this.clazz.getSimpleName() : this.getClass().getSimpleName());
        sb.append("@[");
        for (int i = 0; i < this.size(); ++i) {
            if (this.managedMode) {
                sb.append(((RealmObject)this.get((int)i)).row.getIndex());
            } else {
                sb.append(System.identityHashCode(this.get(i)));
            }
            if (i >= this.size() - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }
}

