/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmConfiguration;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Util;
import javax.annotation.Nullable;

public class OsObjectStore {
    public static final long SCHEMA_NOT_VERSIONED = -1L;

    public static void setPrimaryKeyForObject(OsSharedRealm sharedRealm, String className, @Nullable String primaryKeyFieldName) {
        className = Util.getTablePrefix() + className;
        try {
            OsObjectStore.nativeSetPrimaryKeyForObject(sharedRealm.getNativePtr(), className, primaryKeyFieldName);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Nullable
    public static String getPrimaryKeyForObject(OsSharedRealm sharedRealm, String className) {
        className = Util.getTablePrefix() + className;
        return OsObjectStore.nativeGetPrimaryKeyForObject(sharedRealm.getNativePtr(), className);
    }

    public static void setSchemaVersion(OsSharedRealm sharedRealm, long schemaVersion) {
        OsObjectStore.nativeSetSchemaVersion(sharedRealm.getNativePtr(), schemaVersion);
    }

    public static long getSchemaVersion(OsSharedRealm sharedRealm) {
        return OsObjectStore.nativeGetSchemaVersion(sharedRealm.getNativePtr());
    }

    public static boolean deleteTableForObject(OsSharedRealm sharedRealm, String className) {
        return OsObjectStore.nativeDeleteTableForObject(sharedRealm.getNativePtr(), className);
    }

    public static boolean callWithLock(RealmConfiguration configuration, Runnable runnable) {
        return OsObjectStore.nativeCallWithLock(configuration.getPath(), runnable);
    }

    private static native void nativeSetPrimaryKeyForObject(long var0, String var2, @Nullable String var3);

    @Nullable
    private static native String nativeGetPrimaryKeyForObject(long var0, String var2);

    private static native void nativeSetSchemaVersion(long var0, long var2);

    private static native long nativeGetSchemaVersion(long var0);

    private static native boolean nativeDeleteTableForObject(long var0, String var2);

    private static native boolean nativeCallWithLock(String var0, Runnable var1);
}

